/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops;

import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.core.options.PortSide;

public enum SelfLoopType {
    NON_LOOP,
    SIDE,
    CORNER,
    OPPOSING,
    THREE_CORNER,
    FOUR_CORNER;


    public static SelfLoopType getEdgeType(SelfLoopEdge edge, SelfLoopNode nodeRep) {
        boolean leftDir;
        SelfLoopPort source = edge.getSource();
        PortSide sourceSide = source.getPortSide();
        SelfLoopPort target = edge.getTarget();
        if (target == null) {
            return NON_LOOP;
        }
        PortSide targetSide = target.getPortSide();
        boolean rightDir = source.getDirection() == SelfLoopRoutingDirection.RIGHT;
        boolean bl = leftDir = source.getDirection() == SelfLoopRoutingDirection.LEFT;
        if (source.getLPort().getNode() != target.getLPort().getNode()) {
            return NON_LOOP;
        }
        if (sourceSide == targetSide) {
            SelfLoopNodeSide nodeRepside = nodeRep.getNodeSide(sourceSide);
            int sourceIndex = nodeRepside.getPorts().indexOf(source);
            int targetIndex = nodeRepside.getPorts().indexOf(target);
            if (leftDir && sourceIndex < targetIndex || rightDir && targetIndex < sourceIndex) {
                return FOUR_CORNER;
            }
            return SIDE;
        }
        if (sourceSide.areAdjacent(targetSide)) {
            if (rightDir && source.getPortSide().left() == target.getPortSide() || leftDir && source.getDirection() == SelfLoopRoutingDirection.LEFT) {
                return THREE_CORNER;
            }
            return CORNER;
        }
        return OPPOSING;
    }
}

