/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.diffmerge;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.diffmerge.DiffToolMode;
import org.eclipse.egit.ui.internal.diffmerge.MergeToolMode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.diffmergetool.DiffTools;
import org.eclipse.jgit.internal.diffmergetool.MergeTools;
import org.eclipse.jgit.internal.diffmergetool.ToolException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public final class DiffMergeSettings {
    public static DiffToolMode getDiffToolMode() {
        return DiffToolMode.fromInt(DiffMergeSettings.getStore().getInt("diff_tool_mode"));
    }

    public static MergeToolMode getMergeToolMode() {
        return MergeToolMode.fromInt(DiffMergeSettings.getStore().getInt("merge_tool_mode"));
    }

    public static boolean useInternalDiffTool() {
        return DiffMergeSettings.getStore().getInt("diff_tool_mode") == DiffToolMode.INTERNAL.getValue();
    }

    public static boolean useInternalMergeTool() {
        return DiffMergeSettings.getStore().getInt("merge_tool_mode") == MergeToolMode.INTERNAL.getValue();
    }

    public static String getMergeToolName() {
        return DiffMergeSettings.getStore().getString("merge_tool_custom");
    }

    private static String getDiffToolName() {
        return DiffMergeSettings.getStore().getString("diff_tool_custom");
    }

    public static Set<String> getAvailableDiffTools() {
        DiffTools diffToolManager = new DiffTools((StoredConfig)DiffMergeSettings.loadUserConfig());
        return diffToolManager.getPredefinedAvailableTools();
    }

    public static Set<String> getAvailableMergeTools() {
        MergeTools mergeToolManager = new MergeTools((StoredConfig)DiffMergeSettings.loadUserConfig());
        return mergeToolManager.getPredefinedAvailableTools();
    }

    public static Optional<String> getDiffToolName(Repository repository, String relativeFilePath) {
        DiffToolMode diffToolMode = DiffMergeSettings.getDiffToolMode();
        Optional<String> toolName = Optional.empty();
        if (diffToolMode == DiffToolMode.INTERNAL) {
            return toolName;
        }
        if (diffToolMode == DiffToolMode.EXTERNAL_FOR_TYPE || diffToolMode == DiffToolMode.GIT_CONFIG) {
            try {
                toolName = new DiffTools(repository).getExternalToolFromAttributes(relativeFilePath);
            }
            catch (ToolException e) {
                Activator.handleError(UIText.CompareUtils_GitConfigurationErrorText, e, true);
            }
        }
        if (!toolName.isPresent() && diffToolMode == DiffToolMode.GIT_CONFIG) {
            toolName = DiffMergeSettings.readExternalToolFromGitConfig(c -> DiffMergeSettings.getDiffToolFromGitConfig(c), repository);
        }
        if (diffToolMode == DiffToolMode.EXTERNAL) {
            toolName = Optional.of(DiffMergeSettings.getDiffToolName());
        }
        return toolName;
    }

    public static Optional<String> getMergeToolName(Repository repository, String relativeFilePath) {
        MergeToolMode mergeToolMode = DiffMergeSettings.getMergeToolMode();
        Optional<String> toolName = Optional.empty();
        if (mergeToolMode == MergeToolMode.INTERNAL) {
            return toolName;
        }
        if (mergeToolMode == MergeToolMode.EXTERNAL_FOR_TYPE || mergeToolMode == MergeToolMode.GIT_CONFIG) {
            try {
                toolName = new MergeTools(repository).getExternalToolFromAttributes(relativeFilePath);
            }
            catch (ToolException e) {
                Activator.handleError(UIText.CompareUtils_GitConfigurationErrorText, e, true);
            }
        }
        if (!toolName.isPresent() && mergeToolMode == MergeToolMode.GIT_CONFIG && (toolName = DiffMergeSettings.readExternalToolFromGitConfig(c -> DiffMergeSettings.getMergeToolFromGitConfig(c), repository)).isEmpty()) {
            toolName = Optional.of("");
            Activator.handleError(UIText.MergeToolActionHandler_noToolConfiguredDialogTitle, null, true);
        }
        if (mergeToolMode == MergeToolMode.EXTERNAL) {
            toolName = Optional.of(DiffMergeSettings.getMergeToolName());
        }
        return toolName;
    }

    private static Optional<String> readExternalToolFromGitConfig(Function<StoredConfig, String> readConfiguredExternalTool, Repository repository) {
        StoredConfig repoConfig = repository.getConfig();
        String externalTool = readConfiguredExternalTool.apply(repoConfig);
        return Optional.ofNullable(externalTool);
    }

    private static String getDiffToolFromGitConfig(StoredConfig config) {
        DiffTools diffToolManager = new DiffTools(config);
        return diffToolManager.getDefaultToolName(false);
    }

    private static String getMergeToolFromGitConfig(StoredConfig config) {
        MergeTools mergeToolManager = new MergeTools(config);
        return mergeToolManager.getDefaultToolName(false);
    }

    private static FileBasedConfig loadUserConfig() {
        FileBasedConfig config = SystemReader.getInstance().openUserConfig(null, FS.DETECTED);
        try {
            config.load();
        }
        catch (IOException | ConfigInvalidException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        return config;
    }

    private static IPreferenceStore getStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    @Nullable
    public static String getDiffToolCommandFromPreferences(String filePath) {
        String fileExtension;
        DiffToolMode diffToolMode = DiffMergeSettings.getDiffToolMode();
        if (diffToolMode == DiffToolMode.EXTERNAL_FOR_TYPE && !StringUtils.isEmptyOrNull((String)(fileExtension = DiffMergeSettings.getFileExtension(filePath)))) {
            String preference = DiffMergeSettings.getExternalDiffToolPreference();
            String[] tools = preference.split(",");
            int i = 0;
            while (i < tools.length) {
                String extension = tools[i].trim();
                String command = tools[i + 1].trim();
                if (Objects.equals(extension, fileExtension)) {
                    return command;
                }
                i += 2;
            }
        }
        return null;
    }

    public static String getExternalDiffToolPreference() {
        String preference = Platform.getPreferencesService().getString("org.eclipse.egit.ui", "external_diff_tool_per_extension", "", null);
        return preference;
    }

    public static String getFileExtension(String path) {
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        if (index == path.length() - 1) {
            return "";
        }
        return path.substring(index + 1);
    }
}

