/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ftask.tasks;

import java.util.List;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.ftask.task.ValidationInvocationException;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.pattern.ftask.tasks.DomainDrivenStrategyTask;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;

public class DomainDrivenValidationStrategyTask
extends DomainDrivenStrategyTask {
    private static final String DIAGNOSTIC = "diagnostic";

    protected void readContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        super.readContext(context, ctx);
        List objects = (List)ctx.getValue("domain");
        Diagnostic diagnostic = null;
        Diagnostician diagnostician = new Diagnostician();
        for (EObject eObject : objects) {
            if (diagnostic == null) {
                diagnostic = diagnostician.validate(eObject);
                continue;
            }
            diagnostician.validate(eObject, (DiagnosticChain)diagnostic);
        }
        ctx.setValue(DIAGNOSTIC, diagnostic);
    }

    protected void writeContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        super.writeContext(context, ctx);
        Diagnostic diagnostic = (Diagnostic)context.getOutputValue((Object)DIAGNOSTIC, Object.class);
        if (diagnostic.getSeverity() >= 2) {
            ValidationInvocationException validationInvocationException = new ValidationInvocationException("Validation Error detected in " + context.getName());
            validationInvocationException.setDiagnostic(diagnostic);
            throw validationInvocationException;
        }
    }
}

