/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.pages;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.ui.helper.EditorHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.editors.adapter.LiveValidationContentAdapter;
import org.eclipse.egf.pattern.ui.editors.dialogs.ContainerLibrarySelectionDialog;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OverviewPage
extends PatternEditorPage {
    public static final String ID = "org.eclipse.egf.pattern.ui.editors.pages.overview.page.id";
    private FormEditor editor;
    private Text patternNameText;
    private Text fullLibraryNameText;
    private Text description;
    private Button browse;
    private FormColors colors = new FormColors(Display.getDefault());
    private LiveValidationContentAdapter patternNameEmptyValidationAdapter;
    private IMessageManager messageManager;

    public OverviewPage(FormEditor editor) {
        super(editor, ID, Messages.OverviewPage_title);
        this.editor = editor;
    }

    protected void checkReadOnlyModel() {
        if (this.isReadOnly()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    private void setEnabled(boolean enabled) {
        this.patternNameText.setEnabled(enabled);
        this.fullLibraryNameText.setEnabled(enabled);
        this.description.setEnabled(enabled);
        this.browse.setEnabled(enabled);
    }

    protected void doCreateFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.messageManager = managedForm.getMessageManager();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        Composite body = managedForm.getForm().getBody();
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        body.setLayout((Layout)twl);
        form.setImage(Activator.getDefault().getImage("obj16/plugin_mf_obj.gif"));
        form.setText(Messages.OverviewPage_title);
        this.createLeftContainer(toolkit, body);
        this.createRightContainer(toolkit, body);
        this.createDescriptionContainer(toolkit, body);
        form.reflow(true);
    }

    private void createLeftContainer(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.OverviewPage_sectionLeft_title);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        Composite container = toolkit.createComposite((Composite)section, 0);
        container.setLayoutData((Object)new TableWrapData(256));
        container.setLayout((Layout)new TableWrapLayout());
        Label title = toolkit.createLabel(container, Messages.OverviewPage_sectionLeft_title_label, 64);
        title.setLayoutData((Object)new TableWrapData(256));
        this.createPatternInfoContainer(toolkit, container);
        section.setClient((Control)container);
    }

    private void createPatternInfoContainer(FormToolkit toolkit, Composite parent) {
        Composite container = toolkit.createComposite(parent, 0);
        container.setLayoutData((Object)new TableWrapData(256));
        container.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = toolkit.createLabel(container, Messages.OverviewPage_sectionLeft_name_label, 64);
        GridData gd = new GridData();
        gd.widthHint = 80;
        nameLabel.setLayoutData((Object)gd);
        nameLabel.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        this.patternNameText = toolkit.createText(container, this.getPattern() == null ? "" : this.getPattern().getName(), 2048);
        gd = new GridData(768);
        gd.widthHint = 20;
        gd.horizontalIndent = 5;
        gd.horizontalSpan = 2;
        this.patternNameText.setLayoutData((Object)gd);
        Label fullNameLabel = toolkit.createLabel(container, Messages.OverviewPage_sectionLeft_fullName_label, 64);
        gd = new GridData();
        gd.widthHint = 80;
        fullNameLabel.setLayoutData((Object)gd);
        fullNameLabel.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        Color color = Display.getDefault().getSystemColor(16);
        String fullLibraryName = PatternHelper.getFullLibraryName((Pattern)this.getPattern());
        this.fullLibraryNameText = toolkit.createText(container, fullLibraryName == null ? "" : fullLibraryName, 2056);
        gd = new GridData(768);
        gd.horizontalIndent = 5;
        this.fullLibraryNameText.setLayoutData((Object)gd);
        this.fullLibraryNameText.setForeground(color);
        this.browse = toolkit.createButton(container, Messages.OverviewPage_button_browse, 8);
        gd = new GridData();
        gd.widthHint = 65;
        this.browse.setLayoutData((Object)gd);
        this.browse.setEnabled(false);
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContainerLibrarySelectionDialog dialog = new ContainerLibrarySelectionDialog(new Shell(), OverviewPage.this.getPattern().getContainer());
                dialog.setTitle(Messages.OverviewPage_browse_dialog_title);
                if (dialog.open() == 0) {
                    final PatternLibrary patternLibrary = dialog.getLibraryContainer();
                    TransactionalEditingDomain editingDomain = OverviewPage.this.getEditingDomain();
                    RecordingCommand cmd = new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            Pattern pattern = OverviewPage.this.getPattern();
                            pattern.setContainer(patternLibrary);
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)cmd);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label idLabel = toolkit.createLabel(container, Messages.OverviewPage_sectionLeft_id_label, 64);
        gd = new GridData();
        idLabel.setLayoutData((Object)gd);
        idLabel.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        Text idText = toolkit.createText(container, this.getPattern() == null ? "" : this.getPattern().getID(), 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 20;
        gd.horizontalIndent = 5;
        idText.setLayoutData((Object)gd);
        idText.setForeground(color);
    }

    private void createDescriptionContainer(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.OverviewPage_sectionLeft_description_label_title);
        TableWrapData twd = new TableWrapData(128);
        twd.colspan = 2;
        section.setLayoutData((Object)twd);
        section.setLayout((Layout)new TableWrapLayout());
        Composite container = toolkit.createComposite((Composite)section, 0);
        container.setLayoutData((Object)new TableWrapData(256));
        container.setLayout((Layout)new TableWrapLayout());
        Label title = toolkit.createLabel(container, Messages.OverviewPage_sectionLeft_description_label, 64);
        title.setLayoutData((Object)new TableWrapData(256));
        String patternDescription = this.getPattern() == null ? "" : this.getPattern().getDescription();
        this.description = toolkit.createText(container, patternDescription, 2880);
        twd = new TableWrapData(256);
        twd.heightHint = 280;
        this.description.setLayoutData((Object)twd);
        section.setClient((Control)container);
    }

    private void createRightContainer(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.OverviewPage_sectionRight_title);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        Composite container = toolkit.createComposite((Composite)section, 0);
        container.setLayoutData((Object)new TableWrapData(256));
        container.setLayout((Layout)new TableWrapLayout());
        Label title = toolkit.createLabel(container, Messages.OverviewPage_sectionRight_title_label, 64);
        title.setLayoutData((Object)new TableWrapData(256));
        Composite containerLink = toolkit.createComposite(container, 0);
        containerLink.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        containerLink.setLayout((Layout)twl);
        ImageHyperlink specLink = toolkit.createImageHyperlink(containerLink, 0);
        specLink.setText(Messages.OverviewPage_sectionRight_specLink_label);
        specLink.setImage(Activator.getDefault().getImage("obj16/localvariable_obj.gif"));
        specLink.setLayoutData((Object)new TableWrapData(256));
        specLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.editor.setActivePage("org.eclipse.egf.pattern.ui.editors.pages.specification.page.id");
            }
        });
        Label specLabel = toolkit.createLabel(containerLink, Messages.OverviewPage_sectionRight_spec_label, 64);
        specLabel.setLayoutData((Object)new TableWrapData(256));
        ImageHyperlink implLink = toolkit.createImageHyperlink(containerLink, 0);
        implLink.setText(Messages.OverviewPage_sectionRight_implLink_label);
        implLink.setImage(Activator.getDefault().getImage("obj16/methpub_obj.gif"));
        implLink.setLayoutData((Object)new TableWrapData(256));
        implLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.editor.setActivePage("org.eclipse.egf.pattern.ui.editors.pages.implementation.page.id");
            }
        });
        Label implLabel = toolkit.createLabel(containerLink, Messages.OverviewPage_sectionRight_impl_label, 64);
        implLabel.setLayoutData((Object)new TableWrapData(256));
        ImageHyperlink selectLink = toolkit.createImageHyperlink(containerLink, 0);
        selectLink.setText(Messages.OverviewPage_sectionRight_selectLink_label);
        selectLink.setImage(EGFCoreUIPlugin.getDefault().getImage("obj16/fcore.gif"));
        selectLink.setLayoutData((Object)new TableWrapData(256));
        selectLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                try {
                    IEditorPart part;
                    URI uri = EcoreUtil.getURI((EObject)OverviewPage.this.getPattern());
                    if (uri != null && (part = EditorHelper.openEditor((URI)OverviewPage.this.getPattern().eResource().getResourceSet().getURIConverter().normalize(uri), (String)"org.eclipse.egf.model.fcore.presentation.fcore.editor.id")) != null && part instanceof IEditingDomainProvider) {
                        EditorHelper.setSelectionToViewer((IEditorPart)part, (URI)uri);
                    }
                }
                catch (PartInitException pie) {
                    ThrowableHandler.handleThrowable((String)Activator.getDefault().getPluginID(), (Throwable)pie);
                }
            }
        });
        Label selectLabel = toolkit.createLabel(containerLink, Messages.OverviewPage_sectionRight_select_label, 64);
        selectLabel.setLayoutData((Object)new TableWrapData(256));
        section.setClient((Control)container);
    }

    void bindName() {
        Pattern pattern = this.getPattern();
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME);
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        ISWTObservableValue uiObs = textProp.observeDelayed(400, (Widget)this.patternNameText);
        IObservableValue mObs = mprop.observe((Object)pattern);
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        }), null));
    }

    void bindDescripition() {
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)FcorePackage.Literals.MODEL_ELEMENT__DESCRIPTION);
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        ISWTObservableValue uiObs = textProp.observeDelayed(400, (Widget)this.description);
        IObservableValue mObs = mprop.observe((Object)this.getPattern());
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        }), null));
    }

    void bindContainer() {
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)PatternPackage.Literals.PATTERN__CONTAINER);
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        ISWTObservableValue uiObs = textProp.observeDelayed(400, (Widget)this.fullLibraryNameText);
        IObservableValue mObs = mprop.observe((Object)this.getPattern());
        UpdateValueStrategy targetToModel = new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        });
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return EReference.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject == null || !(fromObject instanceof PatternLibrary)) {
                    return "";
                }
                return ((PatternLibrary)fromObject).getName();
            }
        });
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, targetToModel, modelToTarget));
    }

    protected void bind() {
        if (this.getPattern() != null) {
            this.bindName();
            this.bindDescripition();
            this.bindContainer();
            this.patternNameEmptyValidationAdapter = PatternUIHelper.addValidationAdapter(this.messageManager, this.getPattern(), "org.eclipse.egf.pattern.ui.PatternNameNotEmpty", (Control)this.patternNameText);
        }
        this.checkReadOnlyModel();
    }

    public void dispose() {
        PatternUIHelper.removeAdapterForPattern(this.getPattern(), (AdapterImpl)this.patternNameEmptyValidationAdapter);
        this.colors.dispose();
        super.dispose();
    }
}

