/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.query;

import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.egf.core.platform.pde.PlatformExtensionPointURI;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFactory
implements IPlatformExtensionPointFactory<QueryKind> {
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    private static final String NAME_ATTR = "name";

    public QueryKind createExtensionPoint(IPlatformBundle platformBundle, Object object) {
        if (object instanceof IPluginElement) {
            return this.create(platformBundle, (IPluginElement)object);
        }
        if (object instanceof IConfigurationElement) {
            return this.create(platformBundle, (IConfigurationElement)object);
        }
        throw new UnsupportedOperationException();
    }

    private QueryKind create(IPlatformBundle platformBundle, IPluginElement element) {
        if (element == null) {
            return null;
        }
        IPluginAttribute id = element.getAttribute(ID_ATTR);
        if (id == null || id.getValue() == null || id.getValue().trim().length() == 0) {
            return null;
        }
        IPluginAttribute className = element.getAttribute(CLASS_ATTR);
        if (className == null || className.getValue() == null || className.getValue().trim().length() == 0) {
            return null;
        }
        IPluginAttribute name = element.getAttribute(NAME_ATTR);
        if (name == null || name.getValue() == null || name.getValue().trim().length() == 0) {
            return null;
        }
        return new QueryKindImpl(platformBundle, id.getValue(), className.getValue(), name.getValue());
    }

    private QueryKind create(IPlatformBundle platformBundle, IConfigurationElement element) {
        String id;
        if (element == null) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if ((id = element.getAttribute(ID_ATTR)) == null || id.trim().length() == 0) {
            return null;
        }
        String className = element.getAttribute(CLASS_ATTR);
        if (className == null || className.trim().length() == 0) {
            return null;
        }
        String name = element.getAttribute(NAME_ATTR);
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        return new QueryKindImpl(platformBundle, id, uniqueIdentifier, handleId, className, name);
    }

    private static class QueryKindImpl
    extends PlatformExtensionPointURI
    implements QueryKind {
        private final String _className;
        private final String _name;

        public QueryKindImpl(IPlatformBundle bundle, String id, String className, String name) {
            super(bundle, id);
            Assert.isNotNull((Object)className);
            Assert.isLegal((className.trim().length() != 0 ? 1 : 0) != 0);
            Assert.isNotNull((Object)name);
            Assert.isLegal((name.trim().length() != 0 ? 1 : 0) != 0);
            this._className = className.trim();
            this._name = name.trim();
        }

        public QueryKindImpl(IPlatformBundle bundle, String id, String uniqueIdentifier, int handleId, String className, String name) {
            super(bundle, id, uniqueIdentifier, handleId);
            Assert.isNotNull((Object)className);
            Assert.isLegal((className.trim().length() != 0 ? 1 : 0) != 0);
            Assert.isNotNull((Object)name);
            Assert.isLegal((name.trim().length() != 0 ? 1 : 0) != 0);
            this._className = className.trim();
            this._name = name.trim();
        }

        public String getClassName() {
            return this._className;
        }

        public String getName() {
            return this._name;
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof QueryKind)) {
                return false;
            }
            QueryKind queryKind = (QueryKind)object;
            if (!queryKind.getClassName().equals(this.getClassName())) {
                return false;
            }
            return queryKind.getName().equals(this.getName());
        }
    }
}

