/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.egf.pattern.query.IQuery;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicQueryDelegate
implements IQuery {
    @Override
    public List<Object> execute(IQuery.ParameterDescription parameter, Map<String, String> queryCtx, PatternContext context) {
        String type = parameter.getType();
        Object loadClass = ParameterTypeHelper.INSTANCE.loadClass(type);
        if (!(loadClass instanceof EClass)) {
            throw new IllegalStateException(EGFPatternMessages.query_error1);
        }
        Collection<EObject> domain = this.getDomain(context);
        if (domain == null) {
            throw new IllegalStateException(EGFPatternMessages.query_error8);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        TreeIterator allContentsIterator = EcoreUtil.getAllContents(domain);
        while (allContentsIterator.hasNext()) {
            EObject eObject = (EObject)allContentsIterator.next();
            URI parameterTypeURI = EcoreUtil.getURI((EObject)((EObject)loadClass));
            URI eObjectClassURI = EcoreUtil.getURI((EObject)eObject.eClass());
            if (eObjectClassURI.equals((Object)parameterTypeURI)) {
                result.add(eObject);
            }
            for (EClass superClass : eObject.eClass().getEAllSuperTypes()) {
                URI eSuperClassURI = EcoreUtil.getURI((EObject)superClass);
                if (!eSuperClassURI.equals((Object)parameterTypeURI)) continue;
                result.add(eObject);
            }
        }
        return result;
    }

    protected Collection<EObject> getDomain(PatternContext context) {
        return (Collection)context.getValue("domain");
    }
}

