/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.editor;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.extension.PatternFactory;
import org.eclipse.egf.pattern.ui.editors.pages.ImplementationPage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MethodsComboBoxViewerCellEditor
extends ComboBoxViewerCellEditor {
    ComboViewer viewer;
    static Object selectedValue;
    TransactionalEditingDomain editingDomain;
    TableViewer tableViewer;
    ImplementationPage implementationPage;
    CCombo comboBox;
    boolean isModify = false;
    boolean changeSelection = false;

    public MethodsComboBoxViewerCellEditor(Composite parent, TransactionalEditingDomain editingDomain, TableViewer tableViewer, ImplementationPage implementationPage) {
        super(parent);
        this.editingDomain = editingDomain;
        this.tableViewer = tableViewer;
        this.implementationPage = implementationPage;
    }

    protected Control createControl(Composite parent) {
        super.createControl(parent);
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.viewer = new ComboViewer(this.comboBox);
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MethodsComboBoxViewerCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                MethodsComboBoxViewerCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = MethodsComboBoxViewerCellEditor.this.viewer.getSelection();
                selectedValue = selection.isEmpty() ? null : ((IStructuredSelection)selection).getFirstElement();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MethodsComboBoxViewerCellEditor.this.focusLost();
                String text = MethodsComboBoxViewerCellEditor.this.comboBox.getText();
                MethodsComboBoxViewerCellEditor.this.executeModifyMethod(text);
                MethodsComboBoxViewerCellEditor.this.isModify = false;
            }
        });
        this.comboBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = MethodsComboBoxViewerCellEditor.this.comboBox.getText();
                MethodsComboBoxViewerCellEditor.this.isModify = true;
                Button editButton = MethodsComboBoxViewerCellEditor.this.implementationPage.getEditButton();
                if (editButton != null && !editButton.isDisposed()) {
                    editButton.setEnabled(!PatternFactory.isSpecialMethod((String)text) && !"".equals(text));
                }
            }
        });
        return this.comboBox;
    }

    private void executeModifyMethod(final String newName) {
        if (newName != null && !"".equals(newName) && this.isModify) {
            int selectionIndex = this.tableViewer.getTable().getSelectionIndex();
            if (selectionIndex < 0) {
                return;
            }
            final PatternMethod method = (PatternMethod)this.tableViewer.getElementAt(selectionIndex);
            RecordingCommand cmd = new RecordingCommand(this.editingDomain){

                protected void doExecute() {
                    method.setName(newName);
                    MethodsComboBoxViewerCellEditor.this.tableViewer.refresh();
                }
            };
            this.editingDomain.getCommandStack().execute((Command)cmd);
        }
    }

    protected Object doGetValue() {
        return selectedValue;
    }

    protected void doSetFocus() {
        this.viewer.getControl().setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.viewer.getControl());
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.viewer != null ? 1 : 0) != 0);
        selectedValue = value;
        if (value == null) {
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this.changeSelection = true;
        } else if (this.isIncomboBoxlist(value)) {
            this.viewer.setSelection((ISelection)new StructuredSelection(value));
            this.changeSelection = true;
        } else {
            this.changeSelection = false;
        }
    }

    private boolean isIncomboBoxlist(Object value) {
        String[] items;
        String[] stringArray = items = this.comboBox.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.viewer.setLabelProvider(labelProvider);
    }

    public void setContenProvider(IStructuredContentProvider provider) {
        this.viewer.setContentProvider((IContentProvider)provider);
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    public ComboViewer getViewer() {
        return this.viewer;
    }

    void applyEditorValueAndDeactivate() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            selectedValue = null;
        } else if (this.changeSelection) {
            selectedValue = ((IStructuredSelection)selection).getFirstElement();
        }
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            MessageFormat.format(this.getErrorMessage(), selectedValue);
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.keyCode == 127) {
            this.performDelete();
        }
    }

    public void performDelete() {
        Point selection = this.comboBox.getSelection();
        int y = selection.y;
        int x = selection.x;
        String text = this.comboBox.getText();
        if (y - x > text.length() || y - x == 0) {
            return;
        }
        String header = text.substring(0, x);
        String footer = text.substring(y);
        String wordAfterDelete = String.valueOf(header) + footer;
        this.comboBox.setText(wordAfterDelete);
        Point p = new Point(x, x);
        this.comboBox.setSelection(p);
    }
}

