/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.generator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.JMember;
import org.eclipse.emf.codegen.merge.java.facade.JMethod;
import org.eclipse.emf.codegen.merge.java.facade.JNode;

public class EGFJMerger
extends JMerger {
    public EGFJMerger(JControlModel controlModel) {
        super(controlModel);
    }

    protected void applyPullRules(JNode sourceNode, JNode targetNode) {
        try {
            for (JControlModel.PullRule pullRule : this.getControlModel().getPullRules()) {
                if (pullRule.getSourceGetFeature().getFeatureMethod() == null || !pullRule.getSourceGetFeature().getFeatureClass().isInstance(sourceNode) || pullRule.getTargetPutFeature().getFeatureMethod() == null || !pullRule.getTargetPutFeature().getFeatureClass().isInstance(targetNode) || !this.sourcePatternDictionary.isMarkedUp(pullRule.getSourceMarkup(), pullRule.getSourceParentMarkup(), sourceNode) || !this.targetPatternDictionary.isMarkedUp(pullRule.getTargetMarkup(), pullRule.getTargetParentMarkup(), targetNode)) continue;
                if (pullRule.getEqualityFeature() != null) {
                    Method equalityFeatureMethod = pullRule.getEqualityFeature().getFeatureMethod();
                    Object value1 = equalityFeatureMethod.invoke((Object)sourceNode, NO_ARGUMENTS);
                    Object value2 = equalityFeatureMethod.invoke((Object)targetNode, NO_ARGUMENTS);
                    if (value1 == null ? value2 != null : !value1.equals(value2)) continue;
                }
                Method sourceGetMethod = pullRule.getSourceGetFeature().getFeatureMethod();
                Object value = sourceGetMethod.invoke((Object)sourceNode, NO_ARGUMENTS);
                Method targetPutMethod = pullRule.getTargetPutFeature().getFeatureMethod();
                if (!sourceGetMethod.getReturnType().isArray() || targetPutMethod.getParameterTypes()[0].isAssignableFrom(sourceGetMethod.getReturnType())) {
                    Object[] targetParameterTypes;
                    Pattern sourceTransfer;
                    if (value instanceof String) {
                        String oldStringValue;
                        String stringValue = (String)value;
                        stringValue = this.getControlModel().getFacadeHelper().applyFormatRules(stringValue);
                        sourceTransfer = pullRule.getSourceTransfer();
                        if (sourceTransfer != null && !targetPutMethod.getName().equals("setSuperclass") && (oldStringValue = (String)sourceGetMethod.invoke((Object)targetNode, NO_ARGUMENTS)) != null) {
                            Matcher sourceMatcher = sourceTransfer.matcher(stringValue);
                            Matcher targetMatcher = sourceTransfer.matcher(oldStringValue);
                            if (sourceMatcher.groupCount() >= 1 && targetMatcher.groupCount() >= 1) {
                                StringBuilder result = new StringBuilder();
                                int index = 0;
                                int sourceStart = 0;
                                int targetStart = 0;
                                if (sourceTransfer.pattern().startsWith("(\\s*<!--")) {
                                    sourceStart = this.getStartIndex(stringValue);
                                    targetStart = this.getStartIndex(oldStringValue);
                                }
                                boolean match = sourceMatcher.find(sourceStart) && targetMatcher.find(targetStart);
                                while (match) {
                                    result.append(stringValue.substring(index, sourceMatcher.start(1)));
                                    result.append(targetMatcher.group(1));
                                    index = sourceMatcher.end(1);
                                    boolean bl = match = sourceMatcher.find() && targetMatcher.find();
                                }
                                if (result.length() == 0) {
                                    stringValue = null;
                                } else {
                                    result.append(stringValue.substring(index));
                                    stringValue = result.toString();
                                }
                            } else {
                                stringValue = null;
                            }
                        }
                        value = stringValue;
                    }
                    if (value == null && !targetPutMethod.getName().equals("setInitializer") && !targetPutMethod.getName().equals("setSuperclass") && !targetPutMethod.getName().equals("setExceptions")) continue;
                    Object oldValue = sourceGetMethod.invoke((Object)targetNode, NO_ARGUMENTS);
                    if (value != null ? value.equals(oldValue) : oldValue == null) continue;
                    if (value instanceof Object[] && oldValue instanceof Object[] && Arrays.equals((Object[])value, (Object[])oldValue)) continue;
                    if (targetPutMethod.getName().equals("setSuperclass")) {
                        if (oldValue != null && value != null && ((String)oldValue).trim().equals(((String)value).trim())) continue;
                        sourceTransfer = pullRule.getSourceTransfer();
                        String comment = ((JMember)targetNode).getComment();
                        if (sourceTransfer != null && comment != null) {
                            Matcher matcher = sourceTransfer.matcher(comment);
                            while (matcher.find() && matcher.groupCount() >= 1) {
                                String clientStrings = comment.substring(matcher.start(matcher.groupCount()), matcher.end(matcher.groupCount()));
                                StringTokenizer stringTokenizer = new StringTokenizer(clientStrings, ", \t\n\r\f");
                                while (stringTokenizer.hasMoreTokens()) {
                                    value = stringTokenizer.nextToken();
                                }
                            }
                        }
                    }
                    if (sourceGetMethod.getName().equals("getReturnType") && this.getControlModel().getBlockPattern() != null && ((JMethod)targetNode).getComment() != null && this.getControlModel().getBlockPattern().matcher(((JMethod)targetNode).getComment()).find()) continue;
                    targetPutMethod.invoke((Object)targetNode, value);
                    this.targetCompilationChanged = true;
                    if (!targetPutMethod.getName().equals("setBody") || !(sourceNode instanceof JMethod)) continue;
                    JMethod sourceMethod = (JMethod)sourceNode;
                    JMethod targetMethod = (JMethod)targetNode;
                    Object[] sourceParameterTypes = sourceMethod.getParameterTypes();
                    if (Arrays.equals(sourceParameterTypes, targetParameterTypes = targetMethod.getParameterTypes())) {
                        targetMethod.setParameterNames(sourceMethod.getParameterNames());
                        continue;
                    }
                    targetMethod.setParameters(sourceMethod.getParameters());
                    continue;
                }
                ArrayList<String> additionalStrings = new ArrayList<String>();
                String[] sourceStrings = (String[])value;
                if (sourceStrings != null) {
                    additionalStrings.addAll(Arrays.asList(sourceStrings));
                }
                if (targetPutMethod.getName().equals("addSuperInterface")) {
                    Pattern sourceTransfer = pullRule.getSourceTransfer();
                    String comment = ((JMember)targetNode).getComment();
                    if (sourceTransfer != null && comment != null) {
                        Matcher matcher = sourceTransfer.matcher(comment);
                        while (matcher.find() && matcher.groupCount() >= 1) {
                            String clientStrings = comment.substring(matcher.start(matcher.groupCount()), matcher.end(matcher.groupCount()));
                            StringTokenizer stringTokenizer = new StringTokenizer(clientStrings, ", \t\n\r\f");
                            while (stringTokenizer.hasMoreTokens()) {
                                String token = stringTokenizer.nextToken();
                                if (additionalStrings.contains(token)) continue;
                                additionalStrings.add(token);
                            }
                        }
                    }
                    Object[] oldSuperInterfaces = (String[])sourceGetMethod.invoke((Object)targetNode, new Object[0]);
                    Object[] superInterfaces = additionalStrings.toArray(new String[additionalStrings.size()]);
                    if (!(oldSuperInterfaces == null ? superInterfaces.length != 0 : !Arrays.equals(oldSuperInterfaces, superInterfaces))) continue;
                    Method putMethod = targetNode.getClass().getMethod("setSuperInterfaces", String[].class);
                    putMethod.invoke((Object)targetNode, new Object[]{superInterfaces});
                    this.targetCompilationChanged = true;
                    continue;
                }
                String[] oldStringValues = (String[])sourceGetMethod.invoke((Object)targetNode, NO_ARGUMENTS);
                List<Object> old = oldStringValues == null ? Collections.emptyList() : Arrays.asList(oldStringValues);
                for (String string : additionalStrings) {
                    if (old.contains(string)) continue;
                    targetPutMethod.invoke((Object)targetNode, string);
                    this.targetCompilationChanged = true;
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private int getStartIndex(String string) {
        int index = string.indexOf("<!--");
        if (index > 0) {
            while (Character.isWhitespace(string.charAt(--index)) && index > 0) {
            }
            return index;
        }
        return 0;
    }
}

