/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.console;

import org.eclipse.egf.common.ui.activator.EGFAbstractUIPlugin;
import org.eclipse.egf.console.internal.ColorManager;
import org.eclipse.egf.console.internal.Console;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

public class EGFConsolePlugin
extends EGFAbstractUIPlugin {
    private static EGFConsolePlugin __plugin;
    private Console _console;

    public static Console getConsole() {
        return EGFConsolePlugin.getDefault().getInnerConsole();
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)EGFConsolePlugin.getDefault().getPreferenceStore(), (String)type));
    }

    protected Console getInnerConsole() {
        return this._console;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
        if (PlatformUI.isWorkbenchRunning()) {
            try {
                this._console = new Console();
            }
            catch (RuntimeException re) {
                this.logError("Errors occurred starting the EGF console", re);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                ColorManager.getDefault().dispose();
                if (this._console != null) {
                    this._console.shutdown();
                }
            }
            __plugin = null;
        }
        finally {
            super.stop(context);
        }
    }

    public static EGFConsolePlugin getDefault() {
        return __plugin;
    }
}

