/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.fx.ui.panes.GridData;
import org.eclipse.fx.ui.panes.GridLayoutPane;
import org.eclipse.fx.ui.workbench.renderers.base.BaseCompositePartRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCompositePart;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.DefPartRenderer;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.SortedBorderPane;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DefCompositePartRenderer
extends BaseCompositePartRenderer<Node> {
    protected Class<? extends WCompositePart<Node>> getWidgetClass(MCompositePart container) {
        if (container.getTags().contains("fx_fixedLayout")) {
            return WFixedSashImpl.class;
        }
        return WResizableSashImpl.class;
    }

    static abstract class AbstractCompositePartImpl<T extends Node>
    extends WLayoutedWidgetImpl<T, Node, MCompositePart>
    implements WCompositePart<Node> {
        AnchorPane contentArea;
        BorderPane dataArea;
        StackPane toolbarGroup;
        Group menuGroup;
        private final MCompositePart domElement;

        public AbstractCompositePartImpl(MCompositePart domElement) {
            this.domElement = domElement;
        }

        public void setToolbar(WToolBar<Node> toolbar) {
            if (toolbar == null) {
                this.clearToolBar();
            } else {
                this.initToolbarMenu();
                Node n = (Node)toolbar.getWidget();
                n.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        MPart element = (MPart)this.getDomElement();
                        if (element != null && element.getTags().contains("Part-ToolBarMenu-Floating")) {
                            toolbarGroup.getParent().setVisible(false);
                        }
                    }
                });
                n.getStyleClass().add((Object)"view-toolbar");
                this.toolbarGroup.getChildren().setAll((Object[])new Node[]{n});
            }
        }

        public void setMenu(WMenu<Node> menu) {
            if (menu == null) {
                this.clearMenu();
            } else {
                this.menuGroup.setVisible(true);
                this.menuGroup.getChildren().setAll((Object[])new Node[]{(Node)menu.getWidget()});
                this.contentArea.requestLayout();
            }
        }

        @Override
        public AnchorPane getWidgetNode() {
            if (this.contentArea == null) {
                this.menuGroup = new Group();
                this.menuGroup.setVisible(false);
                this.menuGroup.setManaged(false);
                DefPartRenderer.HandleGroup handler = new DefPartRenderer.HandleGroup();
                handler.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        toolbarGroup.getParent().setVisible(true);
                    }
                });
                this.contentArea = new AnchorPane(){

                    protected void layoutChildren() {
                        super.layoutChildren();
                        if (menuGroup.isVisible()) {
                            menuGroup.relocate(contentArea.getWidth() - 20.0, 0.0);
                        }
                    }
                };
                this.dataArea = new SortedBorderPane();
                AnchorPane.setTopAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setRightAnchor((Node)this.dataArea, (Double)0.0);
                this.contentArea.getChildren().addAll((Object[])new Node[]{this.dataArea, this.menuGroup});
                Node n = (Node)this.getWidget();
                n.getStyleClass().add((Object)"part-content");
                if (this.domElement.getTags().contains("fx_scrollable")) {
                    ScrollPane scroll = new ScrollPane(n);
                    scroll.setFitToHeight(true);
                    scroll.setFitToWidth(true);
                    n = scroll;
                }
                this.dataArea.setCenter(n);
            }
            return this.contentArea;
        }

        private void clearToolBar() {
            if (this.toolbarGroup != null) {
                this.toolbarGroup.getChildren().clear();
                this.dataArea.setTop(null);
                this.dataArea.setBottom(null);
                this.toolbarGroup = null;
            }
        }

        private void clearMenu() {
            if (this.menuGroup != null) {
                this.menuGroup.setVisible(false);
                this.menuGroup.getChildren().clear();
            }
        }

        private void initToolbarMenu() {
            if (this.toolbarGroup == null) {
                this.getStaticLayoutNode();
                this.toolbarGroup = new StackPane();
                MPart element = (MPart)this.getDomElement();
                if (element != null && element.getTags().contains("Part-Toolbar-FullSpan")) {
                    final BorderPane p = new BorderPane();
                    p.setCenter((Node)this.toolbarGroup);
                    p.getStyleClass().add((Object)"view-toolbar-container");
                    if (element.getTags().contains("Part-ToolBarMenu-Floating")) {
                        AnchorPane.setLeftAnchor((Node)p, (Double)0.0);
                        AnchorPane.setRightAnchor((Node)p, (Double)0.0);
                        AnchorPane.setTopAnchor((Node)p, (Double)0.0);
                        this.contentArea.getChildren().add((Object)p);
                        p.setVisible(false);
                        p.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                p.setVisible(false);
                            }
                        });
                    } else if (element.getTags().contains("Part-ToolBarMenu-Bottom")) {
                        this.dataArea.setBottom((Node)p);
                    } else {
                        this.dataArea.setTop((Node)p);
                    }
                } else {
                    BorderPane p = new BorderPane();
                    p.setRight((Node)this.toolbarGroup);
                    p.getStyleClass().add((Object)"view-toolbar-container");
                    if (element != null && element.getTags().contains("Part-ToolBarMenu-Bottom")) {
                        this.dataArea.setBottom((Node)p);
                    } else {
                        this.dataArea.setTop((Node)p);
                    }
                }
            }
        }
    }

    public static class WFixedSashImpl
    extends AbstractCompositePartImpl<GridLayoutPane> {
        private StackPane overlayContainer;

        @Inject
        public WFixedSashImpl(@Named(value="fx.rendering.domElement") @Named(value="fx.rendering.domElement") @NonNull MCompositePart domElement) {
            super(domElement);
        }

        public void setDialog(Object dialogNode) {
            @NonNull Pane staticLayoutNode = (Pane)this.getStaticLayoutNode();
            if (dialogNode == null) {
                if (this.overlayContainer != null) {
                    staticLayoutNode.getChildren().remove((Object)this.overlayContainer);
                    this.overlayContainer.getChildren().clear();
                }
            } else {
                if (this.overlayContainer == null) {
                    this.overlayContainer = new StackPane();
                    this.overlayContainer.getStyleClass().add((Object)"overlay-container");
                    this.overlayContainer.setManaged(false);
                    this.overlayContainer.setMouseTransparent(false);
                    staticLayoutNode.layoutBoundsProperty().addListener(o -> {
                        staticLayoutNode.layoutBoundsProperty().get();
                        this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                    });
                }
                this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                this.overlayContainer.getChildren().setAll((Object[])new Node[]{(Node)dialogNode});
                staticLayoutNode.getChildren().add((Object)this.overlayContainer);
            }
        }

        private static @NonNull GridData toGridData(Map<String, String> dataMap) {
            GridData gd = new GridData();
            if (dataMap.containsKey("fx_layout_width")) {
                gd.widthHintProperty().set(Integer.parseInt(dataMap.get("fx_layout_width")));
                if (!dataMap.containsKey("fx_layout_height")) {
                    gd.grabExcessVerticalSpaceProperty().set(true);
                    gd.verticalAlignmentProperty().set((Object)GridData.Alignment.FILL);
                }
            } else {
                gd.horizontalAlignmentProperty().set((Object)GridData.Alignment.FILL);
            }
            if (dataMap.containsKey("fx_layout_height")) {
                gd.heightHintProperty().set(Integer.parseInt(dataMap.get("fx_layout_height")));
                if (!dataMap.containsKey("fx_layout_width")) {
                    gd.grabExcessHorizontalSpaceProperty().set(true);
                    gd.horizontalAlignmentProperty().set((Object)GridData.Alignment.FILL);
                }
            } else {
                gd.verticalAlignmentProperty().set((Object)GridData.Alignment.FILL);
            }
            if (dataMap.containsKey("fx_layout_grab_horizontal")) {
                gd.grabExcessHorizontalSpaceProperty().set(Boolean.parseBoolean(dataMap.get("fx_layout_grab_horizontal")));
                gd.horizontalAlignmentProperty().set((Object)GridData.Alignment.FILL);
            }
            if (dataMap.containsKey("fx_layout_grab_vertical")) {
                gd.grabExcessVerticalSpaceProperty().set(Boolean.parseBoolean(dataMap.get("fx_layout_grab_vertical")));
                gd.verticalAlignmentProperty().set((Object)GridData.Alignment.FILL);
            }
            return gd;
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            MPartSashContainerElement domElement2;
            Node n = (Node)widget.getStaticLayoutNode();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            MCompositePart element = (MCompositePart)this.getDomElement();
            if (element != null && element.isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + 1);
            }
            if ((domElement2 = (MPartSashContainerElement)widget.getDomElement()) != null) {
                GridData gd = WFixedSashImpl.toGridData(domElement2.getPersistedState());
                GridLayoutPane.setConstraint((Node)n, (GridData)gd);
            }
            p.getChildren().add((Object)n);
        }

        public int getItemCount() {
            return ((GridLayoutPane)this.getWidget()).getChildren().size();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                Node n = (Node)w.getStaticLayoutNode();
                MPartSashContainerElement element = (MPartSashContainerElement)w.getDomElement();
                if (element != null) {
                    GridData gd = WFixedSashImpl.toGridData(element.getPersistedState());
                    GridLayoutPane.setConstraint((Node)n, (GridData)gd);
                }
                nodeList.add(n);
            }
            MCompositePart element = (MCompositePart)this.getDomElement();
            if (element != null && element.isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + nodeList.size());
            }
            p.getChildren().addAll(nodeList);
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                Node n = (Node)w.getStaticLayoutNode();
                MPartSashContainerElement element = (MPartSashContainerElement)w.getDomElement();
                if (element != null) {
                    GridData gd = WFixedSashImpl.toGridData(element.getPersistedState());
                    GridLayoutPane.setConstraint((Node)n, (GridData)gd);
                }
                nodeList.add(n);
            }
            MCompositePart element = (MCompositePart)this.getDomElement();
            if (element != null && element.isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + nodeList.size());
            }
            p.getChildren().addAll(index, nodeList);
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            Node n = (Node)widget.getStaticLayoutNode();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            p.setNumColumns(p.getNumColumns() - 1);
            p.getChildren().remove((Object)n);
        }

        @Override
        protected GridLayoutPane createWidget() {
            GridLayoutPane p = new GridLayoutPane();
            p.setMarginWidth(0);
            p.setMarginHeight(0);
            p.setHorizontalSpacing(0);
            p.setVerticalSpacing(0);
            p.setNumColumns(0);
            return p;
        }

        public void updateLayout() {
        }
    }

    public static class WResizableSashImpl
    extends AbstractCompositePartImpl<SplitPane> {
        private List<WLayoutedWidget<MPartSashContainerElement>> items = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        private StackPane overlayContainer;
        ChangeListener<Number> listener = new ChangeListener<Number>(){
            boolean queueing;

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (!this.queueing) {
                    this.queueing = true;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            this.recalcWeight();
                            queueing = false;
                        }
                    });
                }
            }
        };

        @Inject
        public WResizableSashImpl(@Named(value="fx.rendering.domElement") @Named(value="fx.rendering.domElement") @NonNull MCompositePart domElement) {
            super(domElement);
        }

        public void setDialog(Object dialogNode) {
            @NonNull Pane staticLayoutNode = (Pane)this.getStaticLayoutNode();
            if (dialogNode == null) {
                if (this.overlayContainer != null) {
                    staticLayoutNode.getChildren().remove((Object)this.overlayContainer);
                    this.overlayContainer.getChildren().clear();
                }
            } else {
                if (this.overlayContainer == null) {
                    this.overlayContainer = new StackPane();
                    this.overlayContainer.getStyleClass().add((Object)"overlay-container");
                    this.overlayContainer.setManaged(false);
                    this.overlayContainer.setMouseTransparent(false);
                    staticLayoutNode.layoutBoundsProperty().addListener(o -> {
                        staticLayoutNode.layoutBoundsProperty().get();
                        this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                    });
                }
                this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                this.overlayContainer.getChildren().setAll((Object[])new Node[]{(Node)dialogNode});
                staticLayoutNode.getChildren().add((Object)this.overlayContainer);
            }
        }

        public void updateLayout() {
            this.updateDividers();
        }

        void recalcWeight() {
            @Nullable MCompositePart domElement = (MCompositePart)this.getDomElement();
            if (domElement != null) {
                BaseRenderer r = (BaseRenderer)domElement.getRenderer();
                r.syncUIModifications((MUIElement)domElement, this::doRecalcWeight);
            } else {
                this.logger.error("The domain object should not be null at this point");
            }
        }

        void doRecalcWeight() {
            if (this.state != WWidget.WidgetState.CREATED) {
                return;
            }
            double prev = 0.0;
            int idx = 0;
            if (this.items.isEmpty()) {
                return;
            }
            double[] dArray = ((SplitPane)this.getWidget()).getDividerPositions();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPartSashContainerElement element;
                double d = dArray[n2];
                if ((element = (MPartSashContainerElement)this.items.get(idx++).getDomElement()) != null) {
                    element.setContainerData(String.valueOf((d - prev) * 10.0));
                }
                prev = d;
                ++n2;
            }
            MPartSashContainerElement element = (MPartSashContainerElement)this.items.get(this.items.size() - 1).getDomElement();
            if (element != null) {
                element.setContainerData(String.valueOf((1.0 - prev) * 10.0));
            }
        }

        @Override
        protected void bindProperties(SplitPane widget) {
            super.bindProperties(widget);
            widget.getDividers().addListener((ListChangeListener)new ListChangeListener<SplitPane.Divider>(){

                public void onChanged(ListChangeListener.Change<? extends SplitPane.Divider> c) {
                    while (c.next()) {
                        for (SplitPane.Divider d : c.getAddedSubList()) {
                            if (d == null) continue;
                            d.positionProperty().addListener(listener);
                        }
                        for (SplitPane.Divider d : c.getRemoved()) {
                            if (d == null) continue;
                            d.positionProperty().removeListener(listener);
                        }
                    }
                }
            });
            for (SplitPane.Divider d : widget.getDividers()) {
                d.positionProperty().addListener(this.listener);
            }
        }

        @Override
        protected SplitPane createWidget() {
            SplitPane p = new SplitPane();
            return p;
        }

        @Inject
        void setOrientation(@Named(value="horizontal") @Named(value="horizontal") boolean horizontal) {
            ((SplitPane)this.getWidget()).setOrientation(horizontal ? Orientation.HORIZONTAL : Orientation.VERTICAL);
        }

        private static void setResizableWithParent(WLayoutedWidget widget) {
            MUIElement domElement = widget.getDomElement();
            if (domElement != null) {
                SplitPane.setResizableWithParent((Node)((Node)widget.getStaticLayoutNode()), (Boolean)(!domElement.getTags().contains("fx_no_auto_resize") ? 1 : 0));
            }
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            WResizableSashImpl.setResizableWithParent(widget);
            p.getItems().add((Object)((Node)widget.getStaticLayoutNode()));
            this.items.add(widget);
            this.updateDividers();
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                WResizableSashImpl.setResizableWithParent(i);
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(index, l);
            this.items.addAll(index, list);
            this.updateDividers();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                WResizableSashImpl.setResizableWithParent(i);
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(l);
            this.items.addAll(list);
            this.updateDividers();
        }

        @Override
        public void setWidgetState(WWidget.WidgetState state) {
            super.setWidgetState(state);
            if (state == WWidget.WidgetState.CREATED) {
                this.updateDividers();
            }
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            p.getItems().remove(widget.getStaticLayoutNode());
            this.items.remove(widget);
            this.updateDividers();
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.items.clear();
        }

        private void updateDividers() {
            if (this.items.size() <= 1) {
                return;
            }
            if (this.state != WWidget.WidgetState.CREATED) {
                return;
            }
            double total = 0.0;
            for (WLayoutedWidget<MPartSashContainerElement> w : this.items) {
                total += w.getWeight();
            }
            double[] deviders = new double[this.items.size() - 1];
            int i = 0;
            while (i < this.items.size() - 1) {
                deviders[i] = (i == 0 ? 0.0 : deviders[i - 1]) + this.items.get(i).getWeight() / total;
                ++i;
            }
            ((SplitPane)this.getWidget()).setDividerPositions(deviders);
        }

        public int getItemCount() {
            return ((SplitPane)this.getWidget()).getItems().size();
        }
    }
}

