/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import javafx.event.Event;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.TransferMode;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.ui.controls.dnd.EFXDragEvent;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragTargetWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.BaseDnDSupport;
import org.eclipse.fx.ui.workbench.services.ModelService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SplitDnDSupport<M extends MUIElement>
extends BaseDnDSupport {
    private final WLayoutedWidget<M> widget;
    private final @NonNull EModelService modelService;
    private final @Nullable DnDService constraintService;
    private @NonNull ModelService efxModelService;
    private int splitPadding = 20;

    public SplitDnDSupport(@NonNull ModelService efxModelService, @NonNull EModelService modelService, @Nullable DnDService constraintService, @NonNull DnDFeedbackService feedbackService, WLayoutedWidget<M> widget) {
        super(feedbackService);
        this.efxModelService = efxModelService;
        this.constraintService = constraintService;
        this.modelService = modelService;
        this.widget = widget;
    }

    public void handleDragExit(DragEvent e) {
        SplitDnDSupport.cleanup();
    }

    public void handleDragExit(MouseDragEvent e) {
        SplitDnDSupport.cleanup();
    }

    private @Nullable MUIElement findElement(String objectId) {
        MApplication root;
        @Nullable MUIElement domElement = this.widget.getDomElement();
        if (domElement != null && (root = this.efxModelService.getRoot((MApplicationElement)domElement)) != null && objectId != null) {
            return (MUIElement)this.efxModelService.getElementInstance(root, objectId);
        }
        return null;
    }

    public void handleDragOver(EFXDragEvent e) {
        this._handleDragOver((Event)e);
    }

    public void handleDragOver(DragEvent e) {
        this._handleDragOver((Event)e);
    }

    public void handleDragDropped(EFXDragEvent e) {
        this._handleDragDropped((Event)e);
    }

    public void handleDragDropped(DragEvent e) {
        this._handleDragDropped((Event)e);
    }

    private void _handleDragOver(Event e) {
        @Nullable MUIElement m = this.widget.getDomElement();
        String content = DndTabPaneFactory.getDnDContent((Event)e);
        if (content == null) {
            return;
        }
        MUIElement findElement = this.findElement(content);
        if (findElement == null) {
            return;
        }
        if (m != null && this.constraintService != null && !this.constraintService.splitAllowed(m, findElement, this.getSplitType(e))) {
            return;
        }
        if (this.widget.getDropDroppedCallback() != null) {
            if (!DndTabPaneFactory.hasDnDContent((Event)e)) {
                return;
            }
            if (m instanceof MGenericTile) {
                e.consume();
            } else if (!(m instanceof MPart && this.isSplit(e) || !(m instanceof MElementContainer))) {
                MElementContainer c = (MElementContainer)m;
                if (this.modelService.countRenderableChildren((MUIElement)c) == 0) {
                    SplitDnDSupport.setAcceptTransferModes(e, TransferMode.MOVE);
                    e.consume();
                } else {
                    this.updateFeedback(new DnDFeedbackService.DnDFeedbackData(null, null, this.getSplitType(e), (MUIElement)c, null));
                    SplitDnDSupport.setAcceptTransferModes(e, TransferMode.MOVE);
                    e.consume();
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void _handleDragDropped(Event e) {
        @Nullable MUIElement m = this.widget.getDomElement();
        String content = DndTabPaneFactory.getDnDContent((Event)e);
        if (content == null) {
            return;
        }
        MUIElement findElement = this.findElement(content);
        if (findElement == null) {
            return;
        }
        if (m != null && this.constraintService != null && !this.constraintService.splitAllowed(m, findElement, this.getSplitType(e))) {
            return;
        }
        @Nullable @NonNull @Nullable WCallback dropDroppedCallback = this.widget.getDropDroppedCallback();
        if (dropDroppedCallback != null) {
            MElementContainer c;
            if (!DndTabPaneFactory.hasDnDContent((Event)e)) {
                return;
            }
            String objectId = DndTabPaneFactory.getDnDContent((Event)e);
            MUIElement draggedElement = this.findElement(objectId);
            if (draggedElement == null) {
                return;
            }
            if (m instanceof MGenericTile) {
                e.consume();
            } else if (m instanceof MPart && this.isSplit(e)) {
                e.consume();
                MPart part = (MPart)m;
                if (m.getParent() == null && part.getCurSharedRef() != null && part.getCurSharedRef().getParent() instanceof MPartStack) {
                    WDragTargetWidget.DropData d = new WDragTargetWidget.DropData(SplitDnDSupport.screenX(e), SplitDnDSupport.screenY(e), (MUIElement)part.getCurSharedRef(), draggedElement, this.getSplitType(e));
                    dropDroppedCallback.call((Object)d);
                    SplitDnDSupport.setDropComplete(e, true);
                } else if (m.getParent() instanceof MPartStack) {
                    WDragTargetWidget.DropData d = new WDragTargetWidget.DropData(SplitDnDSupport.screenX(e), SplitDnDSupport.screenY(e), this.widget.getDomElement(), draggedElement, this.getSplitType(e));
                    dropDroppedCallback.call((Object)d);
                    SplitDnDSupport.setDropComplete(e, true);
                }
            } else if (m instanceof MElementContainer && this.modelService.countRenderableChildren((MUIElement)(c = (MElementContainer)m)) == 0) {
                WDragTargetWidget.DropData d = new WDragTargetWidget.DropData(SplitDnDSupport.screenX(e), SplitDnDSupport.screenY(e), this.widget.getDomElement(), draggedElement, (WDragTargetWidget.DropLocation)WDragTargetWidget.BasicDropLocation.INSERT);
                dropDroppedCallback.call((Object)d);
                e.consume();
                SplitDnDSupport.setDropComplete(e, true);
            }
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropLocation getSplitType(Event e) {
        SplitAreas areas = this.calculateSplitAreas();
        if (areas.left.contains(SplitDnDSupport.x(e), SplitDnDSupport.y(e))) {
            return WDragTargetWidget.BasicDropLocation.SPLIT_LEFT;
        }
        if (areas.right.contains(SplitDnDSupport.x(e), SplitDnDSupport.y(e))) {
            return WDragTargetWidget.BasicDropLocation.SPLIT_RIGHT;
        }
        if (areas.top.contains(SplitDnDSupport.x(e), SplitDnDSupport.y(e))) {
            return WDragTargetWidget.BasicDropLocation.SPLIT_TOP;
        }
        if (areas.bottom.contains(SplitDnDSupport.x(e), SplitDnDSupport.y(e))) {
            return WDragTargetWidget.BasicDropLocation.SPLIT_BOTTOM;
        }
        return WDragTargetWidget.BasicDropLocation.SPLIT_BOTTOM;
    }

    private static double x(Event e) {
        if (e instanceof DragEvent) {
            return ((DragEvent)e).getX();
        }
        return ((EFXDragEvent)e).getX();
    }

    private static double y(Event e) {
        if (e instanceof DragEvent) {
            return ((DragEvent)e).getY();
        }
        return ((EFXDragEvent)e).getY();
    }

    private static double screenX(Event e) {
        if (e instanceof DragEvent) {
            return ((DragEvent)e).getScreenX();
        }
        return ((EFXDragEvent)e).getScreenX();
    }

    private static double screenY(Event e) {
        if (e instanceof DragEvent) {
            return ((DragEvent)e).getScreenY();
        }
        return ((EFXDragEvent)e).getScreenY();
    }

    private static void setDropComplete(Event e, boolean complete) {
        if (e instanceof EFXDragEvent) {
            ((EFXDragEvent)e).setComplete(complete);
        } else {
            ((DragEvent)e).setDropCompleted(complete);
        }
    }

    private static void setAcceptTransferModes(Event e, TransferMode mode) {
        if (e instanceof DragEvent) {
            ((DragEvent)e).acceptTransferModes(new TransferMode[]{mode});
        }
    }

    public int getSplitPadding() {
        return this.splitPadding;
    }

    public void setSplitPadding(int splitPadding) {
        this.splitPadding = splitPadding;
    }

    private SplitAreas calculateSplitAreas() {
        Bounds bounds = ((Node)this.widget.getStaticLayoutNode()).getBoundsInLocal();
        double hSplitWidth = (bounds.getWidth() - (double)(this.getSplitPadding() * 2)) / 5.0;
        double hSplitHeight = bounds.getHeight() - (double)(this.getSplitPadding() * 2);
        double vSplitWidth = bounds.getWidth() - (double)(this.getSplitPadding() * 2);
        double vSplitHeight = (bounds.getHeight() - (double)(this.getSplitPadding() * 2)) / 2.0;
        BoundingBox leftSplit = new BoundingBox((double)this.getSplitPadding(), (double)this.getSplitPadding(), hSplitWidth, hSplitHeight);
        BoundingBox rightSplit = new BoundingBox(bounds.getWidth() - (double)this.getSplitPadding() - hSplitWidth, (double)this.getSplitPadding(), hSplitWidth, hSplitHeight);
        BoundingBox topSplit = new BoundingBox((double)this.getSplitPadding(), (double)this.getSplitPadding(), vSplitWidth, vSplitHeight);
        BoundingBox bottomSplit = new BoundingBox((double)this.getSplitPadding(), (double)this.getSplitPadding() + vSplitHeight, vSplitWidth, vSplitHeight);
        return new SplitAreas((Bounds)leftSplit, (Bounds)rightSplit, (Bounds)topSplit, (Bounds)bottomSplit);
    }

    private boolean isSplit(Event e) {
        Bounds boundsInLocal = ((Node)this.widget.getStaticLayoutNode()).getBoundsInLocal();
        boundsInLocal = new BoundingBox(boundsInLocal.getMinX() + (double)this.getSplitPadding(), boundsInLocal.getMinY() + (double)this.getSplitPadding(), boundsInLocal.getWidth() - (double)(this.getSplitPadding() * 2), boundsInLocal.getHeight() - (double)(this.getSplitPadding() * 2));
        return boundsInLocal.contains(SplitDnDSupport.x(e), SplitDnDSupport.y(e));
    }

    private static class SplitAreas {
        final Bounds left;
        final Bounds right;
        final Bounds top;
        final Bounds bottom;

        SplitAreas(Bounds left, Bounds right, Bounds top, Bounds bottom) {
            this.left = left;
            this.right = right;
            this.bottom = bottom;
            this.top = top;
        }
    }
}

