/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.findReferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

@FinalFieldsConstructor
public class ReferenceAcceptor
implements IReferenceFinder.Acceptor {
    private final IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    private final IAcceptor<IReferenceDescription> delegate;
    private Resource currentResource;
    private Map<EObject, URI> exportedContainersInCurrentResource;

    @Override
    public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
        if (this.currentResource == null || source.eResource() != this.currentResource) {
            Resource _eResource;
            this.computeExportedObjectsMap(source);
            this.currentResource = _eResource = source.eResource();
        }
        URI _findExportedContainer = this.findExportedContainer(source);
        IReferenceDescription _createReferenceDescription = this.createReferenceDescription(sourceURI, targetURI, eReference, index, _findExportedContainer);
        this.accept(_createReferenceDescription);
    }

    protected void computeExportedObjectsMap(EObject source) {
        Resource resource = source.eResource();
        URI _uRI = resource.getURI();
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(_uRI);
        if (resourceServiceProvider != null) {
            HashMap _newHashMap;
            IResourceDescription.Manager _resourceDescriptionManager = resourceServiceProvider.getResourceDescriptionManager();
            IResourceDescription resourceDescription = _resourceDescriptionManager.getResourceDescription(resource);
            this.exportedContainersInCurrentResource = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            Iterable<IEObjectDescription> _exportedObjects = resourceDescription.getExportedObjects();
            for (IEObjectDescription description : _exportedObjects) {
                EObject instance = description.getEObjectOrProxy();
                boolean _eIsProxy = instance.eIsProxy();
                if (_eIsProxy) {
                    EObject _eObject;
                    URI _eObjectURI = description.getEObjectURI();
                    String _fragment = _eObjectURI.fragment();
                    instance = _eObject = resource.getEObject(_fragment);
                }
                URI _eObjectURI_1 = description.getEObjectURI();
                this.exportedContainersInCurrentResource.put(instance, _eObjectURI_1);
            }
        } else {
            Map _emptyMap;
            this.exportedContainersInCurrentResource = _emptyMap = CollectionLiterals.emptyMap();
        }
    }

    protected URI findExportedContainer(EObject obj) {
        EObject source = obj;
        boolean _isEmpty = this.exportedContainersInCurrentResource.isEmpty();
        if (_isEmpty) {
            return null;
        }
        URI result = this.exportedContainersInCurrentResource.get(source);
        while (result == null) {
            URI _get;
            boolean _containsKey = this.exportedContainersInCurrentResource.containsKey(source);
            if (_containsKey) {
                return result;
            }
            EObject _eContainer = source.eContainer();
            if ((source = _eContainer) == null) {
                return null;
            }
            result = _get = this.exportedContainersInCurrentResource.get(source);
        }
        this.exportedContainersInCurrentResource.put(source, result);
        return result;
    }

    @Override
    public void accept(IReferenceDescription description) {
        this.delegate.accept((Object)description);
    }

    protected IReferenceDescription createReferenceDescription(URI sourceURI, URI targetURI, EReference eReference, int index, URI containerURI) {
        return new DefaultReferenceDescription(sourceURI, targetURI, eReference, index, containerURI);
    }

    public ReferenceAcceptor(IResourceServiceProvider.Registry resourceServiceProviderRegistry, IAcceptor<IReferenceDescription> delegate) {
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
        this.delegate = delegate;
    }
}

