/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext;

import com.google.common.collect.Range;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Point2D;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.DefaultContent;
import org.eclipse.fx.ui.controls.styledtext.StyleRange;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextChangedEvent;
import org.eclipse.fx.ui.controls.styledtext.TextChangingEvent;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.TriggerActionMapping;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationPresenter;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationProvider;
import org.eclipse.fx.ui.controls.styledtext.skin.StyledTextSkin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StyledTextArea
extends Control {
    final @NonNull ObjectProperty<@NonNull StyledTextContent> contentProperty;
    StyledTextContent.TextChangeListener textChangeListener = new StyledTextContent.TextChangeListener(){

        @Override
        public void textChanging(TextChangingEvent event) {
            StyledTextArea.this.handleTextChanging(event);
        }

        @Override
        public void textChanged(TextChangedEvent event) {
            StyledTextArea.this.handleTextChanged(event);
        }

        @Override
        public void textSet(TextChangedEvent event) {
            StyledTextArea.this.handleTextSet(event);
        }
    };
    private final @NonNull DoubleProperty fontZoomFactor = new SimpleDoubleProperty((Object)this, "fontZoomFactor", 1.0);
    private final @NonNull StyledTextRenderer renderer = new StyledTextRenderer();
    private final @NonNull IntegerProperty caretOffsetProperty = new SimpleIntegerProperty((Object)this, "caretOffset", 0);
    private final @NonNull BooleanProperty lineRulerVisible = new SimpleBooleanProperty((Object)this, "lineRulerVisible");
    private final @NonNull ObjectProperty<TextSelection> currentSelection = new SimpleObjectProperty((Object)this, "currentSelection");
    private final @NonNull IntegerProperty tabAdvance = new SimpleIntegerProperty((Object)this, "tabAdvance", 4);
    private final @NonNull BooleanProperty insertSpacesForTab = new SimpleBooleanProperty((Object)this, "insertSpacesForTab", false);
    private final @NonNull ObjectProperty<TriggerActionMapping> overrideActionMappingProperty = new SimpleObjectProperty((Object)this, "overrideActionMapping");
    private final @NonNull ObjectProperty<@NonNull LineSeparator> lineSeparator = new SimpleObjectProperty((Object)this, "lineSeparator", (Object)("\n".equals(System.getProperty("line.separator")) ? LineSeparator.NEW_LINE : LineSeparator.CARRIAGE_RETURN_NEW_LINE));
    private SetProperty<AnnotationPresenter> annotationPresenter = new SimpleSetProperty((Object)this, "annotationPresenter", FXCollections.observableSet((Object[])new AnnotationPresenter[0]));
    private SetProperty<AnnotationProvider> annotationProvider = new SimpleSetProperty((Object)this, "annotationProvider", FXCollections.observableSet((Object[])new AnnotationProvider[0]));
    private ObjectProperty<Function<Integer, Optional<QuickLinkable>>> quickLinkCallbackProperty = new SimpleObjectProperty((Object)this, "quickLinkCallback", offset -> Optional.empty());
    private int anchor;
    private int lastTextChangeNewCharCount;
    private int lastTextChangeReplaceCharCount;
    private static final String USER_AGENT_STYLESHEET = StyledTextArea.class.getResource("styledtextarea.css").toExternalForm();
    static final CssMetaData<StyledTextArea, Number> FIXED_LINE_HEIGHT = new CssMetaData<StyledTextArea, Number>("-fx-fixed-line-height", StyleConverter.getSizeConverter(), (Number)16){

        public boolean isSettable(StyledTextArea n) {
            return n.fixedLineHeight == null || !n.fixedLineHeight.isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(StyledTextArea n) {
            return (StyleableProperty)n.fixedLineHeight;
        }
    };
    final DoubleProperty fixedLineHeight = new StyleableDoubleProperty(16.0){

        public Object getBean() {
            return StyledTextArea.this;
        }

        public String getName() {
            return "fixedLineHeight";
        }

        public CssMetaData<StyledTextArea, Number> getCssMetaData() {
            return FIXED_LINE_HEIGHT;
        }
    };
    static final FontCssMetaData<StyledTextArea> FONT = new FontCssMetaData<StyledTextArea>("-fx-font", Font.getDefault()){

        public boolean isSettable(StyledTextArea n) {
            return n.font == null | !n.font.isBound();
        }

        public StyleableProperty<Font> getStyleableProperty(StyledTextArea n) {
            return (StyleableProperty)n.fontProperty();
        }
    };
    final ObjectProperty<Font> font = new StyleableObjectProperty<Font>(Font.getDefault()){
        private boolean settingFontViaCSS;
        {
            this.settingFontViaCSS = false;
        }

        public CssMetaData<? extends Styleable, Font> getCssMetaData() {
            return FONT;
        }

        public Object getBean() {
            return StyledTextArea.this;
        }

        public String getName() {
            return "font";
        }

        public void applyStyle(StyleOrigin newOrigin, Font value) {
            try {
                this.settingFontViaCSS = true;
                super.applyStyle(newOrigin, (Object)value);
            }
            finally {
                this.settingFontViaCSS = false;
            }
        }

        protected void invalidated() {
            super.invalidated();
            if (!this.settingFontViaCSS) {
                StyledTextArea.this.impl_reapplyCSS();
            }
        }
    };
    private TextChangingEvent changingEvent;
    private final @NonNull BooleanProperty editableProperty = new SimpleBooleanProperty((Object)this, "editableProperty", true);
    private IntegerProperty lineCount = new SimpleIntegerProperty((Object)this, "lineCount", 0);
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(Control.getClassCssMetaData());
        styleables.add(FIXED_LINE_HEIGHT);
        styleables.add(FONT);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public DoubleProperty fontZoomFactorProperty() {
        return this.fontZoomFactor;
    }

    public void setFontZoomFactor(double factor) {
        this.fontZoomFactor.set(factor);
    }

    public double getFontZoomFactor() {
        return this.fontZoomFactor.get();
    }

    public void setOverrideActionMapping(TriggerActionMapping mapping) {
        this.overrideActionMappingProperty.set((Object)mapping);
    }

    public TriggerActionMapping getOverrideActionMapping() {
        return (TriggerActionMapping)this.overrideActionMappingProperty.get();
    }

    public ObjectProperty<TriggerActionMapping> overrideActionMappingProperty() {
        return this.overrideActionMappingProperty;
    }

    public SetProperty<AnnotationPresenter> getAnnotationPresenter() {
        return this.annotationPresenter;
    }

    public SetProperty<AnnotationProvider> getAnnotationProvider() {
        return this.annotationProvider;
    }

    public void setQuickLinkCallback(Function<Integer, Optional<QuickLinkable>> callback) {
        this.quickLinkCallbackProperty.set(callback);
    }

    public Function<Integer, Optional<QuickLinkable>> getQuickLinkCallback() {
        return (Function)this.quickLinkCallbackProperty.get();
    }

    public StyledTextArea() {
        this.getStyleClass().add((Object)"styled-text-area");
        this.contentProperty = new ContentProperty((Object)this, "content", new DefaultContent());
        this.setFocusTraversable(true);
        DoubleBinding lineHeight = Util.createTextHeightBinding("Pj", this.fontProperty(), (ObservableValue<Number>)this.fontZoomFactor);
        this.fixedLineHeightProperty().bind((ObservableValue)lineHeight.multiply(1.3));
    }

    public double getFixedLineHeight() {
        return this.fixedLineHeight.get();
    }

    public void setFixedLineHeight(double fixedLineHeight) {
        this.fixedLineHeight.set(fixedLineHeight);
    }

    public DoubleProperty fixedLineHeightProperty() {
        return this.fixedLineHeight;
    }

    public final ObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public final void setFont(Font value) {
        this.font.setValue((Object)value);
    }

    public final Font getFont() {
        return (Font)this.font.getValue();
    }

    public @NonNull LineSeparator getLineSeparator() {
        return (LineSeparator)((Object)this.lineSeparator.get());
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    void handleTextChanging(TextChangingEvent event) {
        this.changingEvent = event;
        this.renderer.textChanging(event);
        if (event.replaceCharCount < 0) {
            event.offset += event.replaceCharCount;
            event.replaceCharCount *= -1;
        }
        this.lastTextChangeNewCharCount = event.newCharCount;
        this.lastTextChangeReplaceCharCount = event.replaceCharCount;
        int newEndOfText = this.getContent().getCharCount() - event.replaceCharCount + event.newCharCount;
        if (this.getCaretOffset() > newEndOfText) {
            this.setCaretOffset(newEndOfText);
        }
    }

    void handleTextChanged(TextChangedEvent xxx) {
        if (this.changingEvent == null) {
            int newCharCount = this.getCharCount();
            if (this.caretOffsetProperty.get() > newCharCount) {
                this.caretOffsetProperty.set(newCharCount);
            }
            this.clearSelection();
        } else {
            this.changingEvent = null;
        }
    }

    void handleTextSet(TextChangedEvent event) {
        this.changingEvent = null;
    }

    void updateSelection(int startOffset, int replacedLength, int newLength) {
        if (this.getSelection().offset + this.getSelection().length > startOffset && this.getSelection().offset < startOffset + replacedLength) {
            this.setSelection(new TextSelection(startOffset + newLength, 0));
        } else {
            int computedOffset = this.getSelection().offset + newLength - replacedLength;
            if (computedOffset >= 0 && computedOffset < this.getCharCount()) {
                this.setSelection(new TextSelection(computedOffset, this.getSelection().length));
            }
            if (this.getSelection().length > 0) {
                int delta = this.lastTextChangeNewCharCount - this.lastTextChangeReplaceCharCount;
                this.caretOffsetProperty.set(Math.max(0, Math.min(this.getCharCount() - 1, this.getCaretOffset() + delta)));
            }
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new StyledTextSkin(this);
    }

    public @NonNull BooleanProperty lineRulerVisibleProperty() {
        return this.lineRulerVisible;
    }

    public void setLineRulerVisible(boolean lineRulerVisible) {
        this.lineRulerVisibleProperty().set(lineRulerVisible);
    }

    public boolean isLineRulerVisible() {
        return this.lineRulerVisibleProperty().get();
    }

    public @NonNull IntegerProperty caretOffsetProperty() {
        return this.caretOffsetProperty;
    }

    public void setCaretOffset(int offset) {
        this.anchor = offset;
        this.caretOffsetProperty().set(offset);
        this.clearSelection();
    }

    @Deprecated
    public void impl_setCaretOffset(int offset, boolean selection) {
        if (selection) {
            this.caretOffsetProperty().set(offset);
            if (offset > this.anchor) {
                this.setSelectionRange(this.anchor, offset - this.anchor);
            } else {
                this.setSelectionRange(offset, this.anchor - offset);
            }
        } else {
            this.setCaretOffset(offset);
        }
    }

    public int getCaretOffset() {
        return this.caretOffsetProperty().get();
    }

    public void setContent(@NonNull StyledTextContent content) {
        this.contentProperty().set((Object)content);
    }

    public @NonNull StyledTextContent getContent() {
        return (StyledTextContent)this.contentProperty().get();
    }

    public @NonNull ObjectProperty<@NonNull StyledTextContent> contentProperty() {
        return this.contentProperty;
    }

    public void setStyleRange(@Nullable StyleRange range) {
        if (range != null) {
            if (range.isUnstyled()) {
                this.setStyleRanges(range.start, range.length, null, null, false);
            } else {
                this.setStyleRanges(range.start, 0, null, new StyleRange[]{range}, false);
            }
        } else {
            this.setStyleRanges(0, 0, null, null, true);
        }
    }

    public void setStyleRanges(int start, int length, int[] ranges, @Nullable StyleRange[] styles) {
        if (ranges == null || styles == null) {
            this.setStyleRanges(start, length, null, null, false);
        } else {
            this.setStyleRanges(start, length, ranges, styles, false);
        }
    }

    public void setStyleRanges(int[] ranges, @Nullable StyleRange[] styles) {
        if (ranges == null || styles == null) {
            this.setStyleRanges(0, 0, null, null, true);
        } else {
            this.setStyleRanges(0, 0, ranges, styles, true);
        }
    }

    public void setStyleRanges(StyleRange ... ranges) {
        this.setStyleRanges(0, 0, null, ranges, true);
    }

    public void replaceStyleRanges(int start, int length, @Nullable StyleRange[] ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException();
        }
        this.setStyleRanges(start, length, null, ranges, false);
    }

    void setStyleRanges(int start, int length, int[] ranges, StyleRange[] styles, boolean reset) {
        int charCount = this.getContent().getCharCount();
        int end = start + length;
        if (start > end || start < 0) {
            throw new IllegalArgumentException();
        }
        if (styles != null) {
            if (end > charCount) {
                throw new IllegalArgumentException();
            }
            if (ranges != null && ranges.length != styles.length << 1) {
                throw new IllegalArgumentException();
            }
            int lastOffset = 0;
            int i = 0;
            while (i < styles.length) {
                int rangeLength;
                int rangeStart;
                if (styles[i] == null) {
                    throw new IllegalArgumentException();
                }
                if (ranges != null) {
                    rangeStart = ranges[i << 1];
                    rangeLength = ranges[(i << 1) + 1];
                } else {
                    rangeStart = styles[i].start;
                    rangeLength = styles[i].length;
                }
                if (rangeLength < 0) {
                    throw new IllegalArgumentException();
                }
                if (rangeStart < 0 || rangeStart + rangeLength > charCount) {
                    throw new IllegalArgumentException();
                }
                if (lastOffset > rangeStart) {
                    throw new IllegalArgumentException();
                }
                lastOffset = rangeStart + rangeLength;
                ++i;
            }
        }
        if (styles != null && styles.length > 0) {
            if (ranges != null) {
                int cfr_ignored_0 = ranges[0];
                int cfr_ignored_1 = ranges[ranges.length - 2] + ranges[ranges.length - 1];
            } else {
                int cfr_ignored_2 = styles[0].start;
                int cfr_ignored_3 = styles[styles.length - 1].start + styles[styles.length - 1].length;
            }
        }
        if (reset) {
            this.renderer.setStyleRanges(null, null);
        } else {
            this.renderer.updateRanges(start, length, length);
        }
        if (styles != null && styles.length > 0) {
            this.renderer.setStyleRanges(ranges, styles);
        }
        if (this.getSkin() instanceof StyledTextSkin) {
            ((StyledTextSkin)this.getSkin()).refreshStyles(start, length);
        }
    }

    public StyleRange[] getStyleRanges(int start, int length, boolean includeRanges) {
        StyleRange[] ranges = this.renderer.getStyleRanges(start, length, includeRanges);
        if (ranges != null) {
            return ranges;
        }
        return new StyleRange[0];
    }

    public StyleRange getStyleRangeAtOffset(int offset) {
        if (offset < 0 || offset >= this.getCharCount()) {
            throw new IllegalArgumentException();
        }
        StyleRange[] ranges = this.renderer.getStyleRanges(offset, 1, true);
        if (ranges != null) {
            return ranges[0];
        }
        return null;
    }

    public int getCharCount() {
        return this.getContent().getCharCount();
    }

    public @NonNull TextSelection getSelection() {
        TextSelection textSelection = (TextSelection)this.currentSelection.get();
        if (textSelection == null) {
            textSelection = new TextSelection(this.getCaretOffset(), 0);
        }
        return textSelection;
    }

    public @NonNull ObjectProperty<TextSelection> selectionProperty() {
        return this.currentSelection;
    }

    public void setSelection(@NonNull TextSelection selection) {
        if (selection.length == 0) {
            this.setCaretOffset(selection.offset);
        } else {
            this.currentSelection.set((Object)selection);
        }
    }

    public void clearSelection() {
        this.currentSelection.set(null);
    }

    public void setSelectionRange(int offset, int length) {
        this.setSelection(new TextSelection(offset, length));
    }

    public void setEditable(boolean editable) {
        this.editableProperty().set(editable);
    }

    public boolean getEditable() {
        return this.editableProperty().get();
    }

    public @NonNull BooleanProperty editableProperty() {
        return this.editableProperty;
    }

    public @Nullable Point2D getLocationAtOffset(int offset, LineLocation locationHint) {
        if (offset < 0 || offset > this.getCharCount()) {
            throw new IllegalArgumentException();
        }
        return ((StyledTextSkin)this.getSkin()).getCaretLocation(offset, locationHint);
    }

    public double getLineHeight(int offset) {
        if (offset < 0 || offset > this.getCharCount()) {
            throw new IllegalArgumentException();
        }
        return ((StyledTextSkin)this.getSkin()).getLineHeight(offset);
    }

    public int getLineAtOffset(int caretOffset) {
        return this.getContent().getLineAtOffset(caretOffset);
    }

    public int getOffsetAtLine(int lineNumber) {
        return this.getContent().getOffsetAtLine(lineNumber);
    }

    public @NonNull String getText(int start, int end) {
        return this.getContent().getTextRange(start, end - start + 1);
    }

    public boolean isSelectionEmpty() {
        return this.getSelection().length == 0;
    }

    public void insert(CharSequence text) {
        int replaceLength;
        int start;
        if (text == null) {
            throw new NullPointerException();
        }
        if (!this.isSelectionEmpty()) {
            start = this.getSelection().offset;
            replaceLength = this.getSelection().length;
        } else {
            start = this.getCaretOffset();
            replaceLength = 0;
        }
        String content = text.toString();
        if (this.isInsertSpacesForTab()) {
            content = content.replaceAll("\t", org.eclipse.fx.core.Util.createRepeatedString((char)' ', (int)this.tabAdvance.get()));
        }
        this.getContent().replaceTextRange(start, replaceLength, content);
        this.setCaretOffset(start + content.length());
    }

    public ReadOnlyIntegerProperty lineCountProperty() {
        return this.lineCount;
    }

    public int getLineCount() {
        return this.lineCount.get();
    }

    public void paste() {
        String text;
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasString() && (text = clipboard.getString()) != null) {
            this.insert(text);
        }
    }

    public void copy() {
        if (this.getSelection().length > 0) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            clipboard.setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, this.getContent().getTextRange(this.getSelection().offset, this.getSelection().length)));
        }
    }

    public void cut() {
        TextSelection selection = this.getSelection();
        if (selection.length > 0) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            String content = this.getContent().getTextRange(selection.offset, selection.length);
            this.setCaretOffset(selection.offset);
            this.getContent().replaceTextRange(selection.offset, content.length(), "");
            clipboard.setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, content));
        }
    }

    public int getOffsetAtPosition(double x, double y) {
        int result = ((StyledTextSkin)this.getSkin()).getOffsetAtPosition(x, y);
        return result;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return StyledTextArea.getClassCssMetaData();
    }

    public void navigateToLine(int lineIndex) {
        if (lineIndex >= 0 && lineIndex <= this.getContent().getLineCount()) {
            int offset = this.getContent().getOffsetAtLine(lineIndex);
            this.setCaretOffset(offset);
        }
    }

    public void setTabAdvance(int advance) {
        this.tabAvanceProperty().set(advance);
    }

    public int getTabAdvance() {
        return this.tabAvanceProperty().get();
    }

    public @NonNull IntegerProperty tabAvanceProperty() {
        return this.tabAdvance;
    }

    public void setInsertSpacesForTab(boolean insertSpacesForTab) {
        this.insertSpacesForTab.set(insertSpacesForTab);
    }

    public boolean isInsertSpacesForTab() {
        return this.insertSpacesForTab.get();
    }

    public @NonNull BooleanProperty insertSpacesForTabProperty() {
        return this.insertSpacesForTab;
    }

    public void revealCaret() {
        if (this.getSkin() != null) {
            ((StyledTextSkin)this.getSkin()).scrollOffsetIntoView(this.getCaretOffset(), 2, 2);
        }
    }

    public void triggerAction(TextEditAction action) {
        ((StyledTextSkin)this.getSkin()).getBehavior().triggerAction(action);
    }

    class ContentProperty
    extends SimpleObjectProperty<StyledTextContent> {
        WeakReference<StyledTextContent> oldContent;

        public ContentProperty(Object bean, @NonNull String name, StyledTextContent initialValue) {
            super(bean, name, (Object)initialValue);
            this.invalidated();
        }

        protected void invalidated() {
            StyledTextContent content;
            if (this.oldContent != null && (content = (StyledTextContent)this.oldContent.get()) != null) {
                content.removeTextChangeListener(StyledTextArea.this.textChangeListener);
            }
            StyledTextContent newContent = (StyledTextContent)this.get();
            this.oldContent = new WeakReference<StyledTextContent>(newContent);
            newContent.addTextChangeListener(StyledTextArea.this.textChangeListener);
        }
    }

    public static interface CustomQuickLink
    extends QuickLink {
        public Runnable getAction();
    }

    static class LineInfo {
        int flags;
        Color background;
        int alignment;
        int indent;
        int wrapIndent;
        boolean justify;
        int[] segments;
        char[] segmentsChars;
        int[] tabStops;

        public LineInfo() {
        }

        public LineInfo(LineInfo info) {
            if (info != null) {
                this.flags = info.flags;
                this.background = info.background;
                this.alignment = info.alignment;
                this.indent = info.indent;
                this.wrapIndent = info.wrapIndent;
                this.justify = info.justify;
                this.segments = info.segments;
                this.segmentsChars = info.segmentsChars;
                this.tabStops = info.tabStops;
            }
        }
    }

    public static enum LineLocation {
        BELOW,
        ABOVE,
        CENTER;

    }

    public static enum LineSeparator {
        NEW_LINE("\n"),
        CARRIAGE_RETURN_NEW_LINE("\r\n");

        private String value;

        private LineSeparator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface QuickLink {
        public String getLabel();
    }

    public static interface QuickLinkable {
        public Range<Integer> getRegion();

        public List<QuickLink> getLinks();
    }

    public static interface SimpleQuickLink
    extends QuickLink {
        public Range<Integer> getRegion();
    }

    class StyledTextRenderer {
        StyleRange[] stylesSet;
        int stylesSetCount = 0;
        int[] ranges;
        int styleCount;
        StyleRange[] styles;
        boolean hasLinks;
        LineInfo[] lines;
        int lineCount;
        int[] lineWidth;
        int[] lineHeight;
        static final boolean COMPACT_STYLES = true;
        static final boolean MERGE_STYLES = true;
        static final int GROW = 32;

        StyledTextRenderer() {
        }

        void setStyleRanges(int[] newRanges, StyleRange[] newStyles) {
            int j;
            int[] _newRanges = newRanges;
            StyleRange[] _newStyles = newStyles;
            if (_newStyles == null) {
                this.styleCount = 0;
                this.stylesSetCount = 0;
                this.ranges = null;
                this.styles = null;
                this.stylesSet = null;
                this.hasLinks = false;
                return;
            }
            if (_newRanges == null) {
                _newRanges = new int[_newStyles.length << 1];
                StyleRange[] tmpStyles = new StyleRange[_newStyles.length];
                if (this.stylesSet == null) {
                    this.stylesSet = new StyleRange[4];
                }
                int i = 0;
                int j2 = 0;
                while (i < _newStyles.length) {
                    StyleRange newStyle = _newStyles[i];
                    _newRanges[j2++] = newStyle.start;
                    _newRanges[j2++] = newStyle.length;
                    int index = 0;
                    while (index < this.stylesSetCount) {
                        if (this.stylesSet[index].similarTo(newStyle)) break;
                        ++index;
                    }
                    if (index == this.stylesSetCount) {
                        if (this.stylesSetCount == this.stylesSet.length) {
                            StyleRange[] tmpStylesSet = new StyleRange[this.stylesSetCount + 4];
                            System.arraycopy(this.stylesSet, 0, tmpStylesSet, 0, this.stylesSetCount);
                            this.stylesSet = tmpStylesSet;
                        }
                        this.stylesSet[this.stylesSetCount++] = newStyle;
                    }
                    tmpStyles[i] = this.stylesSet[index];
                    ++i;
                }
                _newStyles = tmpStyles;
            }
            if (this.styleCount == 0) {
                if (_newRanges != null) {
                    this.ranges = new int[_newRanges.length];
                    System.arraycopy(_newRanges, 0, this.ranges, 0, this.ranges.length);
                }
                this.styles = new StyleRange[_newStyles.length];
                System.arraycopy(_newStyles, 0, this.styles, 0, this.styles.length);
                this.styleCount = _newStyles.length;
                return;
            }
            if (_newRanges != null && this.ranges == null) {
                this.ranges = new int[this.styles.length << 1];
                int i = 0;
                j = 0;
                while (i < this.styleCount) {
                    this.ranges[j++] = this.styles[i].start;
                    this.ranges[j++] = this.styles[i].length;
                    ++i;
                }
            }
            if (_newRanges == null && this.ranges != null) {
                _newRanges = new int[_newStyles.length << 1];
                int i = 0;
                j = 0;
                while (i < _newStyles.length) {
                    _newRanges[j++] = _newStyles[i].start;
                    _newRanges[j++] = _newStyles[i].length;
                    ++i;
                }
            }
            if (this.ranges != null && _newRanges != null) {
                boolean insert;
                int start = _newRanges[0];
                int rangeCount = this.styleCount << 1;
                int modifyStart = this.getRangeIndex(start, -1, rangeCount);
                boolean bl = insert = modifyStart == rangeCount;
                if (!insert) {
                    int end = _newRanges[_newRanges.length - 2] + _newRanges[_newRanges.length - 1];
                    int modifyEnd = this.getRangeIndex(end, modifyStart - 1, rangeCount);
                    boolean bl2 = insert = modifyStart == modifyEnd && this.ranges[modifyStart] >= end;
                }
                if (insert) {
                    this.addMerge(_newRanges, _newStyles, _newRanges.length, modifyStart, modifyStart);
                    return;
                }
                int modifyEnd = modifyStart;
                int[] mergeRanges = new int[6];
                StyleRange[] mergeStyles = new StyleRange[3];
                int i = 0;
                while (i < _newRanges.length) {
                    int newStart = _newRanges[i];
                    int newEnd = newStart + _newRanges[i + 1];
                    if (newStart != newEnd) {
                        int modifyLast = 0;
                        int mergeCount = 0;
                        while (modifyEnd < rangeCount) {
                            if (newStart >= this.ranges[modifyStart] + this.ranges[modifyStart + 1]) {
                                modifyStart += 2;
                            }
                            if (this.ranges[modifyEnd] + this.ranges[modifyEnd + 1] > newEnd) break;
                            modifyEnd += 2;
                        }
                        if (this.ranges[modifyStart] < newStart && newStart < this.ranges[modifyStart] + this.ranges[modifyStart + 1]) {
                            mergeStyles[mergeCount >> 1] = this.styles[modifyStart >> 1];
                            mergeRanges[mergeCount] = this.ranges[modifyStart];
                            mergeRanges[mergeCount + 1] = newStart - this.ranges[modifyStart];
                            mergeCount += 2;
                        }
                        mergeStyles[mergeCount >> 1] = _newStyles[i >> 1];
                        mergeRanges[mergeCount] = newStart;
                        mergeRanges[mergeCount + 1] = _newRanges[i + 1];
                        mergeCount += 2;
                        if (modifyEnd < rangeCount && this.ranges[modifyEnd] < newEnd && newEnd < this.ranges[modifyEnd] + this.ranges[modifyEnd + 1]) {
                            mergeStyles[mergeCount >> 1] = this.styles[modifyEnd >> 1];
                            mergeRanges[mergeCount] = newEnd;
                            mergeRanges[mergeCount + 1] = this.ranges[modifyEnd] + this.ranges[modifyEnd + 1] - newEnd;
                            mergeCount += 2;
                            modifyLast = 2;
                        }
                        int grow = this.addMerge(mergeRanges, mergeStyles, mergeCount, modifyStart, modifyEnd + modifyLast);
                        rangeCount += grow;
                        modifyStart = modifyEnd += grow;
                    }
                    i += 2;
                }
            } else {
                int modifyEnd;
                boolean insert;
                int start = _newStyles[0].start;
                int modifyStart = this.getRangeIndex(start, -1, this.styleCount);
                boolean bl = insert = modifyStart == this.styleCount;
                if (!insert) {
                    int end = _newStyles[_newStyles.length - 1].start + _newStyles[_newStyles.length - 1].length;
                    modifyEnd = this.getRangeIndex(end, modifyStart - 1, this.styleCount);
                    boolean bl3 = insert = modifyStart == modifyEnd && this.styles[modifyStart].start >= end;
                }
                if (insert) {
                    this.addMerge(_newStyles, _newStyles.length, modifyStart, modifyStart);
                    return;
                }
                modifyEnd = modifyStart;
                StyleRange[] mergeStyles = new StyleRange[3];
                int i = 0;
                while (i < _newStyles.length) {
                    StyleRange newStyle = _newStyles[i];
                    int newStart = newStyle.start;
                    int newEnd = newStart + newStyle.length;
                    if (newStart != newEnd) {
                        int modifyLast = 0;
                        int mergeCount = 0;
                        while (modifyEnd < this.styleCount) {
                            if (newStart >= this.styles[modifyStart].start + this.styles[modifyStart].length) {
                                ++modifyStart;
                            }
                            if (this.styles[modifyEnd].start + this.styles[modifyEnd].length > newEnd) break;
                            ++modifyEnd;
                        }
                        StyleRange style = this.styles[modifyStart];
                        if (style.start < newStart && newStart < style.start + style.length) {
                            int n = mergeCount++;
                            StyleRange styleRange = (StyleRange)style.clone();
                            mergeStyles[n] = styleRange;
                            style = styleRange;
                            style.length = newStart - style.start;
                        }
                        mergeStyles[mergeCount++] = newStyle;
                        if (modifyEnd < this.styleCount) {
                            style = this.styles[modifyEnd];
                            if (style.start < newEnd && newEnd < style.start + style.length) {
                                int n = mergeCount++;
                                StyleRange styleRange = (StyleRange)style.clone();
                                mergeStyles[n] = styleRange;
                                style = styleRange;
                                style.length += style.start - newEnd;
                                style.start = newEnd;
                                modifyLast = 1;
                            }
                        }
                        int grow = this.addMerge(mergeStyles, mergeCount, modifyStart, modifyEnd + modifyLast);
                        modifyStart = modifyEnd += grow;
                    }
                    ++i;
                }
            }
        }

        int[] getRanges(int start, int length) {
            int[] newRanges;
            if (length == 0) {
                return null;
            }
            int end = start + length - 1;
            if (this.ranges != null) {
                int rangeCount = this.styleCount << 1;
                int rangeStart = this.getRangeIndex(start, -1, rangeCount);
                if (rangeStart >= rangeCount) {
                    return null;
                }
                if (this.ranges[rangeStart] > end) {
                    return null;
                }
                int rangeEnd = Math.min(rangeCount - 2, this.getRangeIndex(end, rangeStart - 1, rangeCount));
                if (this.ranges[rangeEnd] > end) {
                    rangeEnd = Math.max(rangeStart, rangeEnd - 2);
                }
                newRanges = new int[rangeEnd - rangeStart + 2];
                System.arraycopy(this.ranges, rangeStart, newRanges, 0, newRanges.length);
            } else {
                int rangeStart = this.getRangeIndex(start, -1, this.styleCount);
                if (rangeStart >= this.styleCount) {
                    return null;
                }
                if (this.styles[rangeStart].start > end) {
                    return null;
                }
                int rangeEnd = Math.min(this.styleCount - 1, this.getRangeIndex(end, rangeStart - 1, this.styleCount));
                if (this.styles[rangeEnd].start > end) {
                    rangeEnd = Math.max(rangeStart, rangeEnd - 1);
                }
                newRanges = new int[rangeEnd - rangeStart + 1 << 1];
                int i = rangeStart;
                int j = 0;
                while (i <= rangeEnd) {
                    StyleRange style = this.styles[i];
                    newRanges[j] = style.start;
                    newRanges[j + 1] = style.length;
                    ++i;
                    j += 2;
                }
            }
            if (start > newRanges[0]) {
                newRanges[1] = newRanges[0] + newRanges[1] - start;
                newRanges[0] = start;
            }
            if (end < newRanges[newRanges.length - 2] + newRanges[newRanges.length - 1] - 1) {
                newRanges[newRanges.length - 1] = end - newRanges[newRanges.length - 2] + 1;
            }
            return newRanges;
        }

        /*
         * Unable to fully structure code
         */
        int getRangeIndex(int offset, int low, int high) {
            block5: {
                _low = low;
                _high = high;
                if (this.styleCount == 0) {
                    return 0;
                }
                if (this.ranges == null) ** GOTO lbl21
                while (_high - _low > 2) {
                    index = (_high + _low) / 2 / 2 * 2;
                    end = this.ranges[index] + this.ranges[index + 1];
                    if (end > offset) {
                        _high = index;
                        continue;
                    }
                    _low = index;
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    index = (_high + _low) / 2;
                    end = this.styles[index].start + this.styles[index].length;
                    if (end > offset) {
                        _high = index;
                        continue;
                    }
                    _low = index;
lbl21:
                    // 3 sources

                    ** while (_high - _low > 1)
                }
            }
            return _high;
        }

        void textChanging(TextChangingEvent event) {
            int start = event.offset;
            int newCharCount = event.newCharCount;
            int replaceCharCount = event.replaceCharCount;
            int cfr_ignored_0 = event.newLineCount;
            int cfr_ignored_1 = event.replaceLineCount;
            this.updateRanges(start, replaceCharCount, newCharCount);
        }

        int addMerge(int[] mergeRanges, StyleRange[] mergeStyles, int mergeCount, int modifyStart, int modifyEnd) {
            int grow;
            int _mergeCount = mergeCount;
            int _modifyEnd = modifyEnd;
            int rangeCount = this.styleCount << 1;
            StyleRange endStyle = null;
            int endStart = 0;
            int endLength = 0;
            if (_modifyEnd < rangeCount) {
                endStyle = this.styles[_modifyEnd >> 1];
                endStart = this.ranges[_modifyEnd];
                endLength = this.ranges[_modifyEnd + 1];
            }
            if (rangeCount + (grow = _mergeCount - (_modifyEnd - modifyStart)) >= this.ranges.length) {
                int[] tmpRanges = new int[this.ranges.length + grow + 64];
                System.arraycopy(this.ranges, 0, tmpRanges, 0, modifyStart);
                StyleRange[] tmpStyles = new StyleRange[this.styles.length + (grow >> 1) + 32];
                System.arraycopy(this.styles, 0, tmpStyles, 0, modifyStart >> 1);
                if (rangeCount > _modifyEnd) {
                    System.arraycopy(this.ranges, _modifyEnd, tmpRanges, modifyStart + _mergeCount, rangeCount - _modifyEnd);
                    System.arraycopy(this.styles, _modifyEnd >> 1, tmpStyles, modifyStart + _mergeCount >> 1, this.styleCount - (_modifyEnd >> 1));
                }
                this.ranges = tmpRanges;
                this.styles = tmpStyles;
            } else if (rangeCount > _modifyEnd) {
                System.arraycopy(this.ranges, _modifyEnd, this.ranges, modifyStart + _mergeCount, rangeCount - _modifyEnd);
                System.arraycopy(this.styles, _modifyEnd >> 1, this.styles, modifyStart + _mergeCount >> 1, this.styleCount - (_modifyEnd >> 1));
            }
            int j = modifyStart;
            int i = 0;
            while (i < _mergeCount) {
                if (j > 0 && this.ranges[j - 2] + this.ranges[j - 1] == mergeRanges[i] && mergeStyles[i >> 1].similarTo(this.styles[j - 2 >> 1])) {
                    int n = j - 1;
                    this.ranges[n] = this.ranges[n] + mergeRanges[i + 1];
                } else {
                    this.styles[j >> 1] = mergeStyles[i >> 1];
                    this.ranges[j++] = mergeRanges[i];
                    this.ranges[j++] = mergeRanges[i + 1];
                }
                i += 2;
            }
            if (endStyle != null && this.ranges[j - 2] + this.ranges[j - 1] == endStart && endStyle.similarTo(this.styles[j - 2 >> 1])) {
                int n = j - 1;
                this.ranges[n] = this.ranges[n] + endLength;
                _modifyEnd += 2;
                _mergeCount += 2;
            }
            if (rangeCount > _modifyEnd) {
                System.arraycopy(this.ranges, modifyStart + _mergeCount, this.ranges, j, rangeCount - _modifyEnd);
                System.arraycopy(this.styles, modifyStart + _mergeCount >> 1, this.styles, j >> 1, this.styleCount - (_modifyEnd >> 1));
            }
            grow = j - modifyStart - (_modifyEnd - modifyStart);
            this.styleCount += grow >> 1;
            return grow;
        }

        /*
         * Unable to fully structure code
         */
        int addMerge(StyleRange[] mergeStyles, int mergeCount, int modifyStart, int modifyEnd) {
            _mergeCount = mergeCount;
            _modifyEnd = modifyEnd;
            grow = _mergeCount - (_modifyEnd - modifyStart);
            endStyle = null;
            if (_modifyEnd < this.styleCount) {
                endStyle = this.styles[_modifyEnd];
            }
            if (this.styleCount + grow >= this.styles.length) {
                tmpStyles = new StyleRange[this.styles.length + grow + 32];
                System.arraycopy(this.styles, 0, tmpStyles, 0, modifyStart);
                if (this.styleCount > _modifyEnd) {
                    System.arraycopy(this.styles, _modifyEnd, tmpStyles, modifyStart + _mergeCount, this.styleCount - _modifyEnd);
                }
                this.styles = tmpStyles;
            } else if (this.styleCount > _modifyEnd) {
                System.arraycopy(this.styles, _modifyEnd, this.styles, modifyStart + _mergeCount, this.styleCount - _modifyEnd);
            }
            j = modifyStart;
            i = 0;
            while (i < _mergeCount) {
                newStyle = mergeStyles[i];
                if (j <= 0) ** GOTO lbl-1000
                style = this.styles[j - 1];
                if (style.start + style.length == newStyle.start && newStyle.similarTo(style)) {
                    style.length += newStyle.length;
                } else lbl-1000:
                // 2 sources

                {
                    this.styles[j++] = newStyle;
                }
                ++i;
            }
            style = this.styles[j - 1];
            if (endStyle != null && style.start + style.length == endStyle.start && endStyle.similarTo(style)) {
                style.length += endStyle.length;
                ++_modifyEnd;
                ++_mergeCount;
            }
            if (this.styleCount > _modifyEnd) {
                System.arraycopy(this.styles, modifyStart + _mergeCount, this.styles, j, this.styleCount - _modifyEnd);
            }
            grow = j - modifyStart - (_modifyEnd - modifyStart);
            this.styleCount += grow;
            return grow;
        }

        void updateRanges(int start, int replaceCharCount, int newCharCount) {
            if (this.styleCount == 0 || replaceCharCount == 0 && newCharCount == 0) {
                return;
            }
            if (this.ranges != null) {
                int rangeCount = this.styleCount << 1;
                int modifyStart = this.getRangeIndex(start, -1, rangeCount);
                if (modifyStart == rangeCount) {
                    return;
                }
                int end = start + replaceCharCount;
                int modifyEnd = this.getRangeIndex(end, modifyStart - 1, rangeCount);
                int offset = newCharCount - replaceCharCount;
                if (modifyStart == modifyEnd && this.ranges[modifyStart] < start && end < this.ranges[modifyEnd] + this.ranges[modifyEnd + 1]) {
                    if (newCharCount == 0) {
                        int n = modifyStart + 1;
                        this.ranges[n] = this.ranges[n] - replaceCharCount;
                        modifyEnd += 2;
                    } else {
                        if (rangeCount + 2 > this.ranges.length) {
                            int[] newRanges = new int[this.ranges.length + 64];
                            System.arraycopy(this.ranges, 0, newRanges, 0, rangeCount);
                            this.ranges = newRanges;
                            StyleRange[] newStyles = new StyleRange[this.styles.length + 32];
                            System.arraycopy(this.styles, 0, newStyles, 0, this.styleCount);
                            this.styles = newStyles;
                        }
                        System.arraycopy(this.ranges, modifyStart + 2, this.ranges, modifyStart + 4, rangeCount - (modifyStart + 2));
                        System.arraycopy(this.styles, modifyStart + 2 >> 1, this.styles, modifyStart + 4 >> 1, this.styleCount - (modifyStart + 2 >> 1));
                        this.ranges[modifyStart + 3] = this.ranges[modifyStart] + this.ranges[modifyStart + 1] - end;
                        this.ranges[modifyStart + 2] = start + newCharCount;
                        this.ranges[modifyStart + 1] = start - this.ranges[modifyStart];
                        this.styles[(modifyStart >> 1) + 1] = this.styles[modifyStart >> 1];
                        rangeCount += 2;
                        ++this.styleCount;
                        modifyEnd += 4;
                    }
                    if (offset != 0) {
                        int i = modifyEnd;
                        while (i < rangeCount) {
                            int n = i;
                            this.ranges[n] = this.ranges[n] + offset;
                            i += 2;
                        }
                    }
                } else {
                    if (this.ranges[modifyStart] < start && start < this.ranges[modifyStart] + this.ranges[modifyStart + 1]) {
                        this.ranges[modifyStart + 1] = start - this.ranges[modifyStart];
                        modifyStart += 2;
                    }
                    if (modifyEnd < rangeCount && this.ranges[modifyEnd] < end && end < this.ranges[modifyEnd] + this.ranges[modifyEnd + 1]) {
                        this.ranges[modifyEnd + 1] = this.ranges[modifyEnd] + this.ranges[modifyEnd + 1] - end;
                        this.ranges[modifyEnd] = end;
                    }
                    if (offset != 0) {
                        int i = modifyEnd;
                        while (i < rangeCount) {
                            int n = i;
                            this.ranges[n] = this.ranges[n] + offset;
                            i += 2;
                        }
                    }
                    System.arraycopy(this.ranges, modifyEnd, this.ranges, modifyStart, rangeCount - modifyEnd);
                    System.arraycopy(this.styles, modifyEnd >> 1, this.styles, modifyStart >> 1, this.styleCount - (modifyEnd >> 1));
                    this.styleCount -= modifyEnd - modifyStart >> 1;
                }
            } else {
                int modifyStart = this.getRangeIndex(start, -1, this.styleCount);
                if (modifyStart == this.styleCount) {
                    return;
                }
                int end = start + replaceCharCount;
                int modifyEnd = this.getRangeIndex(end, modifyStart - 1, this.styleCount);
                int offset = newCharCount - replaceCharCount;
                if (modifyStart == modifyEnd && this.styles[modifyStart].start < start && end < this.styles[modifyEnd].start + this.styles[modifyEnd].length) {
                    if (newCharCount == 0) {
                        this.styles[modifyStart].length -= replaceCharCount;
                        ++modifyEnd;
                    } else {
                        if (this.styleCount + 1 > this.styles.length) {
                            StyleRange[] newStyles = new StyleRange[this.styles.length + 32];
                            System.arraycopy(this.styles, 0, newStyles, 0, this.styleCount);
                            this.styles = newStyles;
                        }
                        System.arraycopy(this.styles, modifyStart + 1, this.styles, modifyStart + 2, this.styleCount - (modifyStart + 1));
                        this.styles[modifyStart + 1] = (StyleRange)this.styles[modifyStart].clone();
                        this.styles[modifyStart + 1].length = this.styles[modifyStart].start + this.styles[modifyStart].length - end;
                        this.styles[modifyStart + 1].start = start + newCharCount;
                        this.styles[modifyStart].length = start - this.styles[modifyStart].start;
                        ++this.styleCount;
                        modifyEnd += 2;
                    }
                    if (offset != 0) {
                        int i = modifyEnd;
                        while (i < this.styleCount) {
                            this.styles[i].start += offset;
                            ++i;
                        }
                    }
                } else {
                    if (this.styles[modifyStart].start < start && start < this.styles[modifyStart].start + this.styles[modifyStart].length) {
                        this.styles[modifyStart].length = start - this.styles[modifyStart].start;
                        ++modifyStart;
                    }
                    if (modifyEnd < this.styleCount && this.styles[modifyEnd].start < end && end < this.styles[modifyEnd].start + this.styles[modifyEnd].length) {
                        this.styles[modifyEnd].length = this.styles[modifyEnd].start + this.styles[modifyEnd].length - end;
                        this.styles[modifyEnd].start = end;
                    }
                    if (offset != 0) {
                        int i = modifyEnd;
                        while (i < this.styleCount) {
                            this.styles[i].start += offset;
                            ++i;
                        }
                    }
                    System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart, this.styleCount - modifyEnd);
                    this.styleCount -= modifyEnd - modifyStart;
                }
            }
        }

        StyleRange[] getStyleRanges(int start, int length, boolean includeRanges) {
            StyleRange[] newStyles;
            if (length == 0) {
                return null;
            }
            int end = start + length - 1;
            if (this.ranges != null) {
                int rangeCount = this.styleCount << 1;
                int rangeStart = this.getRangeIndex(start, -1, rangeCount);
                if (rangeStart >= rangeCount) {
                    return null;
                }
                if (this.ranges[rangeStart] > end) {
                    return null;
                }
                int rangeEnd = Math.min(rangeCount - 2, this.getRangeIndex(end, rangeStart - 1, rangeCount));
                if (this.ranges[rangeEnd] > end) {
                    rangeEnd = Math.max(rangeStart, rangeEnd - 2);
                }
                newStyles = new StyleRange[(rangeEnd - rangeStart >> 1) + 1];
                if (includeRanges) {
                    int i = rangeStart;
                    int j = 0;
                    while (i <= rangeEnd) {
                        newStyles[j] = (StyleRange)this.styles[i >> 1].clone();
                        newStyles[j].start = this.ranges[i];
                        newStyles[j].length = this.ranges[i + 1];
                        i += 2;
                        ++j;
                    }
                } else {
                    System.arraycopy(this.styles, rangeStart >> 1, newStyles, 0, newStyles.length);
                }
            } else {
                int rangeStart = this.getRangeIndex(start, -1, this.styleCount);
                if (rangeStart >= this.styleCount) {
                    return null;
                }
                if (this.styles[rangeStart].start > end) {
                    return null;
                }
                int rangeEnd = Math.min(this.styleCount - 1, this.getRangeIndex(end, rangeStart - 1, this.styleCount));
                if (this.styles[rangeEnd].start > end) {
                    rangeEnd = Math.max(rangeStart, rangeEnd - 1);
                }
                newStyles = new StyleRange[rangeEnd - rangeStart + 1];
                System.arraycopy(this.styles, rangeStart, newStyles, 0, newStyles.length);
            }
            if (includeRanges || this.ranges == null) {
                StyleRange style = newStyles[0];
                if (start > style.start) {
                    newStyles[0] = style = (StyleRange)style.clone();
                    style.length = style.start + style.length - start;
                    style.start = start;
                }
                style = newStyles[newStyles.length - 1];
                if (end < style.start + style.length - 1) {
                    newStyles[newStyles.length - 1] = style = (StyleRange)style.clone();
                    style.length = end - style.start + 1;
                }
            }
            return newStyles;
        }
    }
}

