/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.property;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.property.ValidationStatusPropertyOwner;

public class StatusAggregator
implements ValidationStatusPropertyOwner {
    private List<ValidationStatusPropertyOwner> list = new ArrayList<ValidationStatusPropertyOwner>();
    private ReadOnlyObjectWrapper<Status> statusProperty = new ReadOnlyObjectWrapper((Object)this, "statusProperty", (Object)Status.ok());
    private static Comparator<Status> STATUS_SORTER = (s1, s2) -> s1.getState().compareTo(s2.getState());
    private static Predicate<Status> WARNING_ERROR = s -> s.getState() == Status.State.ERROR || s.getState() == Status.State.WARNING;
    private final AtomicBoolean validationScheduled = new AtomicBoolean();

    public StatusAggregator(ValidationStatusPropertyOwner ... properties) {
        Stream.of(properties).forEach(this::register);
    }

    public Subscription register(ValidationStatusPropertyOwner property) {
        property.statusProperty().addListener(this::handleBindingStatusChange);
        this.list.add(property);
        return () -> {
            property.statusProperty().removeListener(this::handleBindingStatusChange);
            this.list.remove(property);
        };
    }

    private void handleBindingStatusChange(Observable o, Status ol, Status ne) {
        if (this.validationScheduled.getAndSet(true)) {
            return;
        }
        Platform.runLater(this::_validate);
    }

    @Override
    public ReadOnlyObjectProperty<Status> statusProperty() {
        return this.statusProperty.getReadOnlyProperty();
    }

    @Override
    public void validate() {
        this._validate();
    }

    private void _validate() {
        this.statusProperty.set((Object)this.list.stream().map(b -> (Status)b.statusProperty().get()).sorted(STATUS_SORTER).filter(WARNING_ERROR).findFirst().orElse(Status.ok()));
        this.validationScheduled.set(false);
    }
}

