/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import org.eclipse.fx.ui.panes.AbstractLayoutPane;
import org.eclipse.fx.ui.panes.GridData;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GridLayoutPane
extends AbstractLayoutPane<GridData> {
    private static final @NonNull String LAYOUT_KEY = "gridData";
    private static final CssMetaData<GridLayoutPane, Number> NUM_COLUMNS = new CssMetaData<GridLayoutPane, Number>("-fx-columns", SizeConverter.getInstance(), (Number)1){

        public boolean isSettable(GridLayoutPane node) {
            return !node.numColumnsProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.numColumnsProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Boolean> MAKE_COLS_EQUAL_WIDTH = new CssMetaData<GridLayoutPane, Boolean>("-fx-columns-equal-width", BooleanConverter.getInstance(), Boolean.FALSE){

        public boolean isSettable(GridLayoutPane node) {
            return !node.makeColumnsEqualWidthProperty().isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.makeColumnsEqualWidthProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Number> MARGIN_WIDTH = new CssMetaData<GridLayoutPane, Number>("-fx-inner-margin-width", SizeConverter.getInstance(), (Number)5){

        public boolean isSettable(GridLayoutPane node) {
            return !node.marginWidthProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.marginWidthProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Number> MARGIN_HEIGHT = new CssMetaData<GridLayoutPane, Number>("-fx-inner-margin-height", SizeConverter.getInstance(), (Number)5){

        public boolean isSettable(GridLayoutPane node) {
            return !node.marginHeightProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.marginHeightProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Number> MARGIN_LEFT = new CssMetaData<GridLayoutPane, Number>("-fx-inner-margin-left", SizeConverter.getInstance(), (Number)0){

        public boolean isSettable(GridLayoutPane node) {
            return !node.marginLeftProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.marginLeftProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Number> MARGIN_TOP = new CssMetaData<GridLayoutPane, Number>("-fx-inner-margin-top", SizeConverter.getInstance(), (Number)0){

        public boolean isSettable(GridLayoutPane node) {
            return !node.marginTopProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.marginTopProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Number> MARGIN_RIGHT = new CssMetaData<GridLayoutPane, Number>("-fx-inner-margin-right", SizeConverter.getInstance(), (Number)0){

        public boolean isSettable(GridLayoutPane node) {
            return !node.marginRightProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.marginRightProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Number> MARGIN_BOTTOM = new CssMetaData<GridLayoutPane, Number>("-fx-inner-margin-bottom", SizeConverter.getInstance(), (Number)0){

        public boolean isSettable(GridLayoutPane node) {
            return !node.marginBottomProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.marginBottomProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Number> HORIZONTAL_SPACING = new CssMetaData<GridLayoutPane, Number>("-fx-hspace", SizeConverter.getInstance(), (Number)5){

        public boolean isSettable(GridLayoutPane node) {
            return !node.horizontalSpacingProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.horizontalSpacingProperty();
        }
    };
    private static final CssMetaData<GridLayoutPane, Number> VERTICAL_SPACING = new CssMetaData<GridLayoutPane, Number>("-fx-vspace", SizeConverter.getInstance(), (Number)5){

        public boolean isSettable(GridLayoutPane node) {
            return !node.verticalSpacingProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(GridLayoutPane node) {
            return (StyleableProperty)node.verticalSpacingProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private final @NonNull IntegerProperty numColumns = new SimpleStyleableIntegerProperty(NUM_COLUMNS, (Object)this, "columns", Integer.valueOf(1));
    private final @NonNull BooleanProperty makeColumnsEqualWidth = new SimpleStyleableBooleanProperty(MAKE_COLS_EQUAL_WIDTH, (Object)this, "makeColumnsEqualWidth", false);
    private final @NonNull IntegerProperty marginWidth = new SimpleStyleableIntegerProperty(MARGIN_WIDTH, (Object)this, "marginWidth", Integer.valueOf(5));
    private final @NonNull IntegerProperty marginHeight = new SimpleStyleableIntegerProperty(MARGIN_HEIGHT, (Object)this, "marginHeight", Integer.valueOf(5));
    private final @NonNull IntegerProperty marginLeft = new SimpleStyleableIntegerProperty(MARGIN_LEFT, (Object)this, "marginLeft", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginTop = new SimpleStyleableIntegerProperty(MARGIN_TOP, (Object)this, "marginTop", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginRight = new SimpleStyleableIntegerProperty(MARGIN_RIGHT, (Object)this, "marginRight", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginBottom = new SimpleStyleableIntegerProperty(MARGIN_BOTTOM, (Object)this, "marginBottom", Integer.valueOf(0));
    private final @NonNull IntegerProperty horizontalSpacing = new SimpleStyleableIntegerProperty(HORIZONTAL_SPACING, (Object)this, "horizontalSpacing", Integer.valueOf(5));
    private final @NonNull IntegerProperty verticalSpacing = new SimpleStyleableIntegerProperty(VERTICAL_SPACING, (Object)this, "verticalSpacing", Integer.valueOf(5));

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(AbstractLayoutPane.getClassCssMetaData());
        styleables.add(HORIZONTAL_SPACING);
        styleables.add(MAKE_COLS_EQUAL_WIDTH);
        styleables.add(MARGIN_BOTTOM);
        styleables.add(MARGIN_HEIGHT);
        styleables.add(MARGIN_LEFT);
        styleables.add(MARGIN_RIGHT);
        styleables.add(MARGIN_TOP);
        styleables.add(MARGIN_WIDTH);
        styleables.add(VERTICAL_SPACING);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GridLayoutPane.getClassCssMetaData();
    }

    public static final void setConstraint(@NonNull Node n, @NonNull GridData griddata) {
        GridLayoutPane.setConstraint(n, LAYOUT_KEY, griddata);
    }

    public static final @Nullable GridData getConstraint(@NonNull Node n) {
        return (GridData)GridLayoutPane.getConstraint(n, LAYOUT_KEY);
    }

    @Override
    protected AbstractLayoutPane.Size computeSize(double width, double height, boolean flushCache) {
        @NonNull AbstractLayoutPane.Size size = this.calculateLayout(false, 0.0, 0.0, width, height, flushCache);
        return size;
    }

    @Override
    protected double computeMinHeight(double width) {
        return this.computeSize((double)-1.0, (double)-1.0, (boolean)true).height;
    }

    @Override
    protected double computeMinWidth(double height) {
        return this.computeSize((double)-1.0, (double)-1.0, (boolean)true).width;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.calculateLayout(true, this.getLayoutBounds().getMinX(), this.getLayoutBounds().getMinY(), this.getLayoutBounds().getWidth(), this.getLayoutBounds().getHeight(), true);
    }

    private @NonNull AbstractLayoutPane.Size calculateLayout(boolean move, double x, double y, double width, double height, boolean flushCache) {
        int i;
        int i2;
        GridData data;
        if (this.getNumColumns() < 1) {
            return new AbstractLayoutPane.Size(this.getInnerMarginLeft() + this.getInnerMarginRight(), this.getInnerMarginTop() + this.getInnerMarginBottom());
        }
        @NonNull Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = 0;
        int i3 = 0;
        while (i3 < children.length) {
            Node control = children[i3];
            data = GridLayoutPane.getConstraint(control);
            if (data == null || !data.isExclude()) {
                children[count++] = children[i3];
            }
            ++i3;
        }
        if (count == 0) {
            return new AbstractLayoutPane.Size(this.getInnerMarginLeft() + this.getInnerMarginRight(), this.getInnerMarginTop() + this.getInnerMarginBottom());
        }
        i3 = 0;
        while (i3 < count) {
            Node child = children[i3];
            data = GridLayoutPane.getConstraint(child);
            if (data == null) {
                data = new GridData();
                GridLayoutPane.setConstraint(child, data);
            }
            if (flushCache) {
                data.flushCache();
            }
            data.computeSize(child, data.getWidthHint(), data.getHeightHint(), flushCache);
            if (data.isGrabExcessHorizontalSpace() && data.getMinimumWidth() > 0 && data.cacheWidth < (double)data.getMinimumWidth()) {
                int trim = 0;
                data.cacheHeight = -1.0;
                data.cacheWidth = -1.0;
                data.computeSize(child, Math.max(0, data.getMinimumWidth() - trim), data.getHeightHint(), false);
            }
            if (data.isGrabExcessVerticalSpace() && data.getMinimumHeight() > 0) {
                data.cacheHeight = Math.max(data.cacheHeight, (double)data.getMinimumHeight());
            }
            ++i3;
        }
        int row = 0;
        int column = 0;
        int rowCount = 0;
        int columnCount = this.getNumColumns();
        Node[][] grid = new Node[4][columnCount];
        int i4 = 0;
        while (i4 < count) {
            Node child = children[i4];
            GridData data2 = GridLayoutPane.getConstraint(child);
            if (data2 == null) {
                data2 = new GridData();
            }
            int hSpan = Math.max(1, Math.min(data2.getHorizontalSpan(), columnCount));
            int vSpan = Math.max(1, data2.getVerticalSpan());
            while (true) {
                int lastRow;
                if ((lastRow = row + vSpan) >= grid.length) {
                    Node[][] newGrid = new Node[lastRow + 4][columnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row] == null) {
                    grid[row] = new Node[columnCount];
                }
                while (column < columnCount && grid[row][column] != null) {
                    ++column;
                }
                int endCount = column + hSpan;
                if (endCount <= columnCount) {
                    int index = column;
                    while (index < endCount && grid[row][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column = index;
                }
                if (column + hSpan < columnCount) continue;
                column = 0;
                ++row;
            }
            int j = 0;
            while (j < vSpan) {
                if (grid[row + j] == null) {
                    grid[row + j] = new Node[columnCount];
                }
                int k = 0;
                while (k < hSpan) {
                    grid[row + j][column + k] = child;
                    ++k;
                }
                ++j;
            }
            rowCount = Math.max(rowCount, row + vSpan);
            column += hSpan;
            ++i4;
        }
        double availableWidth = width - (double)(this.getHorizontalSpacing() * (columnCount - 1)) - (double)(this.getInnerMarginLeft() + this.getInnerMarginRight());
        int expandCount = 0;
        double[] widths = new double[columnCount];
        double[] minWidths = new double[columnCount];
        boolean[] expandColumn = new boolean[columnCount];
        int j = 0;
        while (j < columnCount) {
            int hSpan;
            GridData data3;
            i2 = 0;
            while (i2 < rowCount) {
                data3 = GridLayoutPane.getData(grid, i2, j, rowCount, columnCount, true);
                if (data3 != null && (hSpan = Math.max(1, Math.min(data3.getHorizontalSpan(), columnCount))) == 1) {
                    double w = data3.cacheWidth + (double)data3.getHorizontalIndent();
                    widths[j] = Math.max(widths[j], w);
                    if (data3.isGrabExcessHorizontalSpace()) {
                        if (!expandColumn[j]) {
                            ++expandCount;
                        }
                        expandColumn[j] = true;
                    }
                    if (!data3.isGrabExcessHorizontalSpace() || data3.getMinimumWidth() != 0) {
                        w = !data3.isGrabExcessHorizontalSpace() || data3.getMinimumWidth() == -1 ? data3.cacheWidth : (double)data3.getMinimumWidth();
                        minWidths[j] = Math.max(minWidths[j], w += (double)data3.getHorizontalIndent());
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < rowCount) {
                data3 = GridLayoutPane.getData(grid, i2, j, rowCount, columnCount, false);
                if (data3 != null && (hSpan = Math.max(1, Math.min(data3.getHorizontalSpan(), columnCount))) > 1) {
                    double delta;
                    int k;
                    int last;
                    double remainder;
                    double w;
                    int spanWidth = 0;
                    int spanMinWidth = 0;
                    int spanExpandCount = 0;
                    int k2 = 0;
                    while (k2 < hSpan) {
                        spanWidth = (int)((double)spanWidth + widths[j - k2]);
                        spanMinWidth = (int)((double)spanMinWidth + minWidths[j - k2]);
                        if (expandColumn[j - k2]) {
                            ++spanExpandCount;
                        }
                        ++k2;
                    }
                    if (data3.isGrabExcessHorizontalSpace() && spanExpandCount == 0) {
                        ++expandCount;
                        expandColumn[j] = true;
                    }
                    if ((w = data3.cacheWidth + (double)data3.getHorizontalIndent() - (double)spanWidth - (double)((hSpan - 1) * this.getHorizontalSpacing())) > 0.0) {
                        if (this.isMakeColumnsEqualWidth()) {
                            double equalWidth = (w + (double)spanWidth) / (double)hSpan;
                            remainder = (w + (double)spanWidth) % (double)hSpan;
                            last = -1;
                            k = 0;
                            while (k < hSpan) {
                                last = j - k;
                                widths[last] = Math.max(equalWidth, widths[j - k]);
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        } else if (spanExpandCount == 0) {
                            int n = j;
                            widths[n] = widths[n] + w;
                        } else {
                            delta = w / (double)spanExpandCount;
                            remainder = w % (double)spanExpandCount;
                            last = -1;
                            k = 0;
                            while (k < hSpan) {
                                if (expandColumn[j - k]) {
                                    last = j - k;
                                    widths[last] = widths[last] + delta;
                                }
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        }
                    }
                    if (!data3.isGrabExcessHorizontalSpace() || data3.getMinimumWidth() != 0) {
                        w = !data3.isGrabExcessHorizontalSpace() || data3.getMinimumWidth() == -1 ? data3.cacheWidth : (double)data3.getMinimumWidth();
                        if ((w += (double)(data3.getHorizontalIndent() - spanMinWidth - (hSpan - 1) * this.getHorizontalSpacing())) > 0.0) {
                            if (spanExpandCount == 0) {
                                int n = j;
                                minWidths[n] = minWidths[n] + w;
                            } else {
                                delta = w / (double)spanExpandCount;
                                remainder = w % (double)spanExpandCount;
                                last = -1;
                                k = 0;
                                while (k < hSpan) {
                                    if (expandColumn[j - k]) {
                                        last = j - k;
                                        minWidths[last] = minWidths[last] + delta;
                                    }
                                    ++k;
                                }
                                if (last > -1) {
                                    int n = last;
                                    minWidths[n] = minWidths[n] + remainder;
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
            ++j;
        }
        if (this.isMakeColumnsEqualWidth()) {
            double minColumnWidth = 0.0;
            double columnWidth = 0.0;
            int i5 = 0;
            while (i5 < columnCount) {
                minColumnWidth = Math.max(minColumnWidth, minWidths[i5]);
                columnWidth = Math.max(columnWidth, widths[i5]);
                ++i5;
            }
            columnWidth = width == -1.0 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / (double)columnCount);
            i5 = 0;
            while (i5 < columnCount) {
                expandColumn[i5] = expandCount > 0;
                widths[i5] = columnWidth;
                ++i5;
            }
        } else if (width != -1.0 && expandCount > 0) {
            int totalWidth = 0;
            i2 = 0;
            while (i2 < columnCount) {
                totalWidth = (int)((double)totalWidth + widths[i2]);
                ++i2;
            }
            int c = expandCount;
            double delta = (availableWidth - (double)totalWidth) / (double)c;
            double remainder = (availableWidth - (double)totalWidth) % (double)c;
            int last = -1;
            while ((double)totalWidth != availableWidth) {
                int j2 = 0;
                while (j2 < columnCount) {
                    if (expandColumn[j2]) {
                        if (widths[j2] + delta > minWidths[j2]) {
                            last = j2;
                            widths[last] = widths[j2] + delta;
                        } else {
                            widths[j2] = minWidths[j2];
                            expandColumn[j2] = false;
                            --c;
                        }
                    }
                    ++j2;
                }
                if (last > -1) {
                    int n = last;
                    widths[n] = widths[n] + remainder;
                }
                j2 = 0;
                while (j2 < columnCount) {
                    i = 0;
                    while (i < rowCount) {
                        int hSpan;
                        GridData data4 = GridLayoutPane.getData(grid, i, j2, rowCount, columnCount, false);
                        if (!(data4 == null || (hSpan = Math.max(1, Math.min(data4.getHorizontalSpan(), columnCount))) <= 1 || data4.isGrabExcessHorizontalSpace() && data4.getMinimumWidth() == 0)) {
                            int spanWidth = 0;
                            int spanExpandCount = 0;
                            int k = 0;
                            while (k < hSpan) {
                                spanWidth = (int)((double)spanWidth + widths[j2 - k]);
                                if (expandColumn[j2 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            double w = !data4.isGrabExcessHorizontalSpace() || data4.getMinimumWidth() == -1 ? data4.cacheWidth : (double)data4.getMinimumWidth();
                            if ((w += (double)(data4.getHorizontalIndent() - spanWidth - (hSpan - 1) * this.getHorizontalSpacing())) > 0.0) {
                                if (spanExpandCount == 0) {
                                    int n = j2;
                                    widths[n] = widths[n] + w;
                                } else {
                                    double delta2 = w / (double)spanExpandCount;
                                    double remainder2 = w % (double)spanExpandCount;
                                    int last2 = -1;
                                    int k3 = 0;
                                    while (k3 < hSpan) {
                                        if (expandColumn[j2 - k3]) {
                                            last2 = j2 - k3;
                                            widths[last2] = widths[last2] + delta2;
                                        }
                                        ++k3;
                                    }
                                    if (last2 > -1) {
                                        int n = last2;
                                        widths[n] = widths[n] + remainder2;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++j2;
                }
                if (c != 0) {
                    totalWidth = 0;
                    int i6 = 0;
                    while (i6 < columnCount) {
                        totalWidth = (int)((double)totalWidth + widths[i6]);
                        ++i6;
                    }
                    delta = (availableWidth - (double)totalWidth) / (double)c;
                    remainder = (availableWidth - (double)totalWidth) % (double)c;
                    last = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] flush = null;
        int flushLength = 0;
        if (width != -1.0) {
            int j3 = 0;
            while (j3 < columnCount) {
                int i7 = 0;
                while (i7 < rowCount) {
                    GridData data5 = GridLayoutPane.getData(grid, i7, j3, rowCount, columnCount, false);
                    if (data5 != null && data5.getHeightHint() == -1) {
                        Node child = grid[i7][j3];
                        int hSpan = Math.max(1, Math.min(data5.getHorizontalSpan(), columnCount));
                        int currentWidth = 0;
                        int k = 0;
                        while (k < hSpan) {
                            currentWidth = (int)((double)currentWidth + widths[j3 - k]);
                            ++k;
                        }
                        if ((double)(currentWidth += (hSpan - 1) * this.getHorizontalSpacing() - data5.getHorizontalIndent()) != data5.cacheWidth && data5.getHorizontalAlignment() == GridData.Alignment.FILL || data5.cacheWidth > (double)currentWidth) {
                            int trim = 0;
                            data5.cacheHeight = -1.0;
                            data5.cacheWidth = -1.0;
                            data5.computeSize(child, Math.max(0, currentWidth - trim), data5.getHeightHint(), false);
                            if (data5.isGrabExcessVerticalSpace() && data5.getMinimumHeight() > 0) {
                                data5.cacheHeight = Math.max(data5.cacheHeight, (double)data5.getMinimumHeight());
                            }
                            if (flush == null) {
                                flush = new GridData[count];
                            }
                            flush[flushLength++] = data5;
                        }
                    }
                    ++i7;
                }
                ++j3;
            }
        }
        double availableHeight = height - (double)(this.getVerticalSpacing() * (rowCount - 1)) - (double)(this.getInnerMarginTop() + this.getInnerMarginBottom());
        expandCount = 0;
        double[] heights = new double[rowCount];
        double[] minHeights = new double[rowCount];
        boolean[] expandRow = new boolean[rowCount];
        int i8 = 0;
        while (i8 < rowCount) {
            int vSpan;
            int j4 = 0;
            while (j4 < columnCount) {
                GridData data6 = GridLayoutPane.getData(grid, i8, j4, rowCount, columnCount, true);
                if (data6 != null && (vSpan = Math.max(1, Math.min(data6.getVerticalSpan(), rowCount))) == 1) {
                    double h = data6.cacheHeight + (double)data6.getVerticalIndent();
                    heights[i8] = Math.max(heights[i8], h);
                    if (data6.isGrabExcessVerticalSpace()) {
                        if (!expandRow[i8]) {
                            ++expandCount;
                        }
                        expandRow[i8] = true;
                    }
                    if (!data6.isGrabExcessVerticalSpace() || data6.getMinimumHeight() != 0) {
                        h = !data6.isGrabExcessVerticalSpace() || data6.getMinimumHeight() == -1 ? data6.cacheHeight : (double)data6.getMinimumHeight();
                        minHeights[i8] = Math.max(minHeights[i8], h += (double)data6.getVerticalIndent());
                    }
                }
                ++j4;
            }
            j4 = 0;
            while (j4 < columnCount) {
                GridData data7 = GridLayoutPane.getData(grid, i8, j4, rowCount, columnCount, false);
                if (data7 != null && (vSpan = Math.max(1, Math.min(data7.getVerticalSpan(), rowCount))) > 1) {
                    int k;
                    int last;
                    double remainder;
                    double delta;
                    double h;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k4 = 0;
                    while (k4 < vSpan) {
                        spanHeight = (int)((double)spanHeight + heights[i8 - k4]);
                        spanMinHeight = (int)((double)spanMinHeight + minHeights[i8 - k4]);
                        if (expandRow[i8 - k4]) {
                            ++spanExpandCount;
                        }
                        ++k4;
                    }
                    if (data7.isGrabExcessVerticalSpace() && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i8] = true;
                    }
                    if ((h = data7.cacheHeight + (double)data7.getVerticalIndent() - (double)spanHeight - (double)((vSpan - 1) * this.getVerticalSpacing())) > 0.0) {
                        if (spanExpandCount == 0) {
                            int n = i8;
                            heights[n] = heights[n] + h;
                        } else {
                            delta = h / (double)spanExpandCount;
                            remainder = h % (double)spanExpandCount;
                            last = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i8 - k]) {
                                    last = i8 - k;
                                    heights[last] = heights[last] + delta;
                                }
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                heights[n] = heights[n] + remainder;
                            }
                        }
                    }
                    if (!data7.isGrabExcessVerticalSpace() || data7.getMinimumHeight() != 0) {
                        h = !data7.isGrabExcessVerticalSpace() || data7.getMinimumHeight() == -1 ? data7.cacheHeight : (double)data7.getMinimumHeight();
                        if ((h += (double)(data7.getVerticalIndent() - spanMinHeight - (vSpan - 1) * this.getVerticalSpacing())) > 0.0) {
                            if (spanExpandCount == 0) {
                                int n = i8;
                                minHeights[n] = minHeights[n] + h;
                            } else {
                                delta = h / (double)spanExpandCount;
                                remainder = h % (double)spanExpandCount;
                                last = -1;
                                k = 0;
                                while (k < vSpan) {
                                    if (expandRow[i8 - k]) {
                                        last = i8 - k;
                                        minHeights[last] = minHeights[last] + delta;
                                    }
                                    ++k;
                                }
                                if (last > -1) {
                                    int n = last;
                                    minHeights[n] = minHeights[n] + remainder;
                                }
                            }
                        }
                    }
                }
                ++j4;
            }
            ++i8;
        }
        if (height != -1.0 && expandCount > 0) {
            int totalHeight = 0;
            i = 0;
            while (i < rowCount) {
                totalHeight = (int)((double)totalHeight + heights[i]);
                ++i;
            }
            int c = expandCount;
            double delta = (availableHeight - (double)totalHeight) / (double)c;
            double remainder = (availableHeight - (double)totalHeight) % (double)c;
            int last = -1;
            while ((double)totalHeight != availableHeight) {
                int i9 = 0;
                while (i9 < rowCount) {
                    if (expandRow[i9]) {
                        if (heights[i9] + delta > minHeights[i9]) {
                            last = i9;
                            heights[last] = heights[i9] + delta;
                        } else {
                            heights[i9] = minHeights[i9];
                            expandRow[i9] = false;
                            --c;
                        }
                    }
                    ++i9;
                }
                if (last > -1) {
                    int n = last;
                    heights[n] = heights[n] + remainder;
                }
                i9 = 0;
                while (i9 < rowCount) {
                    int j5 = 0;
                    while (j5 < columnCount) {
                        int vSpan;
                        GridData data8 = GridLayoutPane.getData(grid, i9, j5, rowCount, columnCount, false);
                        if (!(data8 == null || (vSpan = Math.max(1, Math.min(data8.getVerticalSpan(), rowCount))) <= 1 || data8.isGrabExcessVerticalSpace() && data8.getMinimumHeight() == 0)) {
                            int spanHeight = 0;
                            int spanExpandCount = 0;
                            int k = 0;
                            while (k < vSpan) {
                                spanHeight = (int)((double)spanHeight + heights[i9 - k]);
                                if (expandRow[i9 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            double h = !data8.isGrabExcessVerticalSpace() || data8.getMinimumHeight() == -1 ? data8.cacheHeight : (double)data8.getMinimumHeight();
                            if ((h += (double)(data8.getVerticalIndent() - spanHeight - (vSpan - 1) * this.getVerticalSpacing())) > 0.0) {
                                if (spanExpandCount == 0) {
                                    int n = i9;
                                    heights[n] = heights[n] + h;
                                } else {
                                    double delta2 = h / (double)spanExpandCount;
                                    double remainder2 = h % (double)spanExpandCount;
                                    int last2 = -1;
                                    int k5 = 0;
                                    while (k5 < vSpan) {
                                        if (expandRow[i9 - k5]) {
                                            last2 = i9 - k5;
                                            heights[last2] = heights[last2] + delta2;
                                        }
                                        ++k5;
                                    }
                                    if (last2 > -1) {
                                        int n = last2;
                                        heights[n] = heights[n] + remainder2;
                                    }
                                }
                            }
                        }
                        ++j5;
                    }
                    ++i9;
                }
                if (c == 0) break;
                totalHeight = 0;
                i9 = 0;
                while (i9 < rowCount) {
                    totalHeight = (int)((double)totalHeight + heights[i9]);
                    ++i9;
                }
                delta = (availableHeight - (double)totalHeight) / (double)c;
                remainder = (availableHeight - (double)totalHeight) % (double)c;
                last = -1;
            }
        }
        if (move) {
            double gridY = y + (double)this.getInnerMarginTop();
            int i10 = 0;
            while (i10 < rowCount) {
                double gridX = x + (double)this.getInnerMarginLeft();
                int j6 = 0;
                while (j6 < columnCount) {
                    GridData data9 = GridLayoutPane.getData(grid, i10, j6, rowCount, columnCount, true);
                    if (data9 != null) {
                        int hSpan = Math.max(1, Math.min(data9.getHorizontalSpan(), columnCount));
                        int vSpan = Math.max(1, data9.getVerticalSpan());
                        int cellWidth = 0;
                        int cellHeight = 0;
                        int k = 0;
                        while (k < hSpan) {
                            cellWidth = (int)((double)cellWidth + widths[j6 + k]);
                            ++k;
                        }
                        k = 0;
                        while (k < vSpan) {
                            cellHeight = (int)((double)cellHeight + heights[i10 + k]);
                            ++k;
                        }
                        double childX = gridX + (double)data9.getHorizontalIndent();
                        double childWidth = Math.min(data9.cacheWidth, (double)(cellWidth += this.getHorizontalSpacing() * (hSpan - 1)));
                        switch (data9.getHorizontalAlignment()) {
                            case CENTER: {
                                childX += Math.max(0.0, ((double)(cellWidth - data9.getHorizontalIndent()) - childWidth) / 2.0);
                                break;
                            }
                            case END: {
                                childX += Math.max(0.0, (double)(cellWidth - data9.getHorizontalIndent()) - childWidth);
                                break;
                            }
                            case FILL: {
                                childWidth = cellWidth - data9.getHorizontalIndent();
                                break;
                            }
                        }
                        double childY = gridY + (double)data9.getVerticalIndent();
                        double childHeight = Math.min(data9.cacheHeight, (double)(cellHeight += this.getVerticalSpacing() * (vSpan - 1)));
                        switch (data9.getVerticalAlignment()) {
                            case CENTER: {
                                childY += Math.max(0.0, ((double)(cellHeight - data9.getVerticalIndent()) - childHeight) / 2.0);
                                break;
                            }
                            case END: {
                                childY += Math.max(0.0, (double)(cellHeight - data9.getVerticalIndent()) - childHeight);
                                break;
                            }
                            case FILL: {
                                childHeight = cellHeight - data9.getVerticalIndent();
                                break;
                            }
                        }
                        Node child = grid[i10][j6];
                        if (child != null) {
                            child.resizeRelocate(childX, childY, childWidth, childHeight);
                        }
                    }
                    gridX += widths[j6] + (double)this.getHorizontalSpacing();
                    ++j6;
                }
                gridY += heights[i10] + (double)this.getVerticalSpacing();
                ++i10;
            }
        }
        i = 0;
        while (i < flushLength) {
            if (flush != null) {
                flush[i].cacheHeight = -1.0;
                flush[i].cacheWidth = -1.0;
            }
            ++i;
        }
        int totalDefaultWidth = 0;
        int totalDefaultHeight = 0;
        int i11 = 0;
        while (i11 < columnCount) {
            totalDefaultWidth = (int)((double)totalDefaultWidth + widths[i11]);
            ++i11;
        }
        i11 = 0;
        while (i11 < rowCount) {
            totalDefaultHeight = (int)((double)totalDefaultHeight + heights[i11]);
            ++i11;
        }
        return new AbstractLayoutPane.Size(totalDefaultWidth += this.getHorizontalSpacing() * (columnCount - 1) + this.getInnerMarginLeft() + this.getInnerMarginRight(), totalDefaultHeight += this.getVerticalSpacing() * (rowCount - 1) + this.getInnerMarginTop() + this.getInnerMarginBottom());
    }

    private int getInnerMarginLeft() {
        return (int)Math.ceil((double)(this.getMarginWidth() + this.getMarginLeft()) + this.getPadding().getLeft());
    }

    private int getInnerMarginRight() {
        return (int)Math.ceil((double)(this.getMarginWidth() + this.getMarginRight()) + this.getPadding().getRight());
    }

    private int getInnerMarginTop() {
        return (int)Math.ceil((double)(this.getMarginHeight() + this.getMarginTop()) + this.getPadding().getTop());
    }

    private int getInnerMarginBottom() {
        return (int)Math.ceil((double)(this.getMarginHeight() + this.getMarginBottom()) + this.getPadding().getBottom());
    }

    static GridData getData(Node[][] grid, int row, int column, int rowCount, int columnCount, boolean first) {
        Node control = grid[row][column];
        if (control != null) {
            int j;
            GridData data = GridLayoutPane.getConstraint(control);
            if (data == null) {
                data = new GridData();
            }
            int hSpan = Math.max(1, Math.min(data.getHorizontalSpan(), columnCount));
            int vSpan = Math.max(1, data.getVerticalSpan());
            int i = first ? row + vSpan - 1 : row - vSpan + 1;
            int n = j = first ? column + hSpan - 1 : column - hSpan + 1;
            if (i >= 0 && i < rowCount && j >= 0 && j < columnCount && control == grid[i][j]) {
                return data;
            }
        }
        return null;
    }

    public final void setNumColumns(int numColumns) {
        this.numColumnsProperty().set(numColumns);
    }

    public final int getNumColumns() {
        return this.numColumnsProperty().get();
    }

    public final @NonNull IntegerProperty numColumnsProperty() {
        return this.numColumns;
    }

    public final void setMakeColumnsEqualWidth(boolean makeColumnsEqualWidth) {
        this.makeColumnsEqualWidthProperty().set(makeColumnsEqualWidth);
    }

    public final boolean isMakeColumnsEqualWidth() {
        return this.makeColumnsEqualWidthProperty().get();
    }

    public final @NonNull BooleanProperty makeColumnsEqualWidthProperty() {
        return this.makeColumnsEqualWidth;
    }

    public final void setHorizontalSpacing(int value) {
        this.horizontalSpacingProperty().set(value);
    }

    public final int getHorizontalSpacing() {
        return this.horizontalSpacingProperty().get();
    }

    public final @NonNull IntegerProperty horizontalSpacingProperty() {
        return this.horizontalSpacing;
    }

    public final void setMarginWidth(int value) {
        this.marginWidthProperty().set(value);
    }

    public final int getMarginWidth() {
        return this.marginWidthProperty().get();
    }

    public final @NonNull IntegerProperty marginWidthProperty() {
        return this.marginWidth;
    }

    public final void setMarginHeight(int value) {
        this.marginHeightProperty().set(value);
    }

    public final int getMarginHeight() {
        return this.marginHeightProperty().get();
    }

    public final @NonNull IntegerProperty marginHeightProperty() {
        return this.marginHeight;
    }

    public final void setMarginLeft(int value) {
        this.marginLeftProperty().set(value);
    }

    public final int getMarginLeft() {
        return this.marginLeftProperty().get();
    }

    public final @NonNull IntegerProperty marginLeftProperty() {
        return this.marginLeft;
    }

    public final void setMarginTop(int value) {
        this.marginTopProperty().set(value);
    }

    public final int getMarginTop() {
        return this.marginTopProperty().get();
    }

    public final @NonNull IntegerProperty marginTopProperty() {
        return this.marginTop;
    }

    public final void setMarginRight(int value) {
        this.marginRightProperty().set(value);
    }

    public final int getMarginRight() {
        return this.marginRightProperty().get();
    }

    public final @NonNull IntegerProperty marginRightProperty() {
        return this.marginRight;
    }

    public final void setMarginBottom(int value) {
        this.marginBottomProperty().set(value);
    }

    public final int getMarginBottom() {
        return this.marginBottomProperty().get();
    }

    public final @NonNull IntegerProperty marginBottomProperty() {
        return this.marginBottom;
    }

    public final void setVerticalSpacing(int value) {
        this.verticalSpacingProperty().set(value);
    }

    public final int getVerticalSpacing() {
        return this.verticalSpacingProperty().get();
    }

    public final @NonNull IntegerProperty verticalSpacingProperty() {
        return this.verticalSpacing;
    }
}

