/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import org.eclipse.fx.ui.controls.styledtext.internal.NodeCachePane;

public class VerticalLineFlow<M, N>
extends NodeCachePane {
    private Predicate<Set<N>> needsPresentation;
    private BiConsumer<Node, Set<N>> nodePopulator;
    private Function<Integer, Set<N>> converter;
    protected Map<Integer, Double> yOffsetData = new HashMap<Integer, Double>();
    private DoubleProperty lineHeigth = new SimpleDoubleProperty((Object)this, "lineHeight", 16.0);
    private IntegerProperty numberOfLines = new SimpleIntegerProperty((Object)this, "numberOfLines", 0);
    private ObjectProperty<Range<Integer>> visibleLines = new SimpleObjectProperty((Object)this, "visibleLines", (Object)Range.all());
    protected Map<Integer, Node> activeNodes = new HashMap<Integer, Node>();

    public DoubleProperty lineHeightProperty() {
        return this.lineHeigth;
    }

    public double getLineHeight() {
        return this.lineHeigth.get();
    }

    public void setLineHeight(double lineHeight) {
        this.lineHeigth.set(lineHeight);
    }

    public IntegerProperty numberOfLinesProperty() {
        return this.numberOfLines;
    }

    public ObjectProperty<Range<Integer>> visibleLinesProperty() {
        return this.visibleLines;
    }

    public RangeSet<Integer> getVisibleLines() {
        TreeRangeSet visibleLines = TreeRangeSet.create();
        visibleLines.add((Range)this.visibleLines.get());
        return visibleLines.subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.numberOfLines.get())));
    }

    public void setVisibleLines(Range<Integer> visibleLines) {
        this.visibleLines.set(visibleLines);
    }

    public VerticalLineFlow(Function<Integer, Set<N>> converter, Predicate<Set<N>> needsPresentation, Supplier<Node> nodeFactory, BiConsumer<Node, Set<N>> nodePopulator) {
        super(nodeFactory);
        this.needsPresentation = needsPresentation;
        this.nodePopulator = nodePopulator;
        this.converter = converter;
        this.visibleLines.addListener(x -> this.prepareNodes(this.getVisibleLines()));
        this.numberOfLines.addListener(x -> this.prepareNodes(this.getVisibleLines()));
    }

    protected void releaseNode(int lineIndex) {
        Node node = this.activeNodes.remove(lineIndex);
        if (node != null) {
            this.releaseNode(node);
        }
    }

    protected Node getNode(int lineIndex) {
        Node node = this.activeNodes.get(lineIndex);
        if (node == null) {
            node = this.getNode();
        }
        this.activeNodes.put(lineIndex, node);
        return node;
    }

    private void prepareNodes(RangeSet<Integer> range) {
        if (range == null) {
            return;
        }
        Iterator<Map.Entry<Integer, Node>> iterator = this.activeNodes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Node> entry = iterator.next();
            Integer index = entry.getKey();
            if (range.contains((Comparable)index)) continue;
            this.releaseNode(entry.getValue());
            iterator.remove();
        }
        range.asRanges().forEach(r -> ContiguousSet.create((Range)r, (DiscreteDomain)DiscreteDomain.integers()).forEach(index -> this.prepareNode((int)index)));
    }

    private void prepareNode(int lineIndex) {
        Node node = this.getNode(lineIndex);
        this.nodePopulator.accept(node, this.converter.apply(lineIndex));
    }

    public void setLineOffset(int lineIndex, double yOffset) {
        this.yOffsetData.put(lineIndex, yOffset);
        this.requestLayout();
    }

    protected void layoutChildren() {
        this.activeNodes.entrySet().forEach(e -> {
            if (!this.yOffsetData.containsKey(e.getKey())) {
                return;
            }
            double x = 0.0;
            double y = this.yOffsetData.get(e.getKey());
            double width = this.getWidth();
            double height = this.getLineHeight();
            ((Node)e.getValue()).resizeRelocate(x, y, width, height);
        });
    }

    public void update(RangeSet<Integer> r) {
        this.prepareNodes((RangeSet<Integer>)r.subRangeSet((Range)this.visibleLines.get()).subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.numberOfLines.get()))));
    }
}

