/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.linewrap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.eclipse.jdt.internal.formatter.TokenTraverser;

public class CommentWrapExecutor
extends TokenTraverser {
    private final TokenManager tm;
    private final DefaultCodeFormatterOptions options;
    private final ArrayList<Token> nlsTags = new ArrayList();
    private int lineStartPosition;
    private List<Token> blockStructure;
    private boolean simulation;
    private boolean wrapDisabled;
    private Token potentialWrapToken;
    private Token potentialWrapTokenSubstitute;
    private int counterIfWrapped;
    private int counterIfWrappedSubstitute;
    private int lineCounter;

    public CommentWrapExecutor(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
    }

    public int wrapMultiLineComment(Token commentToken, int startPosition, boolean simulate, boolean noWrap) {
        boolean newLinesAtBoundries;
        this.lineCounter = 1;
        this.counter = startPosition;
        List<Token> structure = commentToken.getInternalStructure();
        if (structure == null || structure.isEmpty()) {
            return startPosition + this.tm.getLength(commentToken, startPosition);
        }
        commentToken.setIndent(this.tm.toIndent(startPosition, true));
        this.lineStartPosition = commentToken.getIndent();
        this.simulation = simulate;
        this.wrapDisabled = noWrap;
        this.potentialWrapTokenSubstitute = null;
        this.potentialWrapToken = null;
        this.blockStructure = structure;
        this.traverse(structure, 0);
        boolean bl = newLinesAtBoundries = commentToken.tokenType == 1003 ? this.options.comment_new_lines_at_javadoc_boundaries : this.options.comment_new_lines_at_block_boundaries;
        if (this.lineCounter > 1 && newLinesAtBoundries) {
            Token endingToken = structure.get(structure.size() - 1);
            if (!simulate && endingToken.tokenType != 0) {
                structure.get(0).breakAfter();
                endingToken.breakBefore();
                endingToken.setAlign(1);
            }
            return startPosition + this.tm.getLength(endingToken, startPosition);
        }
        if (this.lineCounter > 1 && !newLinesAtBoundries) {
            this.lineCounter -= 2;
            this.lineCounter -= structure.get(1).getLineBreaksBefore();
            structure.get(1).clearLineBreaksBefore();
            Token last = structure.get(structure.size() - 1);
            this.lineCounter -= last.getLineBreaksBefore();
            last.clearLineBreaksBefore();
        }
        return this.counter;
    }

    public int getLinesCount() {
        return this.lineCounter;
    }

    @Override
    protected boolean token(Token token, int index) {
        boolean canWrap;
        int positionIfNewLine = this.lineStartPosition + token.getAlign() + token.getIndent();
        if (token.tokenType != 0) {
            positionIfNewLine += 3;
        }
        if (this.getLineBreaksBefore() > 0) {
            boolean isFormattedCode;
            this.lineCounter = Math.max(this.lineCounter + this.getLineBreaksBefore(), 4);
            this.counter = positionIfNewLine;
            this.potentialWrapTokenSubstitute = null;
            this.potentialWrapToken = null;
            boolean bl = isFormattedCode = token.getWrapPolicy() != null && token.getWrapPolicy() != Token.WrapPolicy.SUBSTITUTE_ONLY;
            if (!isFormattedCode && token.getAlign() == 0) {
                token.setAlign(token.getIndent());
                token.setIndent(0);
            }
        }
        boolean bl = canWrap = this.getNext() != null && this.getLineBreaksBefore() == 0 && index > 1 && positionIfNewLine < this.counter;
        if (canWrap) {
            if (token.getWrapPolicy() == null) {
                this.potentialWrapToken = token;
                this.counterIfWrapped = positionIfNewLine;
            } else if (token.getWrapPolicy() == Token.WrapPolicy.SUBSTITUTE_ONLY) {
                this.potentialWrapTokenSubstitute = token;
                this.counterIfWrappedSubstitute = positionIfNewLine;
            }
        }
        this.counter += this.tm.getLength(token, this.counter);
        this.counterIfWrapped += this.tm.getLength(token, this.counterIfWrapped);
        this.counterIfWrappedSubstitute += this.tm.getLength(token, this.counterIfWrappedSubstitute);
        if (this.shouldWrap()) {
            if (this.potentialWrapToken == null) {
                assert (this.potentialWrapTokenSubstitute != null);
                this.potentialWrapToken = this.potentialWrapTokenSubstitute;
                this.counterIfWrapped = this.counterIfWrappedSubstitute;
            }
            this.counter = this.counterIfWrapped;
            if (!this.simulation) {
                this.potentialWrapToken.breakBefore();
                this.potentialWrapToken.setAlign(this.potentialWrapToken.getIndent());
                this.potentialWrapToken.setIndent(0);
            }
            this.lineCounter = Math.max(this.lineCounter + 1, 4);
            this.potentialWrapTokenSubstitute = null;
            this.potentialWrapToken = null;
        }
        if (this.isSpaceAfter()) {
            ++this.counter;
            ++this.counterIfWrapped;
        }
        return true;
    }

    private boolean shouldWrap() {
        int lineLenght = this.options.comment_line_length;
        if (this.wrapDisabled || this.counter <= lineLenght) {
            return false;
        }
        if (this.potentialWrapToken != null && this.potentialWrapTokenSubstitute != null && this.counterIfWrapped > lineLenght && this.counterIfWrappedSubstitute < this.counterIfWrapped) {
            this.potentialWrapToken = null;
        }
        if (this.potentialWrapToken == null && this.potentialWrapTokenSubstitute == null) {
            boolean isFormattingEnabled;
            boolean bl = isFormattingEnabled = this.blockStructure.size() > 1 && this.blockStructure.get((int)1).tokenType == 0;
            if (isFormattingEnabled) {
                this.lineCounter = Math.max(this.lineCounter, 3);
            }
            return false;
        }
        if (this.options.comment_new_lines_at_javadoc_boundaries) {
            int openingTokenLength;
            if (this.getNext() == null) {
                this.lineCounter = Math.max(this.lineCounter, 3);
                return false;
            }
            if (this.lineCounter == 1 && this.counter - ((openingTokenLength = this.tm.getLength(this.blockStructure.get(0), 0)) - 2) <= lineLenght) {
                this.counter -= openingTokenLength - 2;
                this.lineCounter = Math.max(this.lineCounter, 3);
                return false;
            }
        }
        return true;
    }

    public void wrapLineComment(Token commentToken, int startPosition) {
        boolean formattingEnabled;
        List<Token> structure = commentToken.getInternalStructure();
        if (structure == null || structure.isEmpty()) {
            return;
        }
        int commentIndex = this.tm.indexOf(commentToken);
        boolean isHeader = this.tm.isInHeader(commentIndex);
        boolean bl = formattingEnabled = this.options.comment_format_line_comment && !isHeader || this.options.comment_format_header && isHeader;
        if (!formattingEnabled) {
            return;
        }
        int position = startPosition;
        int indent = startPosition = this.tm.toIndent(startPosition, true);
        for (Token token : structure) {
            if (!token.hasNLSTag()) continue;
            this.nlsTags.add(token);
            position += token.countChars() + (token.isSpaceBefore() ? 1 : 0);
        }
        Token whitespace = null;
        Token prefix = structure.get(0);
        if (prefix.tokenType == 1000) {
            whitespace = new Token(prefix);
            whitespace.breakBefore();
            whitespace.setIndent(indent);
            whitespace.setWrapPolicy(new Token.WrapPolicy(0, commentIndex, false));
            prefix = structure.get(1);
            assert (prefix.tokenType == 1001);
        }
        int prefixEnd = commentToken.originalStart + 1;
        if (!prefix.hasNLSTag()) {
            prefixEnd = Math.max(prefixEnd, prefix.originalEnd);
        }
        prefix = new Token(commentToken.originalStart, prefixEnd, 1001);
        if (whitespace == null) {
            prefix.breakBefore();
            prefix.setWrapPolicy(new Token.WrapPolicy(0, commentIndex, false));
        }
        int lineStartIndex = whitespace == null ? 0 : 1;
        int i = 0;
        while (i < structure.size()) {
            Token token = structure.get(i);
            token.setIndent(indent);
            if (token.hasNLSTag()) {
                this.nlsTags.remove(token);
            } else {
                if (token.isSpaceBefore()) {
                    ++position;
                }
                if (token.getLineBreaksBefore() > 0) {
                    position = startPosition;
                    int n = lineStartIndex = whitespace == null ? i : i + 1;
                    if (whitespace != null && token != whitespace) {
                        token.clearLineBreaksBefore();
                        structure.add(i, whitespace);
                        token = whitespace;
                    }
                }
                if ((position += this.tm.getLength(token, position)) > this.options.comment_line_length && i > lineStartIndex + 1) {
                    structure.add(i, prefix);
                    if (whitespace != null) {
                        structure.add(i, whitespace);
                    }
                    structure.removeAll(this.nlsTags);
                    structure.addAll(i, this.nlsTags);
                    i = i + this.nlsTags.size() - 1;
                    this.nlsTags.clear();
                }
            }
            ++i;
        }
        this.nlsTags.clear();
    }
}

