/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.text.internal;

import java.util.List;
import org.eclipse.fx.code.editor.configuration.Partition;
import org.eclipse.fx.code.editor.configuration.PartitionRule;
import org.eclipse.fx.code.editor.configuration.PartitionRule_MultiLine;
import org.eclipse.fx.code.editor.configuration.PartitionRule_SingleLine;
import org.eclipse.fx.code.editor.configuration.text.Util;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class ConfigurationRuleBasedPartitionScanner
extends RuleBasedPartitionScanner {
    public ConfigurationRuleBasedPartitionScanner(List<Partition> paritioner) {
        IPredicateRule[] pr = new IPredicateRule[paritioner.stream().mapToInt(p -> p.getRuleList().size()).sum()];
        int i = 0;
        for (Partition p2 : paritioner) {
            for (PartitionRule r : p2.getRuleList()) {
                String escapeSeq;
                String endSeq;
                if (r instanceof PartitionRule_SingleLine) {
                    PartitionRule_SingleLine sr = (PartitionRule_SingleLine)r;
                    endSeq = sr.getEndSeq();
                    escapeSeq = sr.getEscapedBy();
                    pr[i] = new SingleLineRule(sr.getStartSeq(), endSeq, (IToken)new Token((Object)p2.getName()), escapeSeq != null ? escapeSeq.charAt(0) : (char)'\u0000', endSeq == null || endSeq.isEmpty());
                } else if (r instanceof PartitionRule_MultiLine) {
                    PartitionRule_MultiLine mr = (PartitionRule_MultiLine)r;
                    endSeq = mr.getEndSeq();
                    escapeSeq = mr.getEscapedBy();
                    pr[i] = new MultiLineRule(mr.getStartSeq(), endSeq, (IToken)new Token((Object)p2.getName()), escapeSeq != null ? escapeSeq.charAt(0) : (char)'\u0000', endSeq == null || endSeq.isEmpty());
                }
                pr[i] = (IPredicateRule)Util.wrap(r.getCheck(), (IRule)pr[i]);
                ++i;
            }
        }
        this.setPredicateRules(pr);
    }
}

