/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.TextField;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryCellFactory;

public class EAttributeCellEditHandler
implements AdapterFactoryCellFactory.ICellEditHandler {
    EAttribute attribute;
    EditingDomain editingDomain;
    TextField textField;

    public EAttributeCellEditHandler(EAttribute attribute, EditingDomain editingDomain) {
        this.attribute = attribute;
        this.editingDomain = editingDomain;
    }

    @Override
    public boolean canEdit(Cell<?> cell) {
        Object item = cell.getItem();
        return item instanceof EObject && ((EObject)item).eClass().getEAllAttributes().contains((Object)this.attribute);
    }

    @Override
    public void startEdit(final Cell<?> cell) {
        EObject item = (EObject)cell.getItem();
        String string = EcoreUtil.convertToString((EDataType)this.attribute.getEAttributeType(), (Object)item.eGet((EStructuralFeature)this.attribute));
        this.textField = new TextField();
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    EAttributeCellEditHandler.this.commitEdit(cell, EAttributeCellEditHandler.this.textField.getText());
                }
            }
        });
        cell.setText(null);
        cell.setGraphic((Node)this.textField);
        this.textField.setText(string);
        this.textField.selectPositionCaret(0);
    }

    @Override
    public void cancelEdit(Cell<?> treeCell) {
    }

    @Override
    public void commitEdit(Cell<?> treeCell, Object newValue) {
        Object value;
        Object item = treeCell.getItem();
        Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)item, (Object)this.attribute, (Object)(value = EcoreUtil.createFromString((EDataType)this.attribute.getEAttributeType(), (String)((String)newValue))));
        if (command.canExecute()) {
            this.editingDomain.getCommandStack().execute(command);
        }
    }
}

