/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.adapter.AdapterProvider;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.fx.core.di.ContextBoundValue;

public class PropertyAdapterProvider
implements AdapterProvider<ContextBoundValue, Property> {
    public Class<ContextBoundValue> getSourceType() {
        return ContextBoundValue.class;
    }

    public Class<Property> getTargetType() {
        return Property.class;
    }

    public boolean canAdapt(ContextBoundValue sourceObject, Class<Property> targetType) {
        return true;
    }

    public Property adapt(final ContextBoundValue sourceObject, Class<Property> targetType, AdapterService.ValueAccess ... valueAccess) {
        final SimpleObjectProperty rv = new SimpleObjectProperty(sourceObject.getValue());
        final InvalidationListener l = new InvalidationListener(){

            public void invalidated(Observable observable) {
                sourceObject.publish(rv.get());
            }
        };
        rv.addListener(l);
        sourceObject.subscribeOnValueChange(new Callback(){

            public void call(Object value) {
                if (rv.get() == null && value == null) {
                    return;
                }
                if (rv.get() != null && rv.get().equals(value)) {
                    return;
                }
                rv.set(value);
            }
        });
        sourceObject.subscribeOnDispose(new Callback(){

            public void call(Object value) {
                rv.removeListener(l);
            }
        });
        return rv;
    }
}

