/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface ReturnValue<V> {
    public @NonNull State getState();

    public @Nullable String getMessage();

    public @Nullable V getValue();

    public @Nullable Throwable getThrowable();

    public static <V> @NonNull ReturnValue<V> ok(@Nullable V value) {
        return new ReturnValueImpl<V>(State.OK, null, value, null);
    }

    public static <V> @NonNull ReturnValue<V> error(@NonNull String message, @NonNull Throwable error) {
        return new ReturnValueImpl<Object>(State.ERROR, message, null, error);
    }

    @Deprecated
    public static class ReturnValueImpl<V>
    implements ReturnValue<V> {
        public final @NonNull State state;
        public final @Nullable String message;
        public final @Nullable Throwable throwable;
        public final @Nullable V value;

        public ReturnValueImpl(@NonNull State state, @Nullable String message, @Nullable V value, @Nullable Throwable throwable) {
            this.state = state;
            this.message = message;
            this.throwable = throwable;
            this.value = value;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public State getState() {
            return this.state;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }

    public static enum State {
        ERROR,
        WARNING,
        CANCEL,
        OK;

    }
}

