/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javafx.scene.image.Image;

public class ImageCache {
    private static final ImageCache INSTANCE = new ImageCache();
    Map<String, CachedImage> cache = new HashMap<String, CachedImage>();
    List<CachedImage> lazyCleanup = new ArrayList<CachedImage>();
    static long MIN_LZAY_TIME = 10000L;

    public ImageCache() {
        TimerTask t = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long time = System.currentTimeMillis();
                ImageCache imageCache = ImageCache.this;
                synchronized (imageCache) {
                    if (!ImageCache.this.lazyCleanup.isEmpty()) {
                        ImageCache.this.lazyCleanup.removeIf(e -> e.count > 0);
                        ImageCache.this.lazyCleanup.stream().filter(e -> e.releaseTime + MIN_LZAY_TIME < time).map(e -> e.url).forEach(e -> ImageCache.this.cache.remove(e));
                        ImageCache.this.lazyCleanup.removeIf(e -> e.releaseTime + MIN_LZAY_TIME < time);
                    }
                }
            }
        };
        Timer tt = new Timer(true);
        tt.scheduleAtFixedRate(t, 0L, 5000L);
    }

    public static ImageCache getInstance() {
        return INSTANCE;
    }

    public synchronized CachedImage getImage(String url) {
        CachedImage img = this.cache.get(url);
        if (img == null) {
            img = new CachedImage(this, url);
            this.cache.put(url, img);
        }
        ++img.count;
        return img;
    }

    public static class CachedImage
    extends Image {
        private final ImageCache cache;
        final String url;
        int count;
        long releaseTime;

        CachedImage(ImageCache cache, String url) {
            super(url);
            this.url = url;
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            ImageCache imageCache = this.cache;
            synchronized (imageCache) {
                --this.count;
                if (this.count <= 0) {
                    this.cache.cache.remove(this.url);
                    this.cache.lazyCleanup.remove((Object)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLazy() {
            ImageCache imageCache = this.cache;
            synchronized (imageCache) {
                --this.count;
                if (this.count <= 0) {
                    this.releaseTime = System.currentTimeMillis();
                    this.cache.lazyCleanup.add(this);
                }
            }
        }
    }
}

