/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext_ng.internal;

import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.eclipse.fx.core.Range;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.geom.Size;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext_ng.StyledLineRenderer;

public abstract class BaseStyledLineRenderer
implements StyledLineRenderer {
    char[] originalText = new char[0];
    char[] displayedText = new char[0];
    char[] tabReplace = new char[4];
    Font normal;
    Font bold;
    Font italic;
    Font boldItalic;
    double w;
    double h;
    private RangeSet<Integer> boldRange = TreeRangeSet.create();
    private RangeSet<Integer> italicRange = TreeRangeSet.create();
    private List<PaintRange> paintRanges = new ArrayList<PaintRange>();
    int flag = 0;
    boolean combinedAction;
    static final int FONTS = 1;
    static final int FILL = 2;
    static final int TEXT = 4;

    public BaseStyledLineRenderer() {
        Arrays.fill(this.tabReplace, ' ');
    }

    protected RangeSet<Integer> getNormalRange() {
        TreeRangeSet set = TreeRangeSet.create();
        set.add(com.google.common.collect.Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.originalText.length)));
        set.removeAll(this.boldRange);
        set.removeAll(this.italicRange);
        return set;
    }

    protected RangeSet<Integer> getBoldRange() {
        if (this.italicRange.isEmpty()) {
            return this.boldRange;
        }
        TreeRangeSet onlyBold = TreeRangeSet.create(this.boldRange);
        onlyBold.removeAll(this.italicRange);
        return onlyBold;
    }

    protected RangeSet<Integer> getItalicRange() {
        if (this.boldRange.isEmpty()) {
            return this.italicRange;
        }
        TreeRangeSet onlyItalic = TreeRangeSet.create(this.italicRange);
        onlyItalic.removeAll(this.boldRange);
        return onlyItalic;
    }

    protected RangeSet<Integer> getBoldItalicRange() {
        if (this.italicRange.isEmpty() && this.boldRange.isEmpty()) {
            TreeRangeSet italicBoldRange = TreeRangeSet.create(this.boldRange);
            italicBoldRange.removeAll(this.italicRange.complement());
            return italicBoldRange;
        }
        return TreeRangeSet.create();
    }

    protected List<PaintRange> getPaintRanges() {
        return this.paintRanges;
    }

    @Override
    public void setFont(String family, double size) {
        this.normal = Font.font((String)family, (double)size);
        this.bold = Font.font((String)family, (FontWeight)FontWeight.BOLD, (double)size);
        this.italic = Font.font((String)family, (FontPosture)FontPosture.ITALIC, (double)size);
        this.boldItalic = Font.font((String)family, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.ITALIC, (double)size);
        Size dim = Util.getSize(this.normal, 'A');
        this.w = dim.width;
        this.h = dim.height;
        this.rebuildFonts();
    }

    @Override
    public Subscription setBold(Range r) {
        com.google.common.collect.Range range = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(r.start), (Comparable)Integer.valueOf(r.end - 1));
        this.boldRange.add(range);
        this.rebuildFonts();
        return () -> {
            this.boldRange.remove(range);
            this.rebuildFonts();
        };
    }

    @Override
    public Subscription setItalic(Range r) {
        com.google.common.collect.Range range = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(r.start), (Comparable)Integer.valueOf(r.end - 1));
        this.italicRange.add(range);
        this.rebuildFonts();
        return () -> {
            this.italicRange.remove(range);
            this.rebuildFonts();
        };
    }

    @Override
    public Subscription setForeground(Paint paint, Range r) {
        com.google.common.collect.Range closed = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(r.start), (Comparable)Integer.valueOf(r.end - 1));
        PaintRange range = new PaintRange(paint, (com.google.common.collect.Range<Integer>)closed);
        this.paintRanges.add(range);
        this.rebuildFill();
        return () -> {
            this.paintRanges.remove(range);
            this.rebuildFill();
        };
    }

    @Override
    public void setText(char[] text) {
        this.originalText = text;
        this.displayedText = TextUtil.replaceAll((char[])this.originalText, (char)'\t', (char[])this.tabReplace);
        this.rebuildText();
    }

    @Override
    public void combinedAction(Runnable r) {
        this.combinedAction = true;
        try {
            r.run();
        }
        finally {
            this.combinedAction = false;
        }
        if ((this.flag & 1) == 1) {
            this.rebuildFonts();
        }
        if ((this.flag & 2) == 2) {
            this.rebuildFill();
        }
        if ((this.flag & 4) == 4) {
            this.rebuildText();
        }
    }

    protected abstract void rebuildFill();

    protected abstract void rebuildFonts();

    protected abstract void rebuildText();

    static class PaintRange {
        Paint paint;
        final com.google.common.collect.Range<Integer> range;

        public PaintRange(Paint paint, com.google.common.collect.Range<Integer> range) {
            this.paint = paint;
            this.range = range;
        }
    }
}

