/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.command;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;

public interface Command<T> {
    public ReadOnlyBooleanProperty enabledProperty();

    public boolean isEnabled();

    public Optional<T> execute();

    public ObservableMap<String, String> parameters();

    public void evaluate();

    public static <T> Command<T> createCommand(Supplier<T> action) {
        return Command.createCommand((Map<String, String> m) -> action.get());
    }

    public static Command<Void> createCommand(Runnable action) {
        return Command.createCommand((Map<String, String> m) -> {
            action.run();
            return null;
        });
    }

    public static Command<Void> createCommand(Consumer<Map<String, String>> action) {
        return Command.createCommand((Map<String, String> m) -> {
            action.accept((Map<String, String>)m);
            return null;
        });
    }

    public static <T> Command<T> createCommand(final Function<Map<String, String>, T> action) {
        return new Command<T>(){
            private ReadOnlyBooleanWrapper enabled = new ReadOnlyBooleanWrapper((Object)this, "enabled", true);
            private ObservableMap<String, String> parameters = FXCollections.observableMap(new HashMap());

            @Override
            public ObservableMap<String, String> parameters() {
                return this.parameters;
            }

            @Override
            public void evaluate() {
            }

            @Override
            public ReadOnlyBooleanProperty enabledProperty() {
                return this.enabled.getReadOnlyProperty();
            }

            @Override
            public boolean isEnabled() {
                return this.enabled.get();
            }

            @Override
            public Optional<T> execute() {
                return Optional.ofNullable(action.apply(new HashMap<String, String>((Map<String, String>)this.parameters)));
            }
        };
    }

    public static <T> Command<T> createCommand(final Function<Map<String, String>, T> action, final Predicate<Map<String, String>> enabledCalculator) {
        return new Command<T>(){
            private ReadOnlyBooleanWrapper enabled = new ReadOnlyBooleanWrapper((Object)this, "enabled", true);
            private ObservableMap<String, String> parameters = FXCollections.observableMap(new HashMap());
            {
                this.parameters.addListener(change -> this.evaluate());
                this.evaluate();
            }

            @Override
            public void evaluate() {
                this.enabled.set(enabledCalculator.test(this.parameters));
            }

            @Override
            public ObservableMap<String, String> parameters() {
                return this.parameters;
            }

            @Override
            public ReadOnlyBooleanProperty enabledProperty() {
                return this.enabled.getReadOnlyProperty();
            }

            @Override
            public boolean isEnabled() {
                return this.enabled.get();
            }

            @Override
            public Optional<T> execute() {
                return Optional.ofNullable(action.apply(new HashMap<String, String>((Map<String, String>)this.parameters)));
            }
        };
    }

    public static class ParameterValue {
        public final String name;
        public final String value;

        public ParameterValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

