/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.fxml;

import javafx.scene.image.Image;
import javafx.util.Builder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImageBuilder
implements Builder<Image> {
    private String url = "";
    private double requestedWidth = 0.0;
    private double requestedHeight = 0.0;
    private boolean preserveRatio = false;
    private boolean smooth = false;
    private boolean backgroundLoading = false;

    public static @NonNull ImageBuilder create() {
        return new ImageBuilder();
    }

    public @NonNull ImageBuilder url(@Nullable String url) {
        this.url = url;
        return this;
    }

    public @NonNull ImageBuilder requestedWidth(double requestedWidth) {
        this.requestedWidth = requestedWidth;
        return this;
    }

    public @NonNull ImageBuilder requestedHeight(double requestedHeight) {
        this.requestedHeight = requestedHeight;
        return this;
    }

    public @NonNull ImageBuilder preserveRatio(boolean preserveRatio) {
        this.preserveRatio = preserveRatio;
        return this;
    }

    public @NonNull ImageBuilder smooth(boolean smooth) {
        this.smooth = smooth;
        return this;
    }

    public @NonNull ImageBuilder backgroundLoading(boolean backgroundLoading) {
        this.backgroundLoading = backgroundLoading;
        return this;
    }

    public @NonNull Image build() {
        return new Image(this.url, this.requestedWidth, this.requestedHeight, this.preserveRatio, this.smooth, this.backgroundLoading);
    }
}

