/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Line;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.fx.FXToSvgUtils;
import org.eclipse.fx.formats.svg.fx.PresentationAttributesUtil;
import org.eclipse.fx.formats.svg.svg.SvgClipPathElement;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgGElement;
import org.eclipse.fx.formats.svg.svg.SvgImageElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FXToSvg {
    private SvgSvgElement root;
    private SvgDefsElement defs;
    private Scene s;
    private Parent p;
    @Extension
    private PresentationAttributesUtil e = new PresentationAttributesUtil(new Supplier<SvgDefsElement>(){

        @Override
        public SvgDefsElement get() {
            return FXToSvg.this.getDefs();
        }
    });

    public FXToSvg(Scene s) {
        this.s = s;
    }

    public FXToSvg(Parent p) {
        this.p = p;
    }

    public SvgDefsElement getDefs() {
        boolean _equals = Objects.equal((Object)this.defs, null);
        if (_equals) {
            this.defs = SvgFactory.eINSTANCE.createSvgDefsElement();
            this.root.getChildren().add(0, (Object)this.defs);
        }
        return this.defs;
    }

    public SvgSvgElement getSvgRoot() {
        boolean _equals = Objects.equal((Object)this.root, null);
        if (_equals) {
            boolean _notEquals;
            this.root = SvgFactory.eINSTANCE.createSvgSvgElement();
            boolean bl = _notEquals = !Objects.equal((Object)this.s, null);
            if (_notEquals) {
                boolean _notEquals_1;
                this.root.setWidth(Double.valueOf(this.s.getWidth()).toString());
                this.root.setHeight(Double.valueOf(this.s.getHeight()).toString());
                Paint _fill = this.s.getFill();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_fill, null);
                if (_notEquals_1) {
                    this.e.applyFill(this.root, this.s.getFill());
                }
                EList _children = this.root.getChildren();
                SvgElement _transform = this.transform((Node)this.s.getRoot());
                _children.add((Object)_transform);
            } else {
                this.root = SvgFactory.eINSTANCE.createSvgSvgElement();
                this.root.setWidth(Double.valueOf(this.p.getLayoutBounds().getWidth()).toString());
                this.root.setHeight(Double.valueOf(this.p.getLayoutBounds().getHeight()).toString());
                SvgElement _transform_1 = this.transform((Node)this.p);
                SvgGElement rr = (SvgGElement)_transform_1;
                rr.setTransform(null);
                EList _children_1 = this.root.getChildren();
                _children_1.add((Object)rr);
            }
        }
        return this.root;
    }

    protected SvgElement _transform(final Region r) {
        boolean _notEquals_5;
        boolean _notEquals;
        SvgGElement e = SvgFactory.eINSTANCE.createSvgGElement();
        e.setVisibility(FXToSvgUtils.toVisibility(r.isVisible()));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("translate(");
        double _minX = r.getBoundsInParent().getMinX();
        _builder.append((Object)_minX);
        _builder.append(",");
        double _minY = r.getBoundsInParent().getMinY();
        _builder.append((Object)_minY);
        _builder.append(")");
        e.setTransform(_builder.toString());
        Shape _shape = r.getShape();
        boolean bl = _notEquals = !Objects.equal((Object)_shape, null);
        if (_notEquals) {
            Border _border;
            boolean _notEquals_2;
            boolean _notEquals_1;
            SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
            cp.setId(EcoreUtil.generateUUID());
            EList _children = cp.getChildren();
            SvgElement _transform = this.transform((Node)r.getShape());
            _children.add((Object)_transform);
            EList _children_1 = this.getDefs().getChildren();
            _children_1.add((Object)cp);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("url(#");
            String _id = cp.getId();
            _builder_1.append(_id);
            _builder_1.append(")");
            e.setClip_path(_builder_1.toString());
            Background _background = r.getBackground();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_background, null);
            if (_notEquals_1) {
                EList _children_2 = e.getChildren();
                Functions.Function1<BackgroundFill, SvgElement> _function = new Functions.Function1<BackgroundFill, SvgElement>(){

                    public SvgElement apply(BackgroundFill it) {
                        return FXToSvg.this.e.createBackgroundFill(it, r);
                    }
                };
                List _list = IterableExtensions.toList((Iterable)ListExtensions.map((List)r.getBackground().getFills(), (Functions.Function1)_function));
                Iterables.addAll((Collection)_children_2, (Iterable)_list);
            }
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)(_border = r.getBorder()), null);
            if (_notEquals_2) {
                EList _children_3 = e.getChildren();
                List<SvgElement> _createBorder = this.e.createBorder(r.getBorder(), r);
                Iterables.addAll((Collection)_children_3, _createBorder);
            }
        } else {
            Border _border_1;
            boolean _notEquals_4;
            boolean _notEquals_3;
            Background _background_1 = r.getBackground();
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)_background_1, null);
            if (_notEquals_3) {
                EList _children_4 = e.getChildren();
                Functions.Function1<BackgroundFill, SvgElement> _function_1 = new Functions.Function1<BackgroundFill, SvgElement>(){

                    public SvgElement apply(BackgroundFill it) {
                        return FXToSvg.this.e.createBackgroundFill(it, r);
                    }
                };
                List _list_1 = IterableExtensions.toList((Iterable)ListExtensions.map((List)r.getBackground().getFills(), (Functions.Function1)_function_1));
                Iterables.addAll((Collection)_children_4, (Iterable)_list_1);
            }
            boolean bl5 = _notEquals_4 = !Objects.equal((Object)(_border_1 = r.getBorder()), null);
            if (_notEquals_4) {
                EList _children_5 = e.getChildren();
                List<SvgElement> _createBorder_1 = this.e.createBorder(r.getBorder(), r);
                Iterables.addAll((Collection)_children_5, _createBorder_1);
            }
        }
        EList _children_6 = e.getChildren();
        Functions.Function1<Node, Boolean> _function_2 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return it.isVisible();
            }
        };
        Functions.Function1<Node, SvgElement> _function_3 = new Functions.Function1<Node, SvgElement>(){

            public SvgElement apply(Node it) {
                return FXToSvg.this.transform(it);
            }
        };
        List _list_2 = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)r.getChildrenUnmodifiable(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        Iterables.addAll((Collection)_children_6, (Iterable)_list_2);
        Node _clip = r.getClip();
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)_clip, null);
        if (_notEquals_5) {
            Node _clip_1 = r.getClip();
            String _plus = "Region-Clip " + _clip_1;
            InputOutput.println((Object)_plus);
            SvgClipPathElement cp_1 = SvgFactory.eINSTANCE.createSvgClipPathElement();
            cp_1.setId(EcoreUtil.generateUUID());
            EList _children_7 = cp_1.getChildren();
            SvgElement _transform_1 = this.transform(r.getClip());
            _children_7.add((Object)_transform_1);
            EList _children_8 = this.getDefs().getChildren();
            _children_8.add((Object)cp_1);
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("url(#");
            String _id_1 = cp_1.getId();
            _builder_2.append(_id_1);
            _builder_2.append(")");
            e.setClip_path(_builder_2.toString());
        }
        return e;
    }

    protected SvgElement _transform(Group g) {
        boolean _notEquals;
        SvgGElement e = SvgFactory.eINSTANCE.createSvgGElement();
        e.setVisibility(FXToSvgUtils.toVisibility(g.isVisible()));
        EList _children = e.getChildren();
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return it.isVisible();
            }
        };
        Functions.Function1<Node, SvgElement> _function_1 = new Functions.Function1<Node, SvgElement>(){

            public SvgElement apply(Node it) {
                return FXToSvg.this.transform(it);
            }
        };
        List _list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)g.getChildrenUnmodifiable(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Iterables.addAll((Collection)_children, (Iterable)_list);
        Node _clip = g.getClip();
        boolean bl = _notEquals = !Objects.equal((Object)_clip, null);
        if (_notEquals) {
            Node _clip_1 = g.getClip();
            String _plus = "Group-CLIP: " + _clip_1;
            InputOutput.println((Object)_plus);
            SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
            cp.setId(EcoreUtil.generateUUID());
            EList _children_1 = cp.getChildren();
            SvgElement _transform = this.transform(g.getClip());
            _children_1.add((Object)_transform);
            EList _children_2 = this.getDefs().getChildren();
            _children_2.add((Object)cp);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("url(#");
            String _id = cp.getId();
            _builder.append(_id);
            _builder.append(")");
            e.setClip_path(_builder.toString());
        }
        return e;
    }

    protected SvgElement _transform(ImageView v) {
        SvgImageElement e = SvgFactory.eINSTANCE.createSvgImageElement();
        e.setVisibility(FXToSvgUtils.toVisibility(v.isVisible()));
        return e;
    }

    protected SvgElement _transform(Arc a) {
        SvgPathElement e = FXToSvgUtils.createPath((Shape)a);
        e.setVisibility(FXToSvgUtils.toVisibility(a.isVisible()));
        this.e.applyFill(e, a.getFill());
        return e;
    }

    protected SvgElement _transform(Circle c) {
        InputOutput.print((Object)"Circle arc");
        return null;
    }

    protected SvgElement _transform(Ellipse e) {
        InputOutput.print((Object)"Ellipse arc");
        return null;
    }

    protected SvgElement _transform(Line e) {
        InputOutput.print((Object)"Line arc");
        return null;
    }

    protected SvgElement _transform(Path p) {
        boolean _notEquals;
        SvgPathElement e = FXToSvgUtils.createPath((Shape)p);
        e.setVisibility(FXToSvgUtils.toVisibility(p.isVisible()));
        this.e.applyFill(e, p.getFill());
        Node _clip = p.getClip();
        boolean bl = _notEquals = !Objects.equal((Object)_clip, null);
        if (_notEquals) {
            Node _clip_1 = p.getClip();
            String _plus = "PATH_CLIP:" + _clip_1;
            InputOutput.println((Object)_plus);
            SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
            cp.setId(EcoreUtil.generateUUID());
            EList _children = cp.getChildren();
            SvgElement _transform = this.transform(p.getClip());
            _children.add((Object)_transform);
            EList _children_1 = this.getDefs().getChildren();
            _children_1.add((Object)cp);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("url(#");
            String _id = cp.getId();
            _builder.append(_id);
            _builder.append(")");
            e.setClip_path(_builder.toString());
        }
        return e;
    }

    protected SvgElement _transform(Polygon e) {
        InputOutput.print((Object)"Polygon arc");
        return null;
    }

    protected SvgElement _transform(Polyline e) {
        InputOutput.print((Object)"Polyline arc");
        return null;
    }

    protected SvgElement _transform(QuadCurve e) {
        InputOutput.print((Object)"QuadCurve arc");
        return null;
    }

    protected SvgElement _transform(Rectangle e) {
        SvgRectElement r = SvgFactory.eINSTANCE.createSvgRectElement();
        r.setX(Double.valueOf(e.getX()).toString());
        r.setY(Double.valueOf(e.getY()).toString());
        r.setWidth(Double.valueOf(e.getWidth()).toString());
        r.setHeight(Double.valueOf(e.getHeight()).toString());
        r.setVisibility(FXToSvgUtils.toVisibility(e.isVisible()));
        this.e.applyFill(r, e.getFill());
        return r;
    }

    protected SvgElement _transform(SVGPath e) {
        SvgPathElement p = SvgFactory.eINSTANCE.createSvgPathElement();
        p.setD(e.getContent());
        return p;
    }

    protected SvgElement _transform(Text e) {
        SvgPathElement p = FXToSvgUtils.createPath((Shape)e);
        p.setVisibility(FXToSvgUtils.toVisibility(e.isVisible()));
        this.e.applyFill(p, e.getFill());
        SvgGElement g = SvgFactory.eINSTANCE.createSvgGElement();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("translate(");
        double _minX = e.getBoundsInParent().getMinX();
        _builder.append((Object)_minX);
        _builder.append(",");
        double _minY = e.getBoundsInParent().getMinY();
        double _baselineOffset = e.getBaselineOffset();
        double _plus = _minY + _baselineOffset;
        _builder.append((Object)_plus);
        _builder.append(")");
        g.setTransform(_builder.toString());
        EList _children = g.getChildren();
        _children.add((Object)p);
        return g;
    }

    public SvgElement transform(Node g) {
        if (g instanceof Group) {
            return this._transform((Group)g);
        }
        if (g instanceof Region) {
            return this._transform((Region)g);
        }
        if (g instanceof Arc) {
            return this._transform((Arc)g);
        }
        if (g instanceof Circle) {
            return this._transform((Circle)g);
        }
        if (g instanceof Ellipse) {
            return this._transform((Ellipse)g);
        }
        if (g instanceof Line) {
            return this._transform((Line)g);
        }
        if (g instanceof Path) {
            return this._transform((Path)g);
        }
        if (g instanceof Polygon) {
            return this._transform((Polygon)g);
        }
        if (g instanceof Polyline) {
            return this._transform((Polyline)g);
        }
        if (g instanceof QuadCurve) {
            return this._transform((QuadCurve)g);
        }
        if (g instanceof Rectangle) {
            return this._transform((Rectangle)g);
        }
        if (g instanceof SVGPath) {
            return this._transform((SVGPath)g);
        }
        if (g instanceof Text) {
            return this._transform((Text)g);
        }
        if (g instanceof ImageView) {
            return this._transform((ImageView)g);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(g).toString());
    }
}

