/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.eclipse.fx.drift.DriftFXConfig;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;

public class NativeUtil {
    private static final DriftLogger LOGGER = DriftFX.createLogger(NativeUtil.class);
    private static String OS = System.getProperty("os.name");
    private static boolean isWindows = NativeUtil.getOsName().toLowerCase().contains("windows");
    private static boolean isLinux = NativeUtil.getOsName().toLowerCase().contains("linux");
    private static boolean isMacOs = NativeUtil.getOsName().toLowerCase().contains("mac") || NativeUtil.getOsName().toLowerCase().contains("darwin");
    static boolean osgi = false;

    private NativeUtil() {
    }

    public static void useOsgiEnvironment() {
        osgi = true;
    }

    public static String getOsName() {
        return OS;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isMacOs() {
        return isMacOs;
    }

    public static void loadLibrary(Class<?> context, String libname, Consumer<String> loadLibrary, Consumer<String> load) {
        if (DriftFXConfig.isUseJavaLibraryPath() || osgi) {
            LOGGER.info(() -> "loading " + libname + " via system call");
            loadLibrary.accept(libname);
        } else {
            try {
                String filename = NativeUtil.getFilename(libname);
                Path tmpDir = Files.createTempDirectory("driftfx", new FileAttribute[0]);
                Path extractPath = tmpDir.resolve(filename);
                String resourceName = "/native/" + filename;
                URL url = context.getResource(resourceName);
                LOGGER.debug(() -> "Resource Lookup: name: " + resourceName + ", context: " + context + " => " + url);
                try (InputStream in = context.getResourceAsStream("/native/" + filename);){
                    NativeUtil.extract(in, extractPath);
                }
                LOGGER.info(() -> "loading " + libname + " from extracted location (" + extractPath + ")");
                load.accept(extractPath.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static Path extract(InputStream in, Path extractPath) throws IOException {
        long bytes;
        Files.createDirectories(extractPath.getParent(), new FileAttribute[0]);
        if (!Files.exists(extractPath, new LinkOption[0]) && (bytes = Files.copy(in, extractPath, new CopyOption[0])) == 0L) {
            throw new IOException("library has no size!");
        }
        return extractPath;
    }

    private static String getFilename(String libname) {
        if (NativeUtil.isWindows()) {
            return libname + ".dll";
        }
        if (NativeUtil.isLinux()) {
            return "lib" + libname + ".so";
        }
        if (NativeUtil.isMacOs()) {
            return "lib" + libname + ".dylib";
        }
        throw new RuntimeException("os not supported: " + NativeUtil.getOsName());
    }
}

