/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.details;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.log.viewer.views.details.TreeObject;

public class TreeParent
extends TreeObject {
    private final List<TreeObject> children = new ArrayList<TreeObject>();

    public TreeParent(String name) {
        super(name);
    }

    public void addChild(TreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(TreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public TreeObject[] getChildren() {
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public TreeObject getChild(String name) {
        for (TreeObject child : this.children) {
            if (!child.getName().trim().equals(name)) continue;
            return child;
        }
        return null;
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append("\n").append("[");
        for (TreeObject obj : this.children) {
            builder.append(obj.toString()).append("\n");
        }
        builder.append("]\n");
        return builder.toString();
    }
}

