/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.titan.log.viewer.search.LogSearchResult;
import org.eclipse.titan.log.viewer.views.LogSearchResultPage;

public class TreeContentProvider
implements ITreeContentProvider {
    private LogSearchResult result;
    private LogSearchResultPage page;
    private SearchResultListener searchResultListener;
    private Map<IResource, List<IResource>> tree = new HashMap<IResource, List<IResource>>();

    public TreeContentProvider(LogSearchResultPage page) {
        this.searchResultListener = new SearchResultListener();
        if (page != null && page.getInput() != null) {
            this.page = page;
            this.setResult((LogSearchResult)page.getInput());
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.tree = new HashMap<IResource, List<IResource>>();
        if (newInput instanceof LogSearchResult) {
            this.setResult((LogSearchResult)((Object)newInput));
        }
        if (newInput instanceof LogSearchResultPage) {
            this.page = (LogSearchResultPage)((Object)newInput);
        }
    }

    protected void setResult(LogSearchResult result) {
        this.tree = new HashMap<IResource, List<IResource>>();
        this.result = result;
        for (Object child : result.getElements()) {
            Object parent = this.getParent(child);
            while (parent != null && this.addTreeElement((IResource)parent, (IResource)child)) {
                child = parent;
                parent = this.getParent(parent);
            }
        }
        result.addListener(this.searchResultListener);
    }

    protected LogSearchResultPage getPage() {
        return this.page;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public List<IProject> getProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IResource resource : this.tree.keySet()) {
            if (!(resource instanceof IProject)) continue;
            result.add((IProject)resource);
        }
        return result;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LogSearchResult) {
            return this.getProjects().toArray();
        }
        if (parentElement instanceof IFile) {
            return this.result.getMatches(parentElement);
        }
        if (parentElement instanceof IResource) {
            List<IResource> result = this.tree.get(parentElement);
            return result == null ? new Object[]{} : result.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof Match) {
            ((Match)element).getElement();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IFile) {
            return this.result.getMatchCount(element) > 0;
        }
        return this.tree.get(element) != null;
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        this.getPage().getViewer().refresh();
    }

    public void removeAll() {
        this.result.removeAll();
    }

    private boolean addTreeElement(IResource parent, IResource child) {
        List<IResource> children = this.tree.get(parent);
        if (children == null) {
            children = new ArrayList<IResource>();
            children.add(child);
            this.tree.put(parent, children);
            return true;
        }
        if (!children.contains(child)) {
            children.add(child);
            return true;
        }
        return false;
    }

    private class SearchResultListener
    implements ISearchResultListener {
        private SearchResultListener() {
        }

        public void searchResultChanged(SearchResultEvent e) {
            if (e instanceof MatchEvent) {
                MatchEvent event = (MatchEvent)e;
                if (event.getKind() == 1) {
                    this.addMatch(event);
                }
                if (event.getKind() == 2) {
                    this.removeMatch(event);
                }
                return;
            }
            if (e instanceof RemoveAllEvent) {
                TreeContentProvider.this.tree.clear();
            }
        }

        private boolean removeMatch(MatchEvent event) {
            block0: for (Match match : event.getMatches()) {
                Object child = match.getElement();
                if (TreeContentProvider.this.getChildren(child).length != 0) {
                    return true;
                }
                Object parent = TreeContentProvider.this.getParent(child);
                while (parent != null) {
                    List children = (List)TreeContentProvider.this.tree.get(parent);
                    if (children != null) {
                        children.remove(child);
                        if (!children.isEmpty()) continue block0;
                    }
                    TreeContentProvider.this.tree.remove(parent);
                    child = TreeContentProvider.this.getParent(child);
                    parent = TreeContentProvider.this.getParent(parent);
                }
            }
            return false;
        }

        private void addMatch(MatchEvent event) {
            for (Match match : event.getMatches()) {
                Object child = match.getElement();
                Object parent = TreeContentProvider.this.getParent(child);
                while (parent != null && TreeContentProvider.this.addTreeElement((IResource)parent, (IResource)child)) {
                    child = parent;
                    parent = TreeContentProvider.this.getParent(parent);
                }
            }
        }
    }
}

