/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers;

import java.util.regex.Pattern;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyser;

public class MessageAnalyserFormat1
extends MessageAnalyser {
    protected static final String COMPONENT_DONE_VERDICT = "verdict of PTC with component reference";
    private static final String PTC_WAS_CREATED_COMPONENT_REFERENCE_ONLY = "PTC was created. Component reference: [0-9]+\\.";

    @Override
    public String getType() {
        return "MessageAnalyserFormat1";
    }

    @Override
    protected boolean isComponentCreation() {
        String regexpComponent = "PTC was created. Component reference: [0-9]+\\,.*";
        if (Pattern.matches(regexpComponent, this.message)) {
            return true;
        }
        regexpComponent = PTC_WAS_CREATED_COMPONENT_REFERENCE_ONLY;
        if (Pattern.matches(regexpComponent, this.message)) {
            return true;
        }
        regexpComponent = "TTCN-3 Parallel Test Component started on .*";
        return Pattern.matches(regexpComponent, this.message);
    }

    @Override
    protected String getComponentTerminationReference() {
        return this.getTokenAfterString("component reference", " :");
    }

    @Override
    protected boolean isComponentTermination() {
        return this.message.contains(COMPONENT_DONE_VERDICT);
    }

    @Override
    public boolean isReceiveOperation() {
        return false;
    }

    @Override
    public String getReceiveOperationTarget() {
        return "";
    }

    @Override
    public String getReceiveOperationType() {
        return "";
    }

    @Override
    protected String getComponentCreationReference() {
        return this.getComponentRef(this.getTokenAfterString("Component reference:"));
    }

    @Override
    protected String getComponentDoneReference() {
        return this.getComponentRef(this.getTokenAfterString("PTC with component reference"));
    }

    @Override
    public String getPortConnectionSource() {
        return this.getTokenAfterString("Connecting ports");
    }

    @Override
    public boolean isPortDisconnection() {
        return false;
    }

    @Override
    public String getPortConnectionSourceRef() {
        return this.getTokenAfterString("Connecting ports").split(":")[0];
    }

    @Override
    public String getPortDisconnectionSourceRef() {
        return this.getTokenAfterString("Disconnecting ports").split(":")[0];
    }

    @Override
    public String getPortDisconnectionSource() {
        return this.getTokenAfterString("Disconnecting ports");
    }

    @Override
    public String getPortConnectionTarget() {
        return this.getTokenAfterString(" and ");
    }

    @Override
    public String getPortConnectionTargetRef() {
        return this.getTokenAfterString(" and ").split(":")[0];
    }

    @Override
    public String getStartFunctionReference() {
        return this.getComponentRef(this.getTokenAfterString("on component"));
    }

    @Override
    public String getPortUnMapping() {
        return this.getTokenAfterString("Unmapping port", ":").trim();
    }

    @Override
    public String getPortMappingTarget() {
        return this.getTokenAfterString(" to ");
    }

    @Override
    public String getPortUnMappingTarget() {
        return this.getTokenAfterString(" from ");
    }

    @Override
    public String getPortMappingSource() {
        return this.getTokenAfterString("Mapping port");
    }
}

