/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers;

import java.util.List;
import java.util.StringTokenizer;

public abstract class MessageAnalyser {
    protected static final String IS_DONE = "is done.";
    protected static final String DISCONNECTING_PORTS = "Disconnecting ports";
    private static final String CONNECTION_TERMINATION_REQUEST_WAS_RECEIVED_ON_PORT = "Connection termination request was received on port";
    private static final String DISCONNECT_OPERATION_ON = "Disconnect operation on";
    private static final String CONNECT_OPERATION_ON = "Connect operation on";
    private static final String MESSAGE_ENQUEUED_ON = "enqueued on";
    protected String message;
    private static final String MAP_OPERATION_OF = "Map operation of";
    private static final String UNMAP_OPERATION_OF = "Unmap operation of";
    protected static final String TTCN_3_PARALLEL_TEST_COMPONENT_STARTED_ON = "TTCN-3 Parallel Test Component started on .*";
    protected static final String LOCAL_VERDICT_OF_MTC = "Local verdict of MTC:";
    protected static final String PTC_WAS_CREATED_COMPONENT_REFERENCE_WITH_COMPONENT_NAME = "PTC was created. Component reference: [0-9]+\\,.*";
    private static final String SEND_VALUE = " to \\S++ \\S++ ";
    private static final String SEND_TYPE = " to \\S++ ";
    private static final String RECIEVE_VALUE = " from \\S++ \\S++ ";
    private static final String RECIEVE_TYPE = " from \\S++ ";
    protected static final String COMPONENT_TERMINATION_VERDICT = "component reference \\d++:";
    protected static final String WAS_DISCONNECTED_FROM = "was disconnected from";
    protected static final String PORT = "Port";
    protected static final String WAS_CLOSED_UNEXPECTEDLY_BY_PEER = "was closed unexpectedly by peer";
    protected static final String CONNECTION_OF_PORT = "Connection of port";
    protected static final String WAS_UNMAPPED_FROM = "was unmapped from";
    protected static final String WAS_MAPPED_TO = "was mapped to";
    protected static final String REMOVING_UNTERMINATED_MAPPING = "Removing unterminated mapping between";
    protected static final String REMOVING_UNTERMINATED_CONNECTION = "Removing unterminated connection between port";
    protected static final String ACCEPTED_CONNECTION = "has accepted the connection from";
    protected static final String WAITING_FOR_CONNECTION = "is waiting for connection from";
    protected static final String CONNECTION_ESTABLISHED = "has established the connection with";
    protected static final String HOST_CONTROLLER_STARTED = "Host Controller started";
    protected static final String START_TIMER = "Start timer";
    protected static final String FINAL_VERDICT = "Final verdict";
    protected static final String RECEIVED_ON = "Received on";
    protected static final String SENT_ON = "Sent on";
    protected static final String ON_COMPONENT = "on component";
    protected static final String STARTING_FUNCTION = "Starting function";
    protected static final String AND = " and ";
    protected static final String CONNECTING_PORTS = "Connecting ports";
    protected static final String FROM = " from ";
    protected static final String UNMAPPING_PORT = "Unmapping port";
    protected static final String TO = " to ";
    protected static final String MAPPING_PORT = "Mapping port";
    protected static final String COMPONENT_REFERENCE = "component reference";
    protected static final String COMPONENT_DONE_REFERENCE = "PTC with component reference";
    protected static final String COMPONENT_DONE = "is done. Return value";
    protected static final String COMPONENT_REFERENCE_CREATE = "Component reference:";
    protected static final String COMPONENT_NAME = "component name:";
    protected static final String MTC_FINISHED = "TTCN-3 Main Test Component finished.";
    protected static final String MTC_STARTED = "TTCN-3 Main Test Component started on";
    protected static final String VERDICT = "Verdict:";
    protected static final String FINISHED = "finished";
    protected static final String STARTED = "started";
    protected static final String TEST_CASE = "Test case";
    protected static final String HOST_CONTROLLER_FINISHED = "Host Controller finished";
    protected static final String ETS_STARTUP = "TTCN-3 Test Executor started in single mode.";
    protected static final String ETS_TERMINATION = "TTCN-3 Test Executor finished in single mode.";
    private static final String SETVERDICT = "setverdict(";
    private List<String> errorCausedBy;
    private List<String> failCausedBy;

    public abstract String getType();

    protected String getTokenAfterString(String string) {
        return this.getTokenAfterString(string, " ,.");
    }

    protected String getTokenAfterString(String string, String delimiter) {
        StringTokenizer tokenizer;
        String[] strings = this.message.split(string);
        if (strings.length > 1 && strings[1] != null && (tokenizer = new StringTokenizer(strings[1], delimiter)).hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        return "";
    }

    protected boolean isSystemCreation() {
        return this.message.contains(HOST_CONTROLLER_STARTED);
    }

    protected boolean isSystemTermination() {
        return this.message.contains(HOST_CONTROLLER_FINISHED);
    }

    protected abstract boolean isComponentTermination();

    protected abstract String getComponentTerminationReference();

    protected boolean isTestcaseStart() {
        return this.message.contains(TEST_CASE) && this.message.contains(STARTED);
    }

    protected String getTestcaseName() {
        return this.getTokenAfterString(TEST_CASE);
    }

    protected boolean isTestcaseEnd() {
        return this.message.contains(TEST_CASE) && this.message.contains(FINISHED);
    }

    protected String getTestcaseVerdict() {
        return this.getTokenAfterString(VERDICT);
    }

    protected boolean isMTCCreation() {
        return this.message.contains(MTC_STARTED);
    }

    protected boolean isMTCTermination() {
        return this.message.contains(MTC_FINISHED);
    }

    protected boolean isMTCDone() {
        return this.message.contains(LOCAL_VERDICT_OF_MTC);
    }

    protected String getMTCVerdict() {
        return this.getTokenAfterString(LOCAL_VERDICT_OF_MTC);
    }

    protected abstract boolean isComponentCreation();

    protected String getComponentCreationName() {
        if (this.message.contains(COMPONENT_NAME)) {
            return this.getTokenAfterString(COMPONENT_NAME);
        }
        return "";
    }

    protected abstract String getComponentCreationReference();

    protected boolean isComponentDone() {
        return this.message.contains(COMPONENT_DONE_REFERENCE) && this.message.contains(IS_DONE);
    }

    protected abstract String getComponentDoneReference();

    protected String getComponentTerminationVerdict() {
        return this.getTokenAfterString(COMPONENT_TERMINATION_VERDICT);
    }

    public boolean isPortMapping() {
        return this.message.contains(MAPPING_PORT);
    }

    public abstract String getPortMappingSource();

    public String getPortMapping() {
        return this.getTokenAfterString(MAPPING_PORT, ":").trim();
    }

    public String getPortMappingSourceRef() {
        return this.getTokenAfterString(MAPPING_PORT).split(":")[0];
    }

    public abstract String getPortMappingTarget();

    public abstract String getPortUnMappingTarget();

    public String getPortMappingTargetRef() {
        return this.getTokenAfterString(TO).split(":")[0];
    }

    public boolean isPortUnmapping() {
        return this.message.contains(UNMAPPING_PORT);
    }

    public String getPortUnmappingSource() {
        return this.getTokenAfterString(UNMAPPING_PORT);
    }

    public abstract String getPortUnMapping();

    public String getPortUnmappingTarget() {
        return this.getTokenAfterString(FROM);
    }

    public boolean isPortConnection() {
        return this.message.contains(CONNECTING_PORTS);
    }

    public abstract boolean isPortDisconnection();

    public abstract String getPortConnectionSource();

    public abstract String getPortConnectionSourceRef();

    public abstract String getPortDisconnectionSource();

    public abstract String getPortDisconnectionSourceRef();

    public abstract String getPortConnectionTarget();

    public abstract String getPortConnectionTargetRef();

    public boolean isStartFunction() {
        return this.message.contains(STARTING_FUNCTION) && this.message.contains(ON_COMPONENT);
    }

    public String getStartFunctionName() {
        return this.getComponentRef(this.getTokenAfterString(STARTING_FUNCTION, " ("));
    }

    public abstract String getStartFunctionReference();

    public boolean isSend() {
        return this.message.contains(SENT_ON);
    }

    public String getSendSource() {
        return this.getComponentRef(this.getTokenAfterString(SENT_ON));
    }

    public String getSendTarget() {
        return this.getComponentRef(this.getTokenAfterString(TO, " "));
    }

    public String getSendType() {
        if (this.message.contains("system(")) {
            int stopIndex = this.message.indexOf(")");
            String tmp = this.message.substring(stopIndex + 1);
            String type = tmp.split(":")[0];
            return type.trim();
        }
        return this.getComponentRef(this.getTokenAfterString(SEND_TYPE, " "));
    }

    public String getSendValue() {
        return this.message.split(SEND_VALUE)[1];
    }

    public boolean isReceive() {
        return this.message.contains(RECEIVED_ON);
    }

    public String getReceiveTarget() {
        return this.getComponentRef(this.getTokenAfterString(RECEIVED_ON));
    }

    public String getReceiveSource() {
        return this.getComponentRef(this.getTokenAfterString(FROM, " "));
    }

    public String getReceiveType() {
        if (this.message.contains("system(")) {
            int stopIndex = this.message.indexOf(")");
            String tmp = this.message.substring(stopIndex + 1);
            String type = tmp.split(":")[0];
            return type.trim();
        }
        return this.getTokenAfterString(RECIEVE_TYPE, " ");
    }

    public String getReceiveValue() {
        return this.message.split(RECIEVE_VALUE)[1];
    }

    public boolean isFinalVerdict() {
        return this.message.contains(FINAL_VERDICT);
    }

    public boolean isTimerStart() {
        return this.message.contains(START_TIMER);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String isSilentEvent() {
        if (this.message.contains(COMPONENT_REFERENCE_CREATE)) {
            return this.getComponentRef(this.getTokenAfterString(COMPONENT_REFERENCE_CREATE));
        }
        if (this.message.contains(COMPONENT_REFERENCE)) {
            return this.getComponentRef(this.getTokenAfterString(COMPONENT_REFERENCE));
        }
        if (this.message.contains(CONNECTION_ESTABLISHED)) {
            return this.getComponentRef(this.getTokenAfterString(CONNECTION_ESTABLISHED, " :"));
        }
        if (this.message.contains(WAITING_FOR_CONNECTION)) {
            return this.getComponentRef(this.getTokenAfterString(WAITING_FOR_CONNECTION, " :"));
        }
        if (this.message.contains(ACCEPTED_CONNECTION)) {
            return this.getComponentRef(this.getTokenAfterString(ACCEPTED_CONNECTION, " :"));
        }
        if (this.message.contains(REMOVING_UNTERMINATED_CONNECTION)) {
            return this.getComponentRef(this.getTokenAfterString(AND, " :"));
        }
        if (this.message.contains(REMOVING_UNTERMINATED_MAPPING)) {
            return this.getComponentRef(this.getTokenAfterString(AND, " :"));
        }
        if (this.message.contains(WAS_MAPPED_TO)) {
            return this.getComponentRef(this.getTokenAfterString(WAS_MAPPED_TO, " :"));
        }
        if (this.message.contains(WAS_UNMAPPED_FROM)) {
            return this.getComponentRef(this.getTokenAfterString(WAS_UNMAPPED_FROM, " :"));
        }
        if (this.message.contains(CONNECTION_OF_PORT) && this.message.contains(WAS_CLOSED_UNEXPECTEDLY_BY_PEER)) {
            return this.getComponentRef(this.getTokenAfterString(TO, " :"));
        }
        if (this.message.contains(PORT) && this.message.contains(WAS_DISCONNECTED_FROM)) {
            return this.getComponentRef(this.getTokenAfterString(WAS_DISCONNECTED_FROM, " :"));
        }
        if (this.message.contains(MAP_OPERATION_OF) && this.message.contains(FINISHED)) {
            return this.getComponentRef(this.getTokenAfterString(MAP_OPERATION_OF, " :"));
        }
        if (this.message.contains(UNMAP_OPERATION_OF) && this.message.contains(FINISHED)) {
            return this.getComponentRef(this.getTokenAfterString(UNMAP_OPERATION_OF, " :"));
        }
        if (this.message.contains(CONNECT_OPERATION_ON) && this.message.contains(FINISHED)) {
            return this.getComponentRef(this.getTokenAfterString(CONNECT_OPERATION_ON, " :"));
        }
        if (this.message.contains(DISCONNECT_OPERATION_ON) && this.message.contains(FINISHED)) {
            return this.getComponentRef(this.getTokenAfterString(DISCONNECT_OPERATION_ON, " :"));
        }
        if (this.message.contains(DISCONNECTING_PORTS) && this.message.contains(AND)) {
            return this.getComponentRef(this.getTokenAfterString(DISCONNECTING_PORTS, " :"));
        }
        if (this.message.contains(CONNECTION_TERMINATION_REQUEST_WAS_RECEIVED_ON_PORT) && this.message.contains(FROM)) {
            return this.getComponentRef(this.getTokenAfterString(FROM, " :"));
        }
        return null;
    }

    public String getMappingPort() {
        return this.getTokenAfterString(MAPPING_PORT, ":").trim();
    }

    public boolean isEnqueued() {
        return this.message.contains(MESSAGE_ENQUEUED_ON);
    }

    public String getEnqueuedTarget() {
        String port = this.getTokenAfterString(MESSAGE_ENQUEUED_ON);
        return port;
    }

    protected String getEnqueuedType() {
        return this.getComponentRef(this.getTokenAfterString(SEND_TYPE, " "));
    }

    protected String getEnqueuedReceiveType() {
        String[] tmpstrings = this.message.split(" ");
        return tmpstrings[0];
    }

    protected boolean isSetverdict() {
        return this.message.contains(SETVERDICT) && this.message.contains("):");
    }

    protected String getSetverdictName() {
        return this.message.split(":")[0];
    }

    protected String getSetverdictType() {
        int startpos = this.message.indexOf("(");
        int stoppos = this.message.indexOf(")");
        return this.message.substring(startpos + 1, stoppos);
    }

    public abstract boolean isReceiveOperation();

    public abstract String getReceiveOperationTarget();

    public abstract String getReceiveOperationType();

    protected String getComponentRef(String compNameAndRef) {
        if (compNameAndRef.startsWith("system(")) {
            int startRef = compNameAndRef.indexOf("(");
            return compNameAndRef.substring(0, startRef);
        }
        if (compNameAndRef.contains("(") && compNameAndRef.contains(")")) {
            int startRef = compNameAndRef.indexOf("(");
            int stopRef = compNameAndRef.indexOf(")");
            return compNameAndRef.substring(startRef + 1, stopRef);
        }
        if (compNameAndRef.contains(":")) {
            String[] component = compNameAndRef.split(":");
            return component[0];
        }
        return compNameAndRef;
    }

    protected boolean isDynamicTestCaseError() {
        for (String anErrorCausedBy : this.errorCausedBy) {
            if (!this.message.contains(anErrorCausedBy)) continue;
            return true;
        }
        return false;
    }

    protected boolean isFailMessages() {
        for (String aFailCausedBy : this.failCausedBy) {
            if (!this.message.contains(aFailCausedBy)) continue;
            return true;
        }
        return false;
    }

    public String getPort(String componentAndPort) {
        if (componentAndPort.contains(":")) {
            int index = componentAndPort.lastIndexOf(":");
            if (index < 0) {
                return "";
            }
            return componentAndPort.substring(index + 1).trim();
        }
        return "";
    }

    public List<String> getErrorCausedBy() {
        return this.errorCausedBy;
    }

    public void setErrorCausedBy(List<String> errorCausedBy) {
        this.errorCausedBy = errorCausedBy;
    }

    public List<String> getFailCausedBy() {
        return this.failCausedBy;
    }

    public void setFailCausedBy(List<String> failCausedBy) {
        this.failCausedBy = failCausedBy;
    }
}

