/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.log.viewer.extractors.TestCaseEvent;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.SelectionUtils;
import org.eclipse.titan.log.viewer.views.text.table.TextTableViewHelper;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenTextTableProjectsViewMenuAction
extends AbstractHandler
implements IActionDelegate,
Observer {
    private IStructuredSelection selection;
    private IProgressMonitor monitor;
    private int lastWorked;
    private IFile logFile;

    public void run(IAction action) {
        this.run(this.selection);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection tempSelection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!(tempSelection instanceof IStructuredSelection)) {
            return null;
        }
        this.selection = (IStructuredSelection)tempSelection;
        this.run(this.selection);
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (selection == null) {
            return;
        }
        int logRecordToSelect = 0;
        if (SelectionUtils.isSelectionALogFile((ISelection)this.selection)) {
            this.logFile = SelectionUtils.selectionToIFile((ISelection)this.selection);
        } else if (selection.getFirstElement() instanceof TestCase) {
            TestCase testCase = (TestCase)selection.getFirstElement();
            this.logFile = testCase.getLogFile();
            logRecordToSelect = testCase.getStartRecordNumber();
        } else {
            return;
        }
        if (this.logFile == null) {
            return;
        }
        String projectName = this.logFile.getProject().getName();
        String projectRelativePath = File.separator + projectName + File.separator + this.logFile.getProjectRelativePath().toOSString();
        if (LogFileCacheHandler.hasLogFileChanged(this.logFile) && !LogFileCacheHandler.processLogFile(this.logFile, (IProgressMonitor)new NullProgressMonitor(), false)) {
            return;
        }
        TextTableViewHelper.open(projectName, projectRelativePath, logRecordToSelect);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.selection = (IStructuredSelection)selection;
        if (this.selection.size() != 1) {
            this.setEnabled(false);
            return;
        }
        boolean isSelectionATestCase = this.selection.getFirstElement() instanceof TestCase;
        this.setEnabled(isSelectionATestCase || SelectionUtils.isSelectionALogFile(selection));
    }

    @Override
    public void update(Observable observable, Object event) {
        if (event instanceof TestCaseEvent) {
            int worked;
            TestCaseEvent testCaseEvent = (TestCaseEvent)event;
            this.lastWorked = worked = testCaseEvent.getProgress();
        }
    }
}

