/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.models.SourceInformation;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.ValueReader;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.EventSelection;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.OpenSourceAction;
import org.eclipse.titan.log.viewer.views.text.table.TextTableView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenSourceViewMenuAction
extends SelectionProviderAction {
    private EventSelection eventSelection;
    private TextTableView view;
    private boolean silent;
    private boolean forceEditorOpening = false;
    private static String lastFilename = null;
    private static URI lastPath = null;
    private ISelection delayedselection = null;
    private InternalRunnable runnable = new InternalRunnable();

    public void delayedRun(ISelection selection) {
        this.delayedselection = selection;
        if (this.runnable.isRunning()) {
            return;
        }
        Display.getDefault().asyncExec((Runnable)this.runnable);
    }

    public OpenSourceViewMenuAction(TextTableView view, boolean silent, boolean forceEditorOpening) {
        super((ISelectionProvider)view, "Open Source");
        this.view = view;
        this.silent = silent;
        this.forceEditorOpening = forceEditorOpening;
    }

    public void run() {
        IFile targetFile;
        LogRecord logrecord;
        if (this.eventSelection == null) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        LogFileMetaData logFileMetaData = this.view.getLogFileMetaData();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(logFileMetaData.getProjectName());
        IFile logFile = project.getFile(logFileMetaData.getProjectRelativePath().substring(logFileMetaData.getProjectName().length() + 1));
        if (!logFile.exists()) {
            IViewReference[] viewReferences = activePage.getViewReferences();
            ActionUtils.closeAssociatedViews(activePage, viewReferences, (IResource)logFile);
            TitanLogExceptionHandler.handleException(new UserException("The log file could not be found.\n Please perform the Open Text Table action again."));
            return;
        }
        if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
            LogFileCacheHandler.handleLogFileChange(logFile);
            return;
        }
        EventObject eventObject = this.eventSelection.getEventObject();
        String testCase = this.eventSelection.getTestCaseName();
        if (eventObject == null || testCase == null) {
            return;
        }
        try {
            logrecord = ValueReader.getInstance().readLogRecordFromLogFile(logFileMetaData.getFilePath(), eventObject);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("MSCView.8")));
            return;
        }
        SourceInformation sourceInformation = null;
        try {
            sourceInformation = SourceInformation.createInstance(logrecord.getSourceInformation());
        }
        catch (SourceInformation.InvalidSourceInformationException e) {
            if (!this.silent) {
                String setting = logFileMetaData.getOptionsSettings("SourceInfoFormat");
                if (setting == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError(null, (String)"Error opening source", (String)"This log file is not generated with source location information inserted. And it really does not seem to contain source location information");
                        }
                    });
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError(null, (String)"Error opening source", (String)"This log record does not seem to contain source location information");
                        }
                    });
                }
            }
            return;
        }
        String fileName = sourceInformation.getSourceFileName();
        if (fileName == null) {
            this.view.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The name of the target file could not be extracted");
            return;
        }
        if (lastFilename != null && lastFilename.equals(fileName) && lastPath != null) {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(lastPath);
            if (files.length == 0) {
                this.view.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The file `" + lastFilename + "' could not be found");
                OpenSourceViewMenuAction.setLastFilename(null);
                return;
            }
            targetFile = files[0];
        } else {
            targetFile = OpenSourceAction.findSourceFile(project, fileName);
            if (targetFile == null) {
                this.view.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The file `" + fileName + "' could not be found");
                return;
            }
            OpenSourceViewMenuAction.setLastFilename(fileName);
            OpenSourceViewMenuAction.setLastPath(targetFile.getLocationURI());
        }
        OpenSourceAction.openEditor(targetFile, sourceInformation.getLineNumber(), (IViewPart)this.view, this.forceEditorOpening);
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof EventSelection) {
            this.eventSelection = (EventSelection)selection;
            this.setEnabled(!this.eventSelection.isEmpty());
        }
        super.selectionChanged(selection);
    }

    private static synchronized void setLastFilename(String lastFilename) {
        OpenSourceViewMenuAction.lastFilename = lastFilename;
    }

    public static synchronized void setLastPath(URI lastPath) {
        OpenSourceViewMenuAction.lastPath = lastPath;
    }

    class InternalRunnable
    implements Runnable {
        private boolean isRunning = false;

        InternalRunnable() {
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public void run() {
            if (OpenSourceViewMenuAction.this.delayedselection == null) {
                return;
            }
            this.isRunning = true;
            OpenSourceViewMenuAction.this.selectionChanged(OpenSourceViewMenuAction.this.delayedselection);
            OpenSourceViewMenuAction.this.delayedselection = null;
            OpenSourceViewMenuAction.this.run();
            this.isRunning = false;
            Display.getDefault().asyncExec((Runnable)OpenSourceViewMenuAction.this.runnable);
        }
    }
}

