/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerShowProcessor;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;

public class MenuManagerHideProcessor
implements IMenuListener2 {
    @Inject
    private MenuManagerRenderer renderer;
    @Inject
    private EModelService modelService;

    public void menuAboutToShow(IMenuManager manager) {
        if (!(manager instanceof MenuManager)) {
            return;
        }
        MenuManager menuManager = (MenuManager)manager;
        MMenu menuModel = this.renderer.getMenuModel(menuManager);
        Menu menu = menuManager.getMenu();
        if (menuModel instanceof MPopupMenu) {
            this.hidePopup(menu, (MPopupMenu)menuModel, menuManager);
        }
        if (menuModel != null && menu != null) {
            this.processDynamicElements((MenuManager)manager, menu, menuModel);
        }
    }

    private void processDynamicElements(final MenuManager menuManager, Menu menu, final MMenu menuModel) {
        final HashMap<MDynamicMenuContribution, ArrayList> toBeHidden = new HashMap<MDynamicMenuContribution, ArrayList>();
        for (MMenuElement currentMenuElement : menuModel.getChildren()) {
            if (!(currentMenuElement instanceof MDynamicMenuContribution)) continue;
            Map storageMap = currentMenuElement.getTransientData();
            ArrayList mel = (ArrayList)storageMap.get(MenuManagerShowProcessor.DYNAMIC_ELEMENT_STORAGE_KEY);
            toBeHidden.put((MDynamicMenuContribution)currentMenuElement, mel);
        }
        if (!menu.isDisposed()) {
            menu.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : toBeHidden.entrySet()) {
                        MDynamicMenuContribution currentMenuElement = (MDynamicMenuContribution)entry.getKey();
                        Object contribution = currentMenuElement.getObject();
                        IEclipseContext dynamicMenuContext = EclipseContextFactory.create();
                        ArrayList mel = (ArrayList)entry.getValue();
                        dynamicMenuContext.set(List.class, (Object)mel);
                        IEclipseContext parentContext = MenuManagerHideProcessor.this.modelService.getContainingContext((MUIElement)currentMenuElement);
                        ContextInjectionFactory.invoke((Object)contribution, AboutToHide.class, (IEclipseContext)parentContext, (IEclipseContext)dynamicMenuContext, null);
                        dynamicMenuContext.dispose();
                        if (mel != null && mel.size() > 0) {
                            MenuManagerHideProcessor.this.renderer.removeDynamicMenuContributions(menuManager, menuModel, mel);
                        }
                        if (mel == null || mel.size() <= 0) continue;
                        for (MMenuElement item : mel) {
                            item.setVisible(false);
                        }
                    }
                }
            });
        }
    }

    public void menuAboutToHide(IMenuManager manager) {
    }

    private void hidePopup(Menu menu, MPopupMenu menuModel, MenuManager menuManager) {
        final IEclipseContext popupContext = menuModel.getContext();
        final IEclipseContext originalChild = (IEclipseContext)popupContext.get("MenuServiceFilter.original.context");
        popupContext.remove("MenuServiceFilter.original.context");
        if (!menu.isDisposed()) {
            menu.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (originalChild == null) {
                        popupContext.deactivate();
                    } else {
                        originalChild.activate();
                    }
                }
            });
        }
    }
}

