/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine.portals;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.LowPassFilter;
import fr.inria.zvtm.engine.portals.CameraPortal;
import fr.inria.zvtm.engine.portals.TrailingTimer;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;

public class TrailingCameraPortal
extends CameraPortal {
    double frequency = -1.0;
    long mLastSampleTime = -1L;
    int xOffset = -120;
    int yOffset = 120;
    LowPassFilter filter = new LowPassFilter();
    Point2D currentPos = new Point2D.Double(0.0, 0.0);
    Point2D parentPos = new Point2D.Double(0.0, 0.0);
    Point2D targetPos = new Point2D.Double(0.0, 0.0);
    Timer timer;
    TrailingTimer mouseStillUpdater;
    double cutoffParamA = 0.4;
    double cutoffParamB = 0.01;
    float translucencyParamA = -0.5f;
    float translucencyParamB = 0.5f;
    double distAway = 0.0;
    float alpha = 0.0f;

    public TrailingCameraPortal(int x, int y, int w, int h, Camera c, float a, int xo, int yo) {
        super(x, y, w, h, c, a);
        this.xOffset = xo;
        this.yOffset = yo;
        this.timer = new Timer();
        this.mouseStillUpdater = new TrailingTimer(this);
        this.timer.scheduleAtFixedRate((TimerTask)this.mouseStillUpdater, 40L, 40L);
    }

    public void setCutoffFrequencyParameters(double a, double b) {
        this.cutoffParamA = a;
        this.cutoffParamB = b;
    }

    public void setTranslucencyParameters(float a, float b) {
        this.translucencyParamA = a;
        this.translucencyParamB = b;
    }

    public void updateFrequency() {
        this.updateFrequency(System.currentTimeMillis());
    }

    public void updateFrequency(long currentTime) {
        if (this.frequency == -1.0) {
            this.frequency = 1.0;
        } else if (currentTime != this.mLastSampleTime) {
            this.frequency = 1000.0 / (double)(currentTime - this.mLastSampleTime);
        }
        this.mLastSampleTime = currentTime;
    }

    public void updateWidgetLocation(int cx, int cy) {
        this.parentPos.setLocation(cx, cy);
        this.updateWidgetLocation();
    }

    public double getDistance() {
        return this.distAway;
    }

    public void updateWidgetLocation() {
        this.targetPos.setLocation(this.parentPos.getX() + (double)this.xOffset, this.parentPos.getY() + (double)this.yOffset);
        this.distAway = this.targetPos.distance(this.currentPos);
        double maxDist = 2 * Math.abs(this.xOffset);
        double opacity = 1.0 - Math.min(1.0, this.distAway / maxDist);
        this.filter.setCutOffFrequency((1.0 - opacity) * this.cutoffParamA + this.cutoffParamB);
        this.currentPos = this.filter.apply(this.targetPos, this.frequency);
        int tx = (int)Math.round(this.currentPos.getX());
        int ty = (int)Math.round(this.currentPos.getY());
        tx = Math.max(tx, this.w / 2);
        ty = Math.min(ty, this.owningView.getPanelSize().height - this.h / 2);
        if (this.x != tx - this.w / 2 || this.y != ty - this.h / 2) {
            this.moveTo(tx - this.w / 2, ty - this.h / 2);
            this.alpha = (float)opacity * this.translucencyParamA + this.translucencyParamB;
            if (this.alpha < 0.0f) {
                this.alpha = 0.0f;
            } else if (this.alpha > 1.0f) {
                this.alpha = 1.0f;
            }
            this.setTranslucencyValue(this.alpha);
            this.owningView.repaint();
        }
    }

    public void setNoUpdateWhenMouseStill(boolean b) {
        this.mouseStillUpdater.setEnabled(!b);
    }

    public void dispose() {
        this.timer.cancel();
    }
}

