/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.animation.examples;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.AnimationManager;
import fr.inria.zvtm.animation.DefaultTimingHandler;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VCircle;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;

public class TestCameraPosition {
    VirtualSpaceManager vsm = VirtualSpaceManager.INSTANCE;
    VirtualSpace vs;
    ViewListener eh;
    AnimationManager am = this.vsm.getAnimationManager();
    View testView;
    Camera cam;

    TestCameraPosition() {
        VirtualSpaceManager.setDebug(true);
    }

    public void startAnim(String vt) {
        this.eh = new MyEventHandler(this);
        this.vs = this.vsm.addVirtualSpace("src");
        this.cam = this.vs.addCamera();
        Vector<Camera> cameras = new Vector<Camera>();
        cameras.add(this.cam);
        this.cam.setZoomFloor(-90.0);
        this.testView = this.vsm.addFrameView(cameras, "Test", vt, 800, 600, true);
        this.testView.setBackgroundColor(Color.LIGHT_GRAY);
        this.testView.setListener(this.eh);
        int NB_GLYPHS = 100;
        ArrayList circles = new ArrayList();
        Random rnd = new Random();
        for (int i = 0; i < 100; ++i) {
            final VCircle circle = new VCircle(63 * i, 30 * i, 0, 30.0, Color.getHSBColor(rnd.nextFloat(), rnd.nextFloat(), rnd.nextFloat()));
            circles.add(circle);
            this.vs.addGlyph(circle);
            Animation anim = this.am.getAnimationFactory().createAnimation(3000, -1.0, Animation.RepeatBehavior.REVERSE, circle, Animation.Dimension.POSITION, new DefaultTimingHandler(){
                final double initX;
                final double initY;
                {
                    this.initX = circle.vx;
                    this.initY = circle.vy;
                }

                @Override
                public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                    Glyph g = (Glyph)subject;
                    g.moveTo(this.initX, (double)(1.0f - fraction) * this.initY);
                }
            }, (Interpolator)new SplineInterpolator(0.1f, 0.95f, 0.2f, 0.95f));
            anim.setStartFraction(rnd.nextFloat());
            this.am.startAnimation(anim, false);
        }
        this.cam.setLocation(this.testView.getGlobalView(this.cam));
    }

    public static void main(String[] args) {
        System.out.println("-----------------");
        System.out.println("General information");
        System.out.println("JVM version: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
        System.out.println("OS type: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + " " + System.getProperty("sun.cpu.isalist"));
        System.out.println("-----------------");
        System.out.println("Directory information");
        System.out.println("Java Classpath: " + System.getProperty("java.class.path"));
        System.out.println("Java directory: " + System.getProperty("java.home"));
        System.out.println("Launching from: " + System.getProperty("user.dir"));
        System.out.println("-----------------");
        System.out.println("User informations");
        System.out.println("User name: " + System.getProperty("user.name"));
        System.out.println("User home directory: " + System.getProperty("user.home"));
        System.out.println("-----------------");
        System.out.println("Left-click in the view to move the camera");
        new TestCameraPosition().startAnim(args.length > 0 ? args[0] : "std");
    }

    class MyEventHandler
    implements ViewListener {
        TestCameraPosition application;

        MyEventHandler(TestCameraPosition appli) {
            this.application = appli;
        }

        @Override
        public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
            final double sx = TestCameraPosition.this.cam.vx;
            final double sy = TestCameraPosition.this.cam.vy;
            final double ex = v.getVCursor().getVSXCoordinate();
            final double ey = v.getVCursor().getVSYCoordinate();
            Animation trans = TestCameraPosition.this.am.getAnimationFactory().createAnimation(1000, 1.0, Animation.RepeatBehavior.LOOP, TestCameraPosition.this.cam, Animation.Dimension.POSITION, new DefaultTimingHandler(){
                final double startX;
                final double startY;
                final double endX;
                final double endY;
                {
                    this.startX = sx;
                    this.startY = sy;
                    this.endX = ex;
                    this.endY = ey;
                }

                @Override
                public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                    Camera c = (Camera)subject;
                    c.moveTo((double)fraction * (this.endX - this.startX) + this.startX, (double)fraction * (this.endY - this.startY) + this.startY);
                }
            }, SlowInSlowOutInterpolator.getInstance());
            Animation altitude = TestCameraPosition.this.am.getAnimationFactory().createAnimation(1000, TestCameraPosition.this.cam, Animation.Dimension.ALTITUDE, new DefaultTimingHandler(){
                final double initZ;
                {
                    this.initZ = TestCameraPosition.this.cam.getAltitude();
                }

                @Override
                public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                    Camera c = (Camera)subject;
                    c.setAltitude(this.initZ + 0.25 * this.initZ * Math.sin(Math.PI * (double)fraction));
                }

                @Override
                public void end(Object subject, Animation.Dimension dim) {
                    Camera c = (Camera)subject;
                    c.setAltitude(this.initZ);
                }
            });
            TestCameraPosition.this.am.startAnimation(trans, true);
            TestCameraPosition.this.am.startAnimation(altitude, true);
        }

        @Override
        public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        }

        @Override
        public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
            v.setDrawDrag(true);
            this.application.vsm.getActiveView().mouse.setSensitivity(false);
        }

        @Override
        public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
            v.setDrawDrag(false);
            this.application.vsm.getActiveView().mouse.setSensitivity(true);
        }

        @Override
        public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        }

        @Override
        public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
            Camera c = this.application.vsm.getActiveCamera();
            double a = (c.focal + Math.abs(c.altitude)) / c.focal;
            if (wheelDirection == 1) {
                c.altitudeOffset(-a * 5.0);
                this.application.vsm.repaint();
            } else {
                c.altitudeOffset(a * 5.0);
                this.application.vsm.repaint();
            }
        }

        @Override
        public void enterGlyph(Glyph g) {
            g.highlight(true, null);
        }

        @Override
        public void exitGlyph(Glyph g) {
            g.highlight(false, null);
        }

        @Override
        public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        @Override
        public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        @Override
        public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        @Override
        public void viewActivated(View v) {
        }

        @Override
        public void viewDeactivated(View v) {
        }

        @Override
        public void viewIconified(View v) {
        }

        @Override
        public void viewDeiconified(View v) {
        }

        @Override
        public void viewClosing(View v) {
            System.exit(0);
        }
    }
}

