/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;

public class NexusIndexWriter
extends IndexWriter {
    private boolean closed = false;

    public NexusIndexWriter(Directory directory, Analyzer analyzer, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(directory, analyzer, create, false);
    }

    public NexusIndexWriter(Directory directory, Analyzer analyzer, boolean create, boolean autoCommit) throws CorruptIndexException, LockObtainFailedException, IOException {
        super(directory, autoCommit, analyzer, create);
    }

    public void close() throws CorruptIndexException, IOException {
        super.close();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean hasUncommittedChanges() {
        try {
            Field pendingCommit = IndexWriter.class.getDeclaredField("pendingCommit");
            pendingCommit.setAccessible(true);
            return pendingCommit.get((Object)this) != null;
        }
        catch (Exception x) {
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new RuntimeException("Could not access the \"IndexWriter.pendingCommit\" field!", x);
        }
    }
}

