/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.hierarchy;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Provider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceAcceptor;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.editor.hierarchy.AbstractHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultHierarchyNodeReference;
import org.eclipse.xtext.ide.editor.hierarchy.ICallHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeLocationProvider;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class DefaultCallHierarchyBuilder
extends AbstractHierarchyBuilder
implements ICallHierarchyBuilder {
    @Accessors
    private ICallHierarchyBuilder.CallHierarchyType hierarchyType = ICallHierarchyBuilder.CallHierarchyType.CALLER;

    @Override
    public Collection<IHierarchyNode> buildRoots(URI rootURI, IProgressMonitor monitor) {
        IEObjectDescription rootDeclaration = this.findDeclaration(rootURI);
        if (rootDeclaration == null) {
            return CollectionLiterals.emptyList();
        }
        IHierarchyNode _createRoot = this.createRoot(rootDeclaration);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IHierarchyNode[]{_createRoot}));
    }

    @Override
    public Collection<IHierarchyNode> buildChildren(final IHierarchyNode parent, IProgressMonitor monitor) {
        boolean _not;
        boolean _mayHaveChildren = parent.mayHaveChildren();
        boolean bl = _not = !_mayHaveChildren;
        if (_not) {
            return CollectionLiterals.emptyList();
        }
        final LinkedHashMap children = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        Procedures.Procedure2<IEObjectDescription, IReferenceDescription> _function = new Procedures.Procedure2<IEObjectDescription, IReferenceDescription>(){

            public void apply(IEObjectDescription declaration, IReferenceDescription reference) {
                IHierarchyNode childNode = DefaultCallHierarchyBuilder.this.createChild(children, declaration, parent);
                if (childNode != null) {
                    Collection<IHierarchyNodeReference> _references = childNode.getReferences();
                    IHierarchyNodeReference _createNodeReference = DefaultCallHierarchyBuilder.this.createNodeReference(reference);
                    _references.add(_createNodeReference);
                }
            }
        };
        this.findDeclarations(parent, monitor, (Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription>)_function);
        return children.values();
    }

    protected void findDeclarations(IHierarchyNode parent, IProgressMonitor monitor, Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        ICallHierarchyBuilder.CallHierarchyType hierarchyType = this.hierarchyType;
        if (hierarchyType != null) {
            switch (hierarchyType) {
                case CALLEE: {
                    IEObjectDescription _element = parent.getElement();
                    URI _eObjectURI = _element.getEObjectURI();
                    this.findTargetDeclarations(_eObjectURI, monitor, acceptor);
                    break;
                }
                default: {
                    IEObjectDescription _element_1 = parent.getElement();
                    URI _eObjectURI_1 = _element_1.getEObjectURI();
                    this.findSourceDeclarations(_eObjectURI_1, monitor, acceptor);
                    break;
                }
            }
        } else {
            IEObjectDescription _element_1 = parent.getElement();
            URI _eObjectURI_1 = _element_1.getEObjectURI();
            this.findSourceDeclarations(_eObjectURI_1, monitor, acceptor);
        }
    }

    protected void findTargetDeclarations(URI sourceDeclarationURI, final IProgressMonitor monitor, final Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        IUnitOfWork<Object, EObject> _function = new IUnitOfWork<Object, EObject>(){

            public Object exec(EObject sourceDeclaration) throws Exception {
                Object _xblockexpression = null;
                IReferenceFinder _referenceFinder = DefaultCallHierarchyBuilder.this.getReferenceFinder();
                IResourceServiceProvider.Registry _resourceServiceProviderRegistry = DefaultCallHierarchyBuilder.this.getResourceServiceProviderRegistry();
                IAcceptor<IReferenceDescription> _function = new IAcceptor<IReferenceDescription>(){

                    public void accept(IReferenceDescription reference) {
                        boolean _filterReference = DefaultCallHierarchyBuilder.this.filterReference(reference);
                        if (_filterReference) {
                            IEObjectDescription _findTargetDeclaration = null;
                            if (reference != null) {
                                _findTargetDeclaration = DefaultCallHierarchyBuilder.this.findTargetDeclaration(reference);
                            }
                            IEObjectDescription targetDeclaration = _findTargetDeclaration;
                            acceptor.apply((Object)targetDeclaration, (Object)reference);
                        }
                    }
                };
                ReferenceAcceptor _referenceAcceptor = new ReferenceAcceptor(_resourceServiceProviderRegistry, (IAcceptor)_function);
                _referenceFinder.findAllReferences(sourceDeclaration, (IReferenceFinder.Acceptor)_referenceAcceptor, monitor);
                _xblockexpression = null;
                return _xblockexpression;
            }
        };
        this.readOnly(sourceDeclarationURI, _function);
    }

    protected void findSourceDeclarations(URI targetDeclarationURI, IProgressMonitor monitor, final Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        TargetURIs targetURIs = this.collectTargetURIs(targetDeclarationURI);
        IReferenceFinder _referenceFinder = this.getReferenceFinder();
        IReferenceFinder.IResourceAccess _resourceAccess = this.getResourceAccess();
        IResourceDescriptions _indexData = this.getIndexData();
        IResourceServiceProvider.Registry _resourceServiceProviderRegistry = this.getResourceServiceProviderRegistry();
        IAcceptor<IReferenceDescription> _function = new IAcceptor<IReferenceDescription>(){

            public void accept(IReferenceDescription reference) {
                boolean _filterReference = DefaultCallHierarchyBuilder.this.filterReference(reference);
                if (_filterReference) {
                    IEObjectDescription _findSourceDeclaration = null;
                    if (reference != null) {
                        _findSourceDeclaration = DefaultCallHierarchyBuilder.this.findSourceDeclaration(reference);
                    }
                    IEObjectDescription sourceDeclaration = _findSourceDeclaration;
                    acceptor.apply((Object)sourceDeclaration, (Object)reference);
                }
            }
        };
        ReferenceAcceptor _referenceAcceptor = new ReferenceAcceptor(_resourceServiceProviderRegistry, (IAcceptor)_function);
        _referenceFinder.findAllReferences(targetURIs, _resourceAccess, _indexData, (IReferenceFinder.Acceptor)_referenceAcceptor, monitor);
    }

    protected TargetURIs collectTargetURIs(URI targetURI) {
        Provider<TargetURIs> _targetURIProvider = this.getTargetURIProvider();
        final TargetURIs targetURIs = (TargetURIs)_targetURIProvider.get();
        if (targetURI == null) {
            return targetURIs;
        }
        IUnitOfWork<TargetURIs, EObject> _function = new IUnitOfWork<TargetURIs, EObject>(){

            public TargetURIs exec(EObject targetObject) throws Exception {
                if (targetObject == null) {
                    return targetURIs;
                }
                TargetURICollector _targetURICollector = DefaultCallHierarchyBuilder.this.getTargetURICollector();
                _targetURICollector.add(targetObject, targetURIs);
                return targetURIs;
            }
        };
        return this.readOnly(targetURI, _function);
    }

    protected boolean filterReference(IReferenceDescription reference) {
        return reference != null;
    }

    protected IEObjectDescription findDeclaration(URI objectURI) {
        return this.getDescription(objectURI);
    }

    protected IEObjectDescription findTargetDeclaration(IReferenceDescription reference) {
        URI _targetEObjectUri = reference.getTargetEObjectUri();
        return this.findDeclaration(_targetEObjectUri);
    }

    protected IEObjectDescription findSourceDeclaration(IReferenceDescription reference) {
        URI _containerEObjectURI = reference.getContainerEObjectURI();
        return this.findDeclaration(_containerEObjectURI);
    }

    protected IHierarchyNode createRoot(IEObjectDescription declaration) {
        DefaultHierarchyNode node = new DefaultHierarchyNode();
        node.setElement(declaration);
        node.setMayHaveChildren(true);
        return node;
    }

    protected IHierarchyNode createChild(IEObjectDescription declaration, IHierarchyNode parent) {
        DefaultHierarchyNode node = new DefaultHierarchyNode();
        node.setParent(parent);
        node.setElement(declaration);
        boolean _isRecursive = node.isRecursive();
        boolean _not = !_isRecursive;
        node.setMayHaveChildren(_not);
        return node;
    }

    protected IHierarchyNode createChild(Map<URI, IHierarchyNode> children, IEObjectDescription declaration, IHierarchyNode parent) {
        if (declaration == null) {
            return null;
        }
        URI _eObjectURI = declaration.getEObjectURI();
        IHierarchyNode childNode = children.get(_eObjectURI);
        if (childNode == null) {
            IHierarchyNode _createChild;
            childNode = _createChild = this.createChild(declaration, parent);
            URI _eObjectURI_1 = declaration.getEObjectURI();
            children.put(_eObjectURI_1, childNode);
        }
        return childNode;
    }

    protected IHierarchyNodeReference createNodeReference(final IReferenceDescription reference) {
        URI _sourceEObjectUri = reference.getSourceEObjectUri();
        IUnitOfWork<DefaultHierarchyNodeReference, EObject> _function = new IUnitOfWork<DefaultHierarchyNodeReference, EObject>(){

            public DefaultHierarchyNodeReference exec(EObject sourceObject) throws Exception {
                EReference _eReference = reference.getEReference();
                int _indexInList = reference.getIndexInList();
                ITextRegionWithLineInformation textRegion = DefaultCallHierarchyBuilder.this.getTextRegion(sourceObject, _eReference, _indexInList);
                String text = DefaultCallHierarchyBuilder.this.getText(sourceObject, textRegion);
                return new DefaultHierarchyNodeReference(text, textRegion, reference);
            }
        };
        return this.readOnly(_sourceEObjectUri, _function);
    }

    protected ITextRegionWithLineInformation getTextRegion(EObject obj, EReference reference, int indexInList) {
        IHierarchyNodeLocationProvider _hierarchyNodeLocationProvider = this.getHierarchyNodeLocationProvider();
        return _hierarchyNodeLocationProvider.getTextRegion(obj, (EStructuralFeature)reference, indexInList);
    }

    protected String getText(EObject obj, ITextRegionWithLineInformation textRegion) {
        if (obj == null || textRegion == ITextRegionWithLineInformation.EMPTY_REGION) {
            return "";
        }
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)obj);
        ICompositeNode node = NodeModelUtils.getNode((EObject)_rootContainer);
        if (node == null) {
            return "";
        }
        int _offset = textRegion.getOffset();
        int _length = textRegion.getLength();
        int endOffset = _offset + _length;
        ICompositeNode _rootNode = node.getRootNode();
        String _text = _rootNode.getText();
        int _offset_1 = textRegion.getOffset();
        return _text.substring(_offset_1, endOffset);
    }

    @Override
    @Pure
    public ICallHierarchyBuilder.CallHierarchyType getHierarchyType() {
        return this.hierarchyType;
    }

    @Override
    public void setHierarchyType(ICallHierarchyBuilder.CallHierarchyType hierarchyType) {
        this.hierarchyType = hierarchyType;
    }
}

