/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructorProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTarget;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.EnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Beta
public class AccessorsProcessor
implements TransformationParticipant<MutableMemberDeclaration> {
    public void doTransform(List<? extends MutableMemberDeclaration> elements, final @Extension TransformationContext context) {
        Procedures.Procedure1<MutableMemberDeclaration> _function = new Procedures.Procedure1<MutableMemberDeclaration>(){

            public void apply(MutableMemberDeclaration it) {
                AccessorsProcessor.this.transform(it, context);
            }
        };
        IterableExtensions.forEach(elements, (Procedures.Procedure1)_function);
    }

    protected void _transform(MutableFieldDeclaration it, @Extension TransformationContext context) {
        boolean _shouldAddSetter;
        Util util = new Util(context);
        boolean _shouldAddGetter = util.shouldAddGetter((FieldDeclaration)it);
        if (_shouldAddGetter) {
            AccessorType _getterType = util.getGetterType((FieldDeclaration)it);
            Visibility _visibility = util.toVisibility(_getterType);
            util.addGetter(it, _visibility);
        }
        if (_shouldAddSetter = util.shouldAddSetter((FieldDeclaration)it)) {
            AccessorType _setterType = util.getSetterType((FieldDeclaration)it);
            Visibility _visibility_1 = util.toVisibility(_setterType);
            util.addSetter(it, _visibility_1);
        }
    }

    protected void _transform(MutableClassDeclaration it, final @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        Type _findTypeGlobally = context.findTypeGlobally(Data.class);
        AnnotationReference _findAnnotation = it.findAnnotation(_findTypeGlobally);
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        FinalFieldsConstructorProcessor.Util requiredArgsUtil = new FinalFieldsConstructorProcessor.Util(context);
        if (requiredArgsUtil.needsFinalFieldConstructor(it) || it.findAnnotation(context.findTypeGlobally(FinalFieldsConstructor.class)) != null) {
            requiredArgsUtil.addFinalFieldsConstructor(it);
        }
        Iterable _declaredFields = it.getDeclaredFields();
        Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

            public Boolean apply(MutableFieldDeclaration it) {
                return !it.isStatic() && context.isThePrimaryGeneratedJavaElement((Element)it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function);
        Procedures.Procedure1<MutableFieldDeclaration> _function_1 = new Procedures.Procedure1<MutableFieldDeclaration>(){

            public void apply(MutableFieldDeclaration it) {
                AccessorsProcessor.this._transform(it, context);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
    }

    public void transform(MutableMemberDeclaration it, TransformationContext context) {
        if (it instanceof MutableClassDeclaration) {
            this._transform((MutableClassDeclaration)it, context);
            return;
        }
        if (it instanceof MutableFieldDeclaration) {
            this._transform((MutableFieldDeclaration)it, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, context).toString());
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public Visibility toVisibility(AccessorType type) {
            Visibility _switchResult;
            block11: {
                block10: {
                    _switchResult = null;
                    if (type == null) break block10;
                    switch (type) {
                        case PUBLIC_GETTER: {
                            _switchResult = Visibility.PUBLIC;
                            break block11;
                        }
                        case PROTECTED_GETTER: {
                            _switchResult = Visibility.PROTECTED;
                            break block11;
                        }
                        case PACKAGE_GETTER: {
                            _switchResult = Visibility.DEFAULT;
                            break block11;
                        }
                        case PRIVATE_GETTER: {
                            _switchResult = Visibility.PRIVATE;
                            break block11;
                        }
                        case PUBLIC_SETTER: {
                            _switchResult = Visibility.PUBLIC;
                            break block11;
                        }
                        case PROTECTED_SETTER: {
                            _switchResult = Visibility.PROTECTED;
                            break block11;
                        }
                        case PACKAGE_SETTER: {
                            _switchResult = Visibility.DEFAULT;
                            break block11;
                        }
                        case PRIVATE_SETTER: {
                            _switchResult = Visibility.PRIVATE;
                            break block11;
                        }
                        default: {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Cannot convert ");
                            _builder.append((Object)type, "");
                            throw new IllegalArgumentException(_builder.toString());
                        }
                    }
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Cannot convert ");
                _builder.append((Object)type, "");
                throw new IllegalArgumentException(_builder.toString());
            }
            return _switchResult;
        }

        public boolean hasGetter(final FieldDeclaration it) {
            List<String> _possibleGetterNames = this.getPossibleGetterNames(it);
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String name) {
                    TypeDeclaration _declaringType = it.getDeclaringType();
                    MethodDeclaration _findDeclaredMethod = _declaringType.findDeclaredMethod(name, new TypeReference[0]);
                    return _findDeclaredMethod != null;
                }
            };
            return IterableExtensions.exists(_possibleGetterNames, (Functions.Function1)_function);
        }

        public boolean shouldAddGetter(FieldDeclaration it) {
            return !this.hasGetter(it) && this.getGetterType(it) != AccessorType.NONE;
        }

        public AccessorType getGetterType(FieldDeclaration it) {
            AnnotationReference _elvis = null;
            AnnotationReference _accessorsAnnotation = this.getAccessorsAnnotation((AnnotationTarget)it);
            if (_accessorsAnnotation != null) {
                _elvis = _accessorsAnnotation;
            } else {
                AnnotationReference _accessorsAnnotation_1;
                TypeDeclaration _declaringType = it.getDeclaringType();
                _elvis = _accessorsAnnotation_1 = this.getAccessorsAnnotation((AnnotationTarget)_declaringType);
            }
            AnnotationReference annotation = _elvis;
            if (annotation != null) {
                EnumerationValueDeclaration[] _enumArrayValue = annotation.getEnumArrayValue("value");
                Functions.Function1<EnumerationValueDeclaration, AccessorType> _function = new Functions.Function1<EnumerationValueDeclaration, AccessorType>(){

                    public AccessorType apply(EnumerationValueDeclaration it) {
                        String _simpleName = it.getSimpleName();
                        return AccessorType.valueOf(_simpleName);
                    }
                };
                List types = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_enumArrayValue)), (Functions.Function1)_function);
                AccessorType _elvis_1 = null;
                Functions.Function1<AccessorType, Boolean> _function_1 = new Functions.Function1<AccessorType, Boolean>(){

                    public Boolean apply(AccessorType it) {
                        String _name = it.name();
                        return _name.endsWith("GETTER");
                    }
                };
                AccessorType _findFirst = (AccessorType)((Object)IterableExtensions.findFirst((Iterable)types, (Functions.Function1)_function_1));
                _elvis_1 = _findFirst != null ? _findFirst : AccessorType.NONE;
                return _elvis_1;
            }
            return null;
        }

        public AnnotationReference getAccessorsAnnotation(AnnotationTarget it) {
            Type _findTypeGlobally = this.context.findTypeGlobally(Accessors.class);
            return it.findAnnotation(_findTypeGlobally);
        }

        public Object validateGetter(MutableFieldDeclaration field) {
            return null;
        }

        public String getGetterName(FieldDeclaration it) {
            List<String> _possibleGetterNames = this.getPossibleGetterNames(it);
            return (String)IterableExtensions.head(_possibleGetterNames);
        }

        public List<String> getPossibleGetterNames(final FieldDeclaration it) {
            ArrayList names = CollectionLiterals.newArrayList((Object[])new String[0]);
            if (this.isBooleanType(this.orObject(it.getType())) && it.getSimpleName().startsWith("is") && it.getSimpleName().length() > 2 && Character.isUpperCase(it.getSimpleName().charAt(2))) {
                String _simpleName = it.getSimpleName();
                names.add(_simpleName);
            }
            List _xifexpression = null;
            TypeReference _type = it.getType();
            TypeReference _orObject = this.orObject(_type);
            boolean _isBooleanType = this.isBooleanType(_orObject);
            _xifexpression = _isBooleanType ? Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"is", "get"})) : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"get"}));
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String prefix) {
                    String _simpleName = it.getSimpleName();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName);
                    return String.valueOf(prefix) + _firstUpper;
                }
            };
            List _map = ListExtensions.map(_xifexpression, (Functions.Function1)_function);
            names.addAll(_map);
            return names;
        }

        public boolean isBooleanType(TypeReference it) {
            return !it.isInferred() && Objects.equal((Object)it, (Object)this.context.getPrimitiveBoolean());
        }

        public void addGetter(final MutableFieldDeclaration field, final Visibility visibility) {
            this.validateGetter(field);
            field.markAsRead();
            MutableTypeDeclaration _declaringType = field.getDeclaringType();
            String _getterName = this.getGetterName((FieldDeclaration)field);
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)field);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    AnnotationReference _newAnnotationReference = Util.this.context.newAnnotationReference(Pure.class);
                    it.addAnnotation(_newAnnotationReference);
                    TypeReference _type = field.getType();
                    TypeReference _orObject = Util.this.orObject(_type);
                    it.setReturnType(_orObject);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"return ");
                            Object _fieldOwner = Util.this.fieldOwner(field);
                            _builder.append(_fieldOwner, "");
                            _builder.append((Object)".");
                            String _simpleName = field.getSimpleName();
                            _builder.append((Object)_simpleName, "");
                            _builder.append((Object)";");
                        }
                    };
                    it.setBody(_client);
                    boolean _isStatic = field.isStatic();
                    it.setStatic(_isStatic);
                    it.setVisibility(visibility);
                }
            };
            _declaringType.addMethod(_getterName, (Procedures.Procedure1)_function);
        }

        public AccessorType getSetterType(FieldDeclaration it) {
            AnnotationReference _elvis = null;
            AnnotationReference _accessorsAnnotation = this.getAccessorsAnnotation((AnnotationTarget)it);
            if (_accessorsAnnotation != null) {
                _elvis = _accessorsAnnotation;
            } else {
                AnnotationReference _accessorsAnnotation_1;
                TypeDeclaration _declaringType = it.getDeclaringType();
                _elvis = _accessorsAnnotation_1 = this.getAccessorsAnnotation((AnnotationTarget)_declaringType);
            }
            AnnotationReference annotation = _elvis;
            if (annotation != null) {
                EnumerationValueDeclaration[] _enumArrayValue = annotation.getEnumArrayValue("value");
                Functions.Function1<EnumerationValueDeclaration, AccessorType> _function = new Functions.Function1<EnumerationValueDeclaration, AccessorType>(){

                    public AccessorType apply(EnumerationValueDeclaration it) {
                        String _simpleName = it.getSimpleName();
                        return AccessorType.valueOf(_simpleName);
                    }
                };
                List types = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_enumArrayValue)), (Functions.Function1)_function);
                AccessorType _elvis_1 = null;
                Functions.Function1<AccessorType, Boolean> _function_1 = new Functions.Function1<AccessorType, Boolean>(){

                    public Boolean apply(AccessorType it) {
                        String _name = it.name();
                        return _name.endsWith("SETTER");
                    }
                };
                AccessorType _findFirst = (AccessorType)((Object)IterableExtensions.findFirst((Iterable)types, (Functions.Function1)_function_1));
                _elvis_1 = _findFirst != null ? _findFirst : AccessorType.NONE;
                return _elvis_1;
            }
            return null;
        }

        private Object fieldOwner(MutableFieldDeclaration it) {
            String _xifexpression = null;
            boolean _isStatic = it.isStatic();
            if (_isStatic) {
                MutableTypeDeclaration _declaringType = it.getDeclaringType();
                _xifexpression = this.context.newTypeReference((Type)_declaringType, new TypeReference[0]);
            } else {
                _xifexpression = "this";
            }
            return _xifexpression;
        }

        public boolean hasSetter(FieldDeclaration it) {
            TypeDeclaration _declaringType = it.getDeclaringType();
            String _setterName = this.getSetterName(it);
            TypeReference _type = it.getType();
            TypeReference _orObject = this.orObject(_type);
            MethodDeclaration _findDeclaredMethod = _declaringType.findDeclaredMethod(_setterName, new TypeReference[]{_orObject});
            return _findDeclaredMethod != null;
        }

        public String getSetterName(FieldDeclaration it) {
            String _simpleName = it.getSimpleName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName);
            return "set" + _firstUpper;
        }

        public boolean shouldAddSetter(FieldDeclaration it) {
            return !it.isFinal() && !this.hasSetter(it) && this.getSetterType(it) != AccessorType.NONE;
        }

        public void validateSetter(MutableFieldDeclaration field) {
            boolean _isFinal = field.isFinal();
            if (_isFinal) {
                this.context.addError((Element)field, "Cannot set a final field");
            }
            if (field.getType() == null || field.getType().isInferred()) {
                this.context.addError((Element)field, "Type cannot be inferred.");
                return;
            }
        }

        public void addSetter(final MutableFieldDeclaration field, final Visibility visibility) {
            this.validateSetter(field);
            MutableTypeDeclaration _declaringType = field.getDeclaringType();
            String _setterName = this.getSetterName((FieldDeclaration)field);
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)field);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    TypeReference _primitiveVoid = Util.this.context.getPrimitiveVoid();
                    it.setReturnType(_primitiveVoid);
                    String _simpleName = field.getSimpleName();
                    TypeReference _type = field.getType();
                    TypeReference _orObject = Util.this.orObject(_type);
                    final MutableParameterDeclaration param = it.addParameter(_simpleName, _orObject);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            Object _fieldOwner = Util.this.fieldOwner(field);
                            _builder.append(_fieldOwner, "");
                            _builder.append((Object)".");
                            String _simpleName = field.getSimpleName();
                            _builder.append((Object)_simpleName, "");
                            _builder.append((Object)" = ");
                            String _simpleName_1 = param.getSimpleName();
                            _builder.append((Object)_simpleName_1, "");
                            _builder.append((Object)";");
                        }
                    };
                    it.setBody(_client);
                    boolean _isStatic = field.isStatic();
                    it.setStatic(_isStatic);
                    it.setVisibility(visibility);
                }
            };
            _declaringType.addMethod(_setterName, (Procedures.Procedure1)_function);
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _xifexpression = null;
            _xifexpression = ref == null ? this.context.getObject() : ref;
            return _xifexpression;
        }
    }
}

