/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.swt.graphics.Image;

public class AssignToVariableAssistProposal
extends LinkedCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    private final String KEY_NAME = "name";
    private final String KEY_TYPE = "type";
    private final int fVariableKind;
    private final List<ASTNode> fNodesToAssign;
    private final ITypeBinding fTypeBinding;
    private VariableDeclarationFragment fExistingFragment;

    public AssignToVariableAssistProposal(ICompilationUnit cu, int variableKind, ExpressionStatement node, ITypeBinding typeBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fVariableKind = variableKind;
        this.fNodesToAssign = new ArrayList<ASTNode>();
        this.fNodesToAssign.add((ASTNode)node);
        if (typeBinding.isWildcardType()) {
            typeBinding = ASTResolving.normalizeWildcardType(typeBinding, true, node.getAST());
        }
        this.fTypeBinding = typeBinding;
        if (variableKind == 1) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assigntolocal_description);
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif"));
        } else {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assigntofield_description);
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
        }
        this.createImportRewrite((CompilationUnit)node.getRoot());
    }

    public AssignToVariableAssistProposal(ICompilationUnit cu, SingleVariableDeclaration parameter, VariableDeclarationFragment existingFragment, ITypeBinding typeBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fVariableKind = 2;
        this.fNodesToAssign = new ArrayList<ASTNode>();
        this.fNodesToAssign.add((ASTNode)parameter);
        this.fTypeBinding = typeBinding;
        this.fExistingFragment = existingFragment;
        if (existingFragment == null) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assignparamtofield_description);
        } else {
            this.setDisplayName(Messages.format(CorrectionMessages.AssignToVariableAssistProposal_assigntoexistingfield_description, BasicElementLabels.getJavaElementName(existingFragment.getName().getIdentifier())));
        }
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
    }

    public AssignToVariableAssistProposal(ICompilationUnit cu, List<SingleVariableDeclaration> parameters, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fVariableKind = 2;
        this.fNodesToAssign = new ArrayList<ASTNode>();
        this.fNodesToAssign.addAll(parameters);
        this.fTypeBinding = null;
        this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assignallparamstofields_description);
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fVariableKind == 2) {
            ASTRewrite rewrite = ASTRewrite.create((AST)this.fNodesToAssign.get(0).getAST());
            if (this.fNodesToAssign.size() == 1) {
                return this.doAddField(rewrite, this.fNodesToAssign.get(0), this.fTypeBinding, 0);
            }
            return this.doAddAllFields(rewrite);
        }
        return this.doAddLocal();
    }

    private ASTRewrite doAddLocal() {
        ASTNode nodeToAssign = this.fNodesToAssign.get(0);
        Expression expression = ((ExpressionStatement)nodeToAssign).getExpression();
        AST ast = nodeToAssign.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)nodeToAssign.getRoot());
        String[] varNames = this.suggestLocalVariableNames(this.fTypeBinding, expression);
        int i = 0;
        while (i < varNames.length) {
            this.addLinkedPositionProposal("name", varNames[i], null);
            ++i;
        }
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varNames[0]));
        newDeclFrag.setInitializer((Expression)rewrite.createCopyTarget((ASTNode)expression));
        Type type = this.evaluateType(ast, nodeToAssign, this.fTypeBinding, "type");
        if (ASTNodes.isControlStatementBody(nodeToAssign.getLocationInParent())) {
            Block block = ast.newBlock();
            block.statements().add(rewrite.createMoveTarget(nodeToAssign));
            rewrite.replace(nodeToAssign, (ASTNode)block, null);
        }
        if (this.needsSemicolon(expression)) {
            VariableDeclarationStatement varStatement = ast.newVariableDeclarationStatement(newDeclFrag);
            varStatement.setType(type);
            rewrite.replace((ASTNode)expression, (ASTNode)varStatement, null);
        } else {
            VariableDeclarationExpression varExpression = ast.newVariableDeclarationExpression(newDeclFrag);
            varExpression.setType(type);
            rewrite.replace((ASTNode)expression, (ASTNode)varExpression, null);
        }
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), true, "name");
        this.addLinkedPosition(rewrite.track((ASTNode)type), false, "type");
        this.setEndPosition(rewrite.track(nodeToAssign));
        return rewrite;
    }

    private boolean needsSemicolon(Expression expression) {
        if ((expression.getParent().getFlags() & 8) != 0) {
            try {
                TokenScanner scanner = new TokenScanner((ITypeRoot)this.getCompilationUnit());
                return scanner.readNext(expression.getStartPosition() + expression.getLength(), true) != 64;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private ASTRewrite doAddField(ASTRewrite rewrite, ASTNode nodeToAssign, ITypeBinding typeBinding, int index) {
        ASTNode selectionNode;
        Block body;
        boolean isParamToField = nodeToAssign.getNodeType() == 44;
        ASTNode newTypeDecl = ASTResolving.findParentType(nodeToAssign);
        if (newTypeDecl == null) {
            return null;
        }
        SimpleName expression = isParamToField ? ((SingleVariableDeclaration)nodeToAssign).getName() : ((ExpressionStatement)nodeToAssign).getExpression();
        AST ast = newTypeDecl.getAST();
        this.createImportRewrite((CompilationUnit)nodeToAssign.getRoot());
        BodyDeclaration bodyDecl = ASTResolving.findParentBodyDeclaration(nodeToAssign);
        if (bodyDecl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)bodyDecl).getBody();
        } else if (bodyDecl instanceof Initializer) {
            body = ((Initializer)bodyDecl).getBody();
        } else {
            return null;
        }
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        boolean isAnonymous = newTypeDecl.getNodeType() == 1;
        boolean isStatic = Modifier.isStatic((int)bodyDecl.getModifiers()) && !isAnonymous;
        boolean isConstructorParam = isParamToField && nodeToAssign.getParent() instanceof MethodDeclaration && ((MethodDeclaration)nodeToAssign.getParent()).isConstructor();
        int modifiers = 2;
        if (isStatic) {
            modifiers |= 8;
        } else if (isConstructorParam) {
            String saveActionsKey = "editor_save_participant_org.eclipse.jdt.ui.postsavelistener.cleanup";
            IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE, new ProjectScope(project.getProject())};
            boolean safeActionsEnabled = Platform.getPreferencesService().getBoolean(JavaPlugin.getPluginId(), saveActionsKey, false, scopes);
            if (safeActionsEnabled && "true".equals(PreferenceConstants.getPreference("sp_cleanup.on_save_use_additional_actions", project)) && "true".equals(PreferenceConstants.getPreference("sp_cleanup.make_variable_declarations_final", project)) && "true".equals(PreferenceConstants.getPreference("sp_cleanup.make_private_fields_final", project))) {
                int constructors = 0;
                if (newTypeDecl instanceof AbstractTypeDeclaration) {
                    List bodyDeclarations = ((AbstractTypeDeclaration)newTypeDecl).bodyDeclarations();
                    for (BodyDeclaration decl : bodyDeclarations) {
                        if (!(decl instanceof MethodDeclaration) || !((MethodDeclaration)decl).isConstructor()) continue;
                        ++constructors;
                    }
                }
                if (constructors == 1) {
                    modifiers |= 0x10;
                }
            }
        }
        VariableDeclarationFragment newDeclFrag = this.addFieldDeclaration(rewrite, newTypeDecl, modifiers, (Expression)expression, nodeToAssign, typeBinding, index);
        String varName = newDeclFrag.getName().getIdentifier();
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide((Expression)rewrite.createCopyTarget((ASTNode)expression));
        boolean needsThis = StubUtility.useThisForFieldAccess(project);
        if (isParamToField) {
            needsThis |= varName.equals(expression.getIdentifier());
        }
        SimpleName accessName = ast.newSimpleName(varName);
        if (needsThis) {
            FieldAccess fieldAccess = ast.newFieldAccess();
            fieldAccess.setName(accessName);
            if (isStatic) {
                String typeName = ((AbstractTypeDeclaration)newTypeDecl).getName().getIdentifier();
                fieldAccess.setExpression((Expression)ast.newSimpleName(typeName));
            } else {
                fieldAccess.setExpression((Expression)ast.newThisExpression());
            }
            assignment.setLeftHandSide((Expression)fieldAccess);
        } else {
            assignment.setLeftHandSide((Expression)accessName);
        }
        if (isParamToField) {
            ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
            int insertIdx = this.findAssignmentInsertIndex(body.statements(), nodeToAssign) + index;
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)statement, insertIdx, null);
            selectionNode = statement;
        } else {
            if (this.needsSemicolon((Expression)expression)) {
                rewrite.replace((ASTNode)expression, (ASTNode)ast.newExpressionStatement((Expression)assignment), null);
            } else {
                rewrite.replace((ASTNode)expression, (ASTNode)assignment, null);
            }
            selectionNode = nodeToAssign;
        }
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), false, "name" + index);
        if (!isParamToField) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)newDeclFrag.getParent();
            this.addLinkedPosition(rewrite.track((ASTNode)fieldDeclaration.getType()), false, "type");
        }
        this.addLinkedPosition(rewrite.track((ASTNode)accessName), true, "name" + index);
        IVariableBinding variableBinding = newDeclFrag.resolveBinding();
        if (variableBinding != null) {
            SimpleName[] linkedNodes = LinkedNodeFinder.findByBinding(nodeToAssign.getRoot(), (IBinding)variableBinding);
            int i = 0;
            while (i < linkedNodes.length) {
                this.addLinkedPosition(rewrite.track((ASTNode)linkedNodes[i]), false, "name" + index);
                ++i;
            }
        }
        this.setEndPosition(rewrite.track(selectionNode));
        return rewrite;
    }

    private ASTRewrite doAddAllFields(ASTRewrite rewrite) {
        int i = 0;
        while (rewrite != null && i < this.fNodesToAssign.size()) {
            ASTNode nodeToAssign = this.fNodesToAssign.get(i);
            ITypeBinding typeBinding = ((SingleVariableDeclaration)nodeToAssign).resolveBinding().getType();
            rewrite = this.doAddField(rewrite, nodeToAssign, typeBinding, i);
            ++i;
        }
        return rewrite;
    }

    private VariableDeclarationFragment addFieldDeclaration(ASTRewrite rewrite, ASTNode newTypeDecl, int modifiers, Expression expression, ASTNode nodeToAssign, ITypeBinding typeBinding, int index) {
        if (this.fExistingFragment != null) {
            return this.fExistingFragment;
        }
        ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
        List<BodyDeclaration> decls = ASTNodes.getBodyDeclarations(newTypeDecl);
        AST ast = newTypeDecl.getAST();
        String[] varNames = this.suggestFieldNames(typeBinding, expression, modifiers, nodeToAssign);
        int i = 0;
        while (i < varNames.length) {
            this.addLinkedPositionProposal("name" + index, varNames[i], null);
            ++i;
        }
        String varName = varNames[0];
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        FieldDeclaration newDecl = ast.newFieldDeclaration(newDeclFrag);
        Type type = this.evaluateType(ast, nodeToAssign, typeBinding, "type" + index);
        newDecl.setType(type);
        newDecl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.getLinkedProposalModel(), rewrite, newDecl.modifiers(), false, "modifier" + index);
        int insertIndex = this.findFieldInsertIndex(decls, nodeToAssign.getStartPosition()) + index;
        rewrite.getListRewrite(newTypeDecl, property).insertAt((ASTNode)newDecl, insertIndex, null);
        return newDeclFrag;
    }

    private Type evaluateType(AST ast, ASTNode nodeToAssign, ITypeBinding typeBinding, String groupID) {
        ITypeBinding[] proposals = ASTResolving.getRelaxingTypes(ast, typeBinding);
        int i = 0;
        while (i < proposals.length) {
            this.addLinkedPositionProposal(groupID, proposals[i]);
            ++i;
        }
        ImportRewrite importRewrite = this.getImportRewrite();
        CompilationUnit cuNode = (CompilationUnit)nodeToAssign.getRoot();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(cuNode, nodeToAssign.getStartPosition(), importRewrite);
        return importRewrite.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)context);
    }

    private String[] suggestLocalVariableNames(ITypeBinding binding, Expression expression) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        return StubUtility.getVariableNameSuggestions(5, project, binding, expression, this.getUsedVariableNames(this.fNodesToAssign.get(0)));
    }

    private String[] suggestFieldNames(ITypeBinding binding, Expression expression, int modifiers, ASTNode nodeToAssign) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        int varKind = Modifier.isStatic((int)modifiers) ? 1 : 2;
        return StubUtility.getVariableNameSuggestions(varKind, project, binding, expression, this.getUsedVariableNames(nodeToAssign));
    }

    private Collection<String> getUsedVariableNames(ASTNode nodeToAssign) {
        return Arrays.asList(ASTResolving.getUsedVariableNames(nodeToAssign));
    }

    private int findAssignmentInsertIndex(List<Statement> statements, ASTNode nodeToAssign) {
        HashSet<String> paramsBefore = new HashSet<String>();
        List params = ((MethodDeclaration)nodeToAssign.getParent()).parameters();
        int i = 0;
        while (i < params.size() && params.get(i) != nodeToAssign) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)params.get(i);
            paramsBefore.add(decl.getName().getIdentifier());
            ++i;
        }
        i = 0;
        i = 0;
        while (i < statements.size()) {
            Statement curr = statements.get(i);
            switch (curr.getNodeType()) {
                case 17: 
                case 46: {
                    break;
                }
                case 21: {
                    IVariableBinding binding;
                    Assignment assignment;
                    Expression rightHand;
                    Expression expr = ((ExpressionStatement)curr).getExpression();
                    if (expr instanceof Assignment && (rightHand = (assignment = (Assignment)expr).getRightHandSide()) instanceof SimpleName && paramsBefore.contains(((SimpleName)rightHand).getIdentifier()) && ((binding = Bindings.getAssignedVariable(assignment)) == null || binding.isField())) break;
                    return i;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return i;
    }

    private int findFieldInsertIndex(List<BodyDeclaration> decls, int currPos) {
        int i = decls.size() - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FieldDeclaration && currPos > curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

