/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSavePreferences;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.ListDialog;

@Deprecated
public class RefactoringSaveHelper {
    private boolean fFilesSaved;
    private final int fSaveMode;
    public static final int SAVE_ALL_ALWAYS_ASK = 1;
    public static final int SAVE_ALL = 2;
    public static final int SAVE_NON_JAVA_UPDATES = 3;
    public static final int SAVE_JAVA_ONLY_UPDATES = 4;
    public static final int SAVE_NOTHING = 5;

    public RefactoringSaveHelper(int saveMode) {
        Assert.isTrue((saveMode == 1 || saveMode == 2 || saveMode == 3 || saveMode == 4 || saveMode == 5 ? 1 : 0) != 0);
        this.fSaveMode = saveMode;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        IEditorPart[] dirtyEditors;
        switch (this.fSaveMode) {
            case 1: 
            case 2: {
                dirtyEditors = EditorUtility.getDirtyEditors(true);
                break;
            }
            case 3: {
                dirtyEditors = EditorUtility.getDirtyEditorsToSave(false);
                break;
            }
            case 4: {
                dirtyEditors = EditorUtility.getDirtyEditorsToSave(false);
                break;
            }
            case 5: {
                return true;
            }
            default: {
                throw new IllegalStateException(Integer.toString(this.fSaveMode));
            }
        }
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!this.askSaveAllDirtyEditors(shell, dirtyEditors)) {
            return false;
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                if (this.fSaveMode == 1 || this.fSaveMode == 2 || RefactoringSavePreferences.getSaveAllEditors()) {
                    if (!JavaPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false)) {
                        return false;
                    }
                } else {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor pm) throws InterruptedException {
                            int count = dirtyEditors.length;
                            pm.beginTask("", count);
                            int i = 0;
                            while (i < count) {
                                IEditorPart editor = dirtyEditors[i];
                                editor.doSave((IProgressMonitor)new SubProgressMonitor(pm, 1));
                                if (pm.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                ++i;
                            }
                            pm.done();
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)JavaPlugin.getActiveWorkbenchWindow(), runnable, null);
                    }
                    catch (InterruptedException interruptedException) {
                        description.setAutoBuilding(autoBuild);
                        workspace.setDescription(description);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle(e, shell, RefactoringMessages.RefactoringStarter_saving, RefactoringMessages.RefactoringStarter_unexpected_exception);
                        description.setAutoBuilding(autoBuild);
                        workspace.setDescription(description);
                        return false;
                    }
                }
                this.fFilesSaved = true;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, RefactoringMessages.RefactoringStarter_saving, RefactoringMessages.RefactoringStarter_unexpected_exception);
            return false;
        }
    }

    public void triggerBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(JavaPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    private boolean askSaveAllDirtyEditors(Shell shell, IEditorPart[] dirtyEditors) {
        boolean canSaveAutomatically;
        boolean bl = canSaveAutomatically = this.fSaveMode != 1;
        if (canSaveAutomatically && RefactoringSavePreferences.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(shell){
            {
                super($anonymous0);
                this.setShellStyle(this.getShellStyle() | 0x10000);
            }

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                if (canSaveAutomatically) {
                    final Button check = new Button(result, 32);
                    check.setText(RefactoringMessages.RefactoringStarter_always_save);
                    check.setSelection(RefactoringSavePreferences.getSaveAllEditors());
                    check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RefactoringSavePreferences.setSaveAllEditors(check.getSelection());
                        }
                    });
                    2.applyDialogFont((Control)result);
                }
                return result;
            }
        };
        dialog.setTitle(RefactoringMessages.RefactoringStarter_save_all_resources);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(RefactoringMessages.RefactoringStarter_must_save);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(Arrays.asList(dirtyEditors));
        return dialog.open() == 0;
    }

    public boolean hasFilesSaved() {
        return this.fFilesSaved;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

