/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PackageSelectionDialog
extends ElementListSelectionDialog {
    public static final int F_REMOVE_DUPLICATES = 1;
    public static final int F_SHOW_PARENTS = 2;
    public static final int F_HIDE_DEFAULT_PACKAGE = 4;
    public static final int F_HIDE_EMPTY_INNER = 8;
    private Point fLocation;
    private Point fSize;
    private IRunnableContext fContext;
    private IJavaSearchScope fScope;
    private int fFlags;

    public PackageSelectionDialog(Shell parent, IRunnableContext context, int flags, IJavaSearchScope scope) {
        super(parent, PackageSelectionDialog.createLabelProvider(flags));
        this.fFlags = flags;
        this.fScope = scope;
        this.fContext = context;
    }

    private static ILabelProvider createLabelProvider(int dialogFlags) {
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        if ((dialogFlags & 1) == 0) {
            flags |= 0x40;
        }
        return new JavaElementLabelProvider(flags);
    }

    public int open() {
        final ArrayList packageList = new ArrayList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                boolean hideEmpty = (PackageSelectionDialog.this.fFlags & 8) != 0;
                monitor.beginTask(JavaUIMessages.PackageSelectionDialog_progress_search, hideEmpty ? 2 : 1);
                try {
                    try {
                        SearchRequestor requestor = new SearchRequestor(){
                            private HashSet<String> fSet = new HashSet();
                            private final boolean fAddDefault;
                            private final boolean fDuplicates;
                            private final boolean fIncludeParents;
                            {
                                this.fAddDefault = (PackageSelectionDialog.this.fFlags & 4) == 0;
                                this.fDuplicates = (PackageSelectionDialog.this.fFlags & 1) == 0;
                                this.fIncludeParents = (PackageSelectionDialog.this.fFlags & 2) != 0;
                            }

                            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                IJavaElement enclosingElement = (IJavaElement)match.getElement();
                                String name = enclosingElement.getElementName();
                                if ((this.fAddDefault || name.length() > 0) && (this.fDuplicates || this.fSet.add(name))) {
                                    packageList.add(enclosingElement);
                                    if (this.fIncludeParents) {
                                        this.addParentPackages(enclosingElement, name);
                                    }
                                }
                            }

                            private void addParentPackages(IJavaElement enclosingElement, String name) {
                                IPackageFragmentRoot root = (IPackageFragmentRoot)enclosingElement.getParent();
                                int idx = name.lastIndexOf(46);
                                while (idx != -1) {
                                    name = name.substring(0, idx);
                                    if (this.fDuplicates || this.fSet.add(name)) {
                                        packageList.add(root.getPackageFragment(name));
                                    }
                                    idx = name.lastIndexOf(46);
                                }
                            }
                        };
                        SearchPattern pattern = SearchPattern.createPattern((String)"*", (int)2, (int)0, (int)10);
                        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), PackageSelectionDialog.this.fScope, requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        if (hideEmpty) {
                            this.removeEmptyPackages((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }

            private void removeEmptyPackages(IProgressMonitor monitor) throws JavaModelException, InterruptedException {
                monitor.beginTask(JavaUIMessages.PackageSelectionDialog_progress_findEmpty, packageList.size());
                try {
                    ArrayList<IPackageFragment> res = new ArrayList<IPackageFragment>(packageList.size());
                    int i = 0;
                    while (i < packageList.size()) {
                        IPackageFragment pkg = (IPackageFragment)packageList.get(i);
                        if (pkg.hasChildren() || !pkg.hasSubpackages()) {
                            res.add(pkg);
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        ++i;
                    }
                    packageList.clear();
                    packageList.addAll(res);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.fContext.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, JavaUIMessages.PackageSelectionDialog_error_title, JavaUIMessages.PackageSelectionDialog_error3Message);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        if (packageList.isEmpty()) {
            String title = JavaUIMessages.PackageSelectionDialog_nopackages_title;
            String message = JavaUIMessages.PackageSelectionDialog_nopackages_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return 1;
        }
        this.setElements(packageList.toArray());
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.open_package_dialog_context");
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.readSettings();
        return control;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    private void readSettings() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.fLocation = new Point(x, y);
            int width = s.getInt("width");
            int height = s.getInt("height");
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
            this.fSize = null;
        }
    }

    private void writeSettings() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
    }

    private IDialogSettings getDialogSettings() {
        String sectionName;
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings subSettings = settings.getSection(sectionName = ((Object)((Object)this)).getClass().getName());
        if (subSettings == null) {
            subSettings = settings.addNewSection(sectionName);
        }
        return subSettings;
    }
}

