/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.handlers;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.handlers.Util;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class GraphVizHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = window.getSelectionService().getSelection();
        IFile gvFile = null;
        if (selection instanceof IStructuredSelection) {
            Object selObj = ((IStructuredSelection)selection).getFirstElement();
            if (selObj instanceof IFile) {
                gvFile = (IFile)selObj;
            }
        } else {
            IEditorInput editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
            if (editorInput instanceof IFileEditorInput && !Util.isGraphizFile(gvFile = ((IFileEditorInput)editorInput).getFile())) {
                gvFile = null;
            }
        }
        if (gvFile != null) {
            if (Activator.hasExternalDotGraphViewerPath()) {
                try {
                    String[] cmdLine = new String[]{Activator.strExternalDotGraphViewerPath(), gvFile.getLocation().toOSString()};
                    File workingDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                    Process viewerProcess = Runtime.getRuntime().exec(cmdLine, null, workingDir);
                    if (viewerProcess == null) {
                        System.out.println(event.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                MessageDialog.openWarning((Shell)window.getShell(), (String)"Preference Warning", (String)"Set GraphViz viewer tools preference property");
            }
        }
        return null;
    }
}

