/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VPolygonOr;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.svg.Metadata;
import java.awt.geom.Point2D;
import java.util.Vector;
import net.claribole.zgrviewer.LElem;
import net.claribole.zgrviewer.LNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LEdge
extends LElem {
    static final short UNDIRECTED = 0;
    static final short INCOMING = 1;
    static final short OUTGOING = 2;
    static final String UNDIRECTED_STR = "--";
    static final String DIRECTED_STR = "->";
    static final short GLYPH_SPLINE = 0;
    static final short GLYPH_LABEL = 1;
    static final short GLYPH_HEAD = 2;
    static final short GLYPH_TAIL = 3;
    static final short GLYPH_UNKNOWN = 4;
    short[] glyphCat;
    boolean directed = false;
    LNode tail;
    LNode head;

    LEdge(String title, Vector<Glyph> glyphs) {
        int i;
        this.title = title;
        this.glyphs = new Glyph[glyphs.size()];
        this.URLs = new String[glyphs.size()];
        this.tooltips = new String[glyphs.size()];
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i] = glyphs.elementAt(i);
            if (this.glyphs[i].getOwner() == null) continue;
            this.URLs[i] = ((Metadata)this.glyphs[i].getOwner()).getURL();
            this.tooltips[i] = ((Metadata)this.glyphs[i].getOwner()).getURLTitle();
        }
        this.groupID = this.glyphs.length > 0 ? ((Metadata)this.glyphs[0].getOwner()).getClosestAncestorGroupID() : "";
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i].setOwner(this);
        }
        this.categorizeGlyphs();
    }

    LEdge(Vector<Glyph> glyphs) {
        this.title = "";
        this.glyphs = new Glyph[glyphs.size()];
        this.URLs = new String[glyphs.size()];
        this.tooltips = new String[glyphs.size()];
        for (int i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i] = glyphs.elementAt(i);
            this.glyphs[i].setOwner(this);
            this.URLs[i] = "";
            this.tooltips[i] = "";
        }
        this.groupID = "";
        this.categorizeGlyphs();
    }

    void categorizeGlyphs() {
        this.glyphCat = new short[this.glyphs.length];
        Point2D.Double sp = this.getSpline().getStartPoint();
        Point2D.Double ep = this.getSpline().getEndPoint();
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphs[i] instanceof DPath) {
                this.glyphCat[i] = 0;
                continue;
            }
            if (this.glyphs[i] instanceof VText) {
                this.glyphCat[i] = 1;
                continue;
            }
            if (this.glyphs[i] instanceof ClosedShape) {
                if (Math.sqrt((this.glyphs[i].vx - sp.x) * (this.glyphs[i].vx - sp.x) + (this.glyphs[i].vy - sp.y) * (this.glyphs[i].vy - sp.y)) < Math.sqrt((this.glyphs[i].vx - ep.x) * (this.glyphs[i].vx - ep.x) + (this.glyphs[i].vy - ep.y) * (this.glyphs[i].vy - ep.y))) {
                    this.glyphCat[i] = 3;
                    continue;
                }
                this.glyphCat[i] = 2;
                continue;
            }
            this.glyphCat[i] = 4;
        }
    }

    @Override
    public String getURL(Glyph g) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (g != this.glyphs[i]) continue;
            return this.URLs[i];
        }
        return null;
    }

    @Override
    public String getTooltip(Glyph g) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (g != this.glyphs[i]) continue;
            return this.tooltips[i];
        }
        return null;
    }

    void setDirected(boolean b) {
        this.directed = b;
    }

    boolean isDirected() {
        return this.directed;
    }

    public boolean isLoop() {
        return this.tail == this.head;
    }

    void setTail(LNode n) {
        this.tail = n;
        if (this.tail != null) {
            this.tail.addArc(this, this.directed ? (short)2 : 0);
        }
    }

    void setHead(LNode n) {
        this.head = n;
        if (this.head != null) {
            this.head.addArc(this, this.directed ? (short)1 : 0);
        }
    }

    public LNode getTail() {
        return this.tail;
    }

    public LNode getHead() {
        return this.head;
    }

    public LNode getOtherEnd(LNode n) {
        return n == this.tail ? this.head : this.tail;
    }

    public DPath getSpline() {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphCat[i] != 0) continue;
            return (DPath)this.glyphs[i];
        }
        return null;
    }

    public ClosedShape getHeadGlyph() {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphCat[i] != 2) continue;
            return (ClosedShape)this.glyphs[i];
        }
        return null;
    }

    public ClosedShape getTailGlyph() {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphCat[i] != 3) continue;
            return (ClosedShape)this.glyphs[i];
        }
        return null;
    }

    public Glyph[] getUnknownGlyphs() {
        Vector<Glyph> res = new Vector<Glyph>(1);
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphCat[i] != 4) continue;
            res.add(this.glyphs[i]);
        }
        return res.toArray(new Glyph[res.size()]);
    }

    public boolean hasTailAndHeadGlyphs() {
        int countH = 0;
        int countT = 0;
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphCat[i] == 2) {
                ++countH;
                continue;
            }
            if (this.glyphCat[i] != 3) continue;
            ++countT;
        }
        return countH > 0 && countT > 0;
    }

    public ClosedShape replaceHead(VPolygonOr s) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphCat[i] != 2) continue;
            ClosedShape old = (ClosedShape)this.glyphs[i];
            this.glyphs[i] = s;
            s.setOwner(this);
            return old;
        }
        return null;
    }

    public ClosedShape replaceTail(VPolygonOr s) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphCat[i] != 3) continue;
            ClosedShape old = (ClosedShape)this.glyphs[i];
            this.glyphs[i] = s;
            s.setOwner(this);
            return old;
        }
        return null;
    }

    public String toString() {
        return this.title + "@" + this.hashCode() + " [" + (this.tail != null ? this.tail.getTitle() + "@" + this.tail.hashCode() : "NULL") + (this.directed ? DIRECTED_STR : UNDIRECTED_STR) + (this.head != null ? this.head.getTitle() + "@" + this.head.hashCode() : "NULL") + "]";
    }
}

