/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.projection.RProjectedCoords;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSegment<T>
extends Glyph
implements RectangularShape {
    public double vw;
    public double vh;
    RProjectedCoords[] pc;

    public VSegment(double x1, double y1, double x2, double y2, int z, Color c) {
        this(x1, y1, x2, y2, z, c, 1.0f);
    }

    public VSegment(double x1, double y1, double x2, double y2, int z, Color c, float alpha) {
        this.vx = (x1 + x2) / 2.0;
        this.vy = (y1 + y2) / 2.0;
        this.vz = z;
        this.vw = x2 - x1;
        this.vh = y2 - y1;
        this.computeSize();
        this.setColor(c);
        this.setTranslucencyValue(alpha);
    }

    public VSegment(double x, double y, int z, Color c, double lgth, double angle) {
        this(x, y, z, c, 1.0f, lgth, angle);
    }

    public VSegment(double x, double y, int z, Color c, float alpha, double lgth, double angle) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.orient = angle;
        this.size = lgth;
        this.computeEdges();
        this.setColor(c);
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new RProjectedCoords[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new RProjectedCoords();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                RProjectedCoords[] ta = this.pc;
                this.pc = new RProjectedCoords[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new RProjectedCoords();
            } else {
                System.err.println("VSegment:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new RProjectedCoords[1];
            this.pc[0] = new RProjectedCoords();
        } else {
            System.err.println("VSegment:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
        this.orient = angle;
        this.computeEdges();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public double[] getBounds() {
        double[] res = new double[]{this.vx - this.vw / 2.0, this.vy + this.vh / 2.0, this.vx + this.vw / 2.0, this.vy - this.vh / 2.0};
        return res;
    }

    public void setEndPoints(double x1, double y1, double x2, double y2) {
        this.vx = (x1 + x2) / 2.0;
        this.vy = (y1 + y2) / 2.0;
        this.vw = x2 - x1;
        this.vh = y2 - y1;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public Point2D.Double[] getEndPoints() {
        Point2D.Double[] res = new Point2D.Double[]{new Point2D.Double(this.vx + this.vw / 2.0, this.vy + this.vh / 2.0), new Point2D.Double(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0)};
        return res;
    }

    void computeSize() {
        this.size = Math.sqrt(this.vw * this.vw + this.vh * this.vh);
        if (this.vw != 0.0) {
            this.orient = Math.atan(this.vh / this.vw);
        } else {
            double d = this.orient = this.vh > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (this.orient < 0.0) {
            this.orient = this.vh > 0.0 ? Math.PI - this.orient : -this.orient;
        } else if (this.orient > 0.0) {
            this.orient = this.vh > 0.0 ? Math.PI * 2 - this.orient : Math.PI - this.orient;
        } else if (this.orient == 0.0 && this.vw < 0.0) {
            this.orient = Math.PI;
        }
    }

    @Override
    public double getWidth() {
        return this.vw;
    }

    @Override
    public double getHeight() {
        return this.vh;
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        this.computeEdges();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        this.computeEdges();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setWidth(double w) {
        this.vw = w;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setHeight(double h) {
        this.vh = h;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void setWidthHeight(double w, double h) {
        this.vw = w;
        this.vh = h;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    void computeEdges() {
        this.vw = this.size * Math.cos(this.orient);
        this.vh = this.size * Math.sin(this.orient);
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return false;
    }

    public boolean intersects(int x, int y, int camIndex) {
        return this.intersects(x, y, 2, camIndex);
    }

    public boolean intersects(int x, int y, int tolerance, int camIndex) {
        return Line2D.ptSegDist(this.pc[camIndex].cx - this.pc[camIndex].cw, this.pc[camIndex].cy + this.pc[camIndex].ch, this.pc[camIndex].cx + this.pc[camIndex].cw, this.pc[camIndex].cy - this.pc[camIndex].ch, x, y) <= (double)tolerance;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Line2D.ptSegDist(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vx + this.vw / 2.0, this.vy + this.vh / 2.0, dvx, dvy) <= dvr;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cw = (int)Math.round(this.vw / 2.0 * this.coef);
        this.pc[i].ch = (int)Math.round(this.vh / 2.0 * this.coef);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcw = (int)Math.round(this.vw / 2.0 * this.coef);
        this.pc[i].lch = (int)Math.round(this.vh / 2.0 * this.coef);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        g.setColor(this.color);
        if (this.stroke != null) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.setStroke(this.stroke);
                g.drawLine(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy + this.pc[i].ch, dx + this.pc[i].cx + this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                g.setStroke(stdS);
                g.setComposite(acO);
            } else {
                g.setStroke(this.stroke);
                g.drawLine(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy + this.pc[i].ch, dx + this.pc[i].cx + this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                g.setStroke(stdS);
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            g.drawLine(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy + this.pc[i].ch, dx + this.pc[i].cx + this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
            g.setComposite(acO);
        } else {
            g.drawLine(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy + this.pc[i].ch, dx + this.pc[i].cx + this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        g.setColor(this.color);
        if (this.stroke != null) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.setStroke(this.stroke);
                g.drawLine(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy + this.pc[i].lch, dx + this.pc[i].lcx + this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                g.setStroke(stdS);
                g.setComposite(acO);
            } else {
                g.setStroke(this.stroke);
                g.drawLine(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy + this.pc[i].lch, dx + this.pc[i].lcx + this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                g.setStroke(stdS);
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            g.drawLine(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy + this.pc[i].lch, dx + this.pc[i].lcx + this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
            g.setComposite(acO);
        } else {
            g.drawLine(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy + this.pc[i].lch, dx + this.pc[i].lcx + this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
        }
    }

    @Override
    public Shape getJava2DShape() {
        return new Line2D.Double(this.vx + this.vw / 2.0, this.vy + this.vh / 2.0, this.vx - this.vw / 2.0, this.vy - this.vh / 2.0);
    }

    @Override
    public Object clone() {
        Point2D.Double[] ep = this.getEndPoints();
        VSegment<T> res = new VSegment<T>(ep[0].x, ep[0].y, ep[1].x, ep[1].y, this.vz, this.color, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }

    @Override
    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.cursorInsideColor != null) {
                this.color = this.cursorInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.color = selectedColor;
            update = true;
        } else if (this.cursorInsideColor != null) {
            this.color = this.fColor;
            update = true;
        }
        if (update) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }
}

