/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.connector;

import io.takari.aether.connector.AetherRepositoryConnector;
import java.security.NoSuchAlgorithmException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.sisu.Nullable;

@Named(value="okhttp")
@Singleton
public final class AetherRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    private FileProcessor fileProcessor;
    private final SSLSocketFactory sslSocketFactory;

    public AetherRepositoryConnectorFactory() throws NoSuchAlgorithmException {
        this(null, null);
    }

    @Inject
    public AetherRepositoryConnectorFactory(FileProcessor fileProcessor, @Nullable SSLSocketFactory sslSocketFactory) throws NoSuchAlgorithmException {
        this.fileProcessor = fileProcessor;
        this.sslSocketFactory = sslSocketFactory != null ? sslSocketFactory : SSLContext.getDefault().getSocketFactory();
    }

    public float getPriority() {
        return Float.MAX_VALUE;
    }

    public RepositoryConnector newInstance(RepositorySystemSession repositorySystemSession, RemoteRepository remoteRepository) throws NoRepositoryConnectorException {
        ConnectorKey key = new ConnectorKey(remoteRepository);
        RepositoryConnector connector = (RepositoryConnector)repositorySystemSession.getData().get((Object)key);
        if (connector == null) {
            connector = new AetherRepositoryConnector(remoteRepository, repositorySystemSession, this.fileProcessor, this.sslSocketFactory);
            if (!repositorySystemSession.getData().set((Object)key, null, (Object)connector)) {
                connector = (RepositoryConnector)repositorySystemSession.getData().get((Object)key);
            }
        }
        return connector;
    }

    public void initService(ServiceLocator locator) {
        this.setFileProcessor((FileProcessor)locator.getService(FileProcessor.class));
    }

    public void setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = fileProcessor;
    }

    private static final class ConnectorKey {
        private final RemoteRepository repository;

        public ConnectorKey(RemoteRepository repository) {
            this.repository = repository;
        }

        public int hashCode() {
            return this.repository.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ConnectorKey && this.repository.equals((Object)((ConnectorKey)obj).repository);
        }
    }
}

