/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors.single;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.ConfigFileHandler;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.TITANConsole;
import org.eclipse.titan.executor.TITANDebugConsole;
import org.eclipse.titan.executor.designerconnection.DynamicLinkingHelper;
import org.eclipse.titan.executor.designerconnection.EnvironmentHelper;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.ExecuteDialog;
import org.eclipse.titan.executor.executors.single.MyBoolean;
import org.eclipse.titan.executor.views.executormonitor.ExecutorStorage;
import org.eclipse.titan.executor.views.executormonitor.LaunchElement;
import org.eclipse.titan.executor.views.executormonitor.LaunchStorage;
import org.eclipse.titan.executor.views.notification.Notification;
import org.eclipse.titan.executor.views.testexecution.ExecutedTestcase;
import org.eclipse.titan.executor.views.testexecution.TestExecutionView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class SingleExecutor
extends BaseExecutor {
    private static final String EXECUTION_FINISHED = "^Test case (.*) finished\\. Verdict: (.*)$";
    private static final Pattern EXECUTION_FINISHED_PATTERN = Pattern.compile("^Test case (.*) finished\\. Verdict: (.*)$");
    private final Matcher executionFinished = EXECUTION_FINISHED_PATTERN.matcher("");
    private static final String REASON = "^(.*) reason: (.*)$";
    private static final Pattern REASON_PATTERN = Pattern.compile("^(.*) reason: (.*)$");
    private final Matcher reasonMatcher = REASON_PATTERN.matcher("");
    private final Action startExecutionAction;
    private IProcess process;
    private Process proc;
    private boolean isrunning;
    private final StringBuilder builder = new StringBuilder();
    private String fastLine;
    private int fastOffset;

    public SingleExecutor(ILaunchConfiguration configuration) throws CoreException {
        super(configuration);
        if (null == this.configFilePath) {
            ErrorReporter.INTERNAL_ERROR((String)"Could not launch beacuse the configuration file's path is null");
        }
        this.isrunning = true;
        this.startExecutionAction = new Action("start execution"){

            public void run() {
                SingleExecutor.this.startExecution(false);
            }
        };
        this.startExecutionAction.setToolTipText("start execution");
        this.startExecutionAction.setEnabled(true);
    }

    @Override
    public void startSession(ILaunch arg2) {
        super.startSession(arg2);
        if (this.automaticExecuteSectionExecution) {
            if (!LaunchStorage.getLaunchElementMap().containsKey(arg2)) {
                ILaunchConfiguration launchConfiguration = arg2.getLaunchConfiguration();
                LaunchElement launchElement = new LaunchElement(launchConfiguration.getName(), arg2);
                LaunchStorage.registerLaunchElement(launchElement);
                ExecutorStorage.registerExecutorStorage(launchElement);
            }
            this.startExecution(true);
        }
    }

    private void startExecution(boolean automaticExecution) {
        IFile[] outputFiles;
        if (!this.isrunning) {
            return;
        }
        boolean invalidSelection = false;
        StringBuilder configBuilder = new StringBuilder();
        block7: do {
            ConfigFileHandler configHandler;
            if (automaticExecution && null != this.configFilePath && 0 != this.configFilePath.length() && !invalidSelection) {
                this.lastTimeSelection = "configuration file";
                this.lastTimeSelectionTime = 1;
                this.lastTimeSelectionType = ExecuteDialog.ExecutableType.CONFIGURATIONFILE;
            } else {
                final MyBoolean temp = new MyBoolean(true);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExecuteDialog dialog = new ExecuteDialog(null);
                        dialog.setControlparts(SingleExecutor.this.availableControlParts);
                        dialog.setTestsets(SingleExecutor.this.availableTestSetNames);
                        dialog.setTestcases(SingleExecutor.this.availableTestcases);
                        dialog.setConfigurationFile(SingleExecutor.this.configFilePath);
                        dialog.setSelection(SingleExecutor.this.lastTimeSelection, SingleExecutor.this.lastTimeSelectionTime, SingleExecutor.this.lastTimeSelectionType);
                        if (dialog.open() != 0) {
                            temp.setValue(false);
                            return;
                        }
                        SingleExecutor.this.lastTimeSelection = dialog.getSelectedElement();
                        SingleExecutor.this.lastTimeSelectionTime = dialog.getSelectionTimes();
                        SingleExecutor.this.lastTimeSelectionType = dialog.getSelectionType();
                    }
                });
                if (!temp.getValue()) {
                    this.executionStarted = false;
                    this.terminate(true);
                    return;
                }
            }
            if (null != this.configFilePath && this.configFilePath.length() > 0) {
                configHandler = this.readConfigFile();
            } else {
                configHandler = new ConfigFileHandler();
                this.logFileNameDefined = false;
            }
            if (configHandler.isErroneous()) {
                if (configHandler.parseExceptions().isEmpty()) {
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"An error was found while processing the configuration file", (String)"Please refer to the Error Log view for further information.");
                } else {
                    Throwable exception = (Throwable)configHandler.parseExceptions().get(configHandler.parseExceptions().size() - 1);
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while processing the configuration file", (String)(exception.getMessage() + "\n Please refer to the Error Log view for further information."));
                    ErrorReporter.logError((String)exception.getMessage());
                }
                return;
            }
            ArrayList<Integer> disallowedNodes = new ArrayList<Integer>(6);
            disallowedNodes.add(4);
            disallowedNodes.add(8);
            disallowedNodes.add(5);
            disallowedNodes.add(13);
            disallowedNodes.add(11);
            disallowedNodes.add(7);
            configBuilder = configHandler.toStringResolved(disallowedNodes);
            configBuilder.append("\n[EXECUTE]\n");
            switch (this.lastTimeSelectionType) {
                case TESTCASE: 
                case CONTROLPART: {
                    invalidSelection = false;
                    for (int i = 0; i < this.lastTimeSelectionTime; ++i) {
                        configBuilder.append(this.lastTimeSelection).append('\n');
                    }
                    continue block7;
                }
                case TESTSET: {
                    invalidSelection = false;
                    for (int i = 0; i < this.availableTestSetNames.size(); ++i) {
                        if (!((String)this.availableTestSetNames.get(i)).equals(this.lastTimeSelection)) continue;
                        for (int k = 0; k < this.lastTimeSelectionTime; ++k) {
                            configBuilder.append("// testset: ").append(this.lastTimeSelection).append('\n');
                            for (int j = 0; j < ((List)this.availableTestSetContents.get(i)).size(); ++j) {
                                configBuilder.append((String)((List)this.availableTestSetContents.get(i)).get(j));
                                configBuilder.append('\n');
                            }
                        }
                    }
                    continue block7;
                }
                case CONFIGURATIONFILE: {
                    List configurationFileElements = configHandler.getExecuteElements();
                    if (configurationFileElements.isEmpty()) {
                        invalidSelection = true;
                        Display.getDefault().syncExec((Runnable)new BaseExecutor.EmptyExecutionRunnable());
                        break;
                    }
                    invalidSelection = false;
                    for (int i = 0; i < this.lastTimeSelectionTime; ++i) {
                        for (String s : configurationFileElements) {
                            configBuilder.append(s).append('\n');
                        }
                    }
                }
            }
        } while (invalidSelection);
        this.executionStarted = true;
        this.startExecutionAction.setEnabled(false);
        File cfgFile = new File(this.configFilePath);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (IFile outputFile : outputFiles = root.findFilesForLocationURI(cfgFile.toURI())) {
            try {
                outputFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        this.createProcess(cfgFile.getAbsolutePath());
    }

    private void createProcess(String actualConfigPath) {
        File executableFile;
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Map<String, String> env = pb.environment();
        if (!this.appendEnvironmentalVariables) {
            env.clear();
        }
        if (null != this.environmentalVariables) {
            try {
                EnvironmentHelper.resolveVariables(env, this.environmentalVariables);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        if (!(executableFile = new File(this.executablePath)).exists()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError(null, (String)"Execution failed", (String)("The executable `" + executableFile + "' does not exist."));
                }
            });
        }
        EnvironmentHelper.setTitanPath(env);
        EnvironmentHelper.set_LICENSE_FILE_PATH(env);
        EnvironmentHelper.set_LD_LIBRARY_PATH(DynamicLinkingHelper.getProject(this.projectName), env);
        MessageConsole console = TITANDebugConsole.getConsole();
        ArrayList<String> command = new ArrayList<String>();
        command.add("sh");
        command.add("-c");
        command.add(" sleep 1; cd '" + PathConverter.convert((String)this.workingdirectoryPath, (boolean)true, (MessageConsole)console) + "'; '" + PathConverter.convert((String)this.executablePath, (boolean)true, (MessageConsole)console) + "' '" + PathConverter.convert((String)actualConfigPath, (boolean)true, (MessageConsole)console) + "'");
        MessageConsoleStream stream = TITANConsole.getConsole().newMessageStream();
        for (String c : command) {
            stream.print(c + ' ');
        }
        stream.println();
        pb.command(command);
        pb.redirectErrorStream(true);
        if (null != this.workingdirectoryPath) {
            File workingDir = new File(this.workingdirectoryPath);
            if (!workingDir.exists()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError(null, (String)"Execution failed", (String)("The working directory `" + SingleExecutor.this.workingdirectoryPath + "' does not exist."));
                    }
                });
            }
            pb.directory(workingDir);
        }
        try {
            IStreamsProxy proxy;
            this.proc = pb.start();
            if (null != this.mainControllerRoot) {
                ILaunch launch = ((LaunchElement)this.mainControllerRoot.parent()).launch();
                this.process = DebugPlugin.newProcess((ILaunch)launch, (Process)this.proc, (String)"Main Controller");
            }
            if (null != (proxy = this.process.getStreamsProxy())) {
                IStreamMonitor outputstreammonitor = proxy.getOutputStreamMonitor();
                IStreamListener listener = new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        SingleExecutor.this.processConsoleOutput(text);
                    }
                };
                if (null != outputstreammonitor) {
                    String temp = outputstreammonitor.getContents();
                    this.processConsoleOutput(temp);
                    outputstreammonitor.addListener(listener);
                }
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            this.proc = null;
        }
    }

    private void processConsoleOutput(String text) {
        this.builder.append(text);
        StringReader reader = new StringReader(this.builder.toString());
        BufferedReader stdout = new BufferedReader(reader);
        this.fastOffset = 0;
        this.readFullLineOnly(stdout);
        while (null != this.fastLine) {
            if (this.verdictExtraction && this.executionFinished.reset(this.fastLine).matches()) {
                String reason = this.executionFinished.group(2);
                if (this.reasonMatcher.reset(reason).matches()) {
                    this.executedTests.add(new ExecutedTestcase(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), this.executionFinished.group(1), this.reasonMatcher.group(1), this.reasonMatcher.group(2)));
                } else {
                    this.executedTests.add(new ExecutedTestcase(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), this.executionFinished.group(1), this.executionFinished.group(2), ""));
                }
                if (this.project == null) {
                    return;
                }
                try {
                    this.project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            this.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), "", "", this.fastLine));
            this.builder.delete(0, this.fastOffset);
            if (Activator.getMainView() != null) {
                Activator.getMainView().refreshIfSelected(this.mainControllerRoot);
            } else {
                TestExecutionView.refreshInput(this);
            }
            this.fastOffset = 0;
            this.readFullLineOnly(stdout);
        }
        try {
            stdout.close();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        reader.close();
    }

    public void readFullLineOnly(BufferedReader stdout) {
        try {
            this.fastLine = stdout.readLine();
            if (this.fastLine == null) {
                return;
            }
            this.fastOffset += this.fastLine.length();
            if (this.builder.length() < this.fastOffset + 1) {
                this.fastLine = null;
                return;
            }
            char c = this.builder.charAt(this.fastOffset);
            if (c == '\n') {
                ++this.fastOffset;
                return;
            }
            if (c == '\r') {
                if (this.builder.length() > this.fastOffset + 1 && this.builder.charAt(this.fastOffset + 1) == '\n') {
                    ++this.fastOffset;
                }
                ++this.fastOffset;
                return;
            }
            this.fastLine = null;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    @Override
    public boolean isTerminated() {
        return !this.isrunning;
    }

    @Override
    public IProcess getProcess() {
        return this.process;
    }

    @Override
    public void terminate(boolean external) {
        boolean result;
        this.isrunning = false;
        this.startExecutionAction.setEnabled(false);
        if (this.mainControllerRoot != null) {
            this.mainControllerRoot.setTerminated();
            LaunchElement launchElement = null;
            boolean terminatedNaturally = false;
            for (Map.Entry<ILaunch, BaseExecutor> entry : ExecutorStorage.getExecutorMap().entrySet()) {
                if (!entry.getValue().equals(this.mainControllerRoot.executor())) continue;
                terminatedNaturally = entry.getKey().isTerminated();
                if (!LaunchStorage.getLaunchElementMap().containsKey(entry.getKey())) continue;
                launchElement = LaunchStorage.getLaunchElementMap().get(entry.getKey());
            }
            if (launchElement != null && !terminatedNaturally && this.proc != null) {
                this.proc.destroy();
                try {
                    this.process.terminate();
                }
                catch (DebugException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
                launchElement.setTerminated();
            }
        }
        if (!this.keepTemporarilyGeneratedConfigFiles && this.temporalConfigFile != null && !(result = this.temporalConfigFile.delete())) {
            ErrorReporter.logError((String)("The temporal configuration file " + this.temporalConfigFile.getName() + " could not be deleted"));
            return;
        }
        super.shutdownSession();
        this.temporalConfigFile = null;
        if (Activator.getMainView() != null) {
            Activator.getMainView().refreshAll();
        }
        this.saveLastTimeUsageInfo();
    }

    @Override
    public MenuManager createMenu(MenuManager manager) {
        if (this.isrunning) {
            manager.add((IAction)this.startExecutionAction);
        }
        return super.createMenu(manager);
    }

    @Override
    protected String getDefaultLogFileName() {
        return "%e-part%i.%s";
    }
}

