/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.dialogs;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class FeatureSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.pde.ui.dialogs.FeatureSelectionDialog";
    private IFeatureModel[] fModels;
    private FeatureSearchItemsFilter filter;

    public FeatureSelectionDialog(Shell parent, IFeatureModel[] models, boolean multiSelect) {
        super(parent, multiSelect);
        this.setTitle(PDEUIMessages.FeatureSelectionDialog_title);
        this.setMessage(PDEUIMessages.FeatureSelectionDialog_message);
        this.setDetailsLabelProvider((ILabelProvider)new FeatureDetailsLabelProvider());
        this.fModels = models;
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.setListLabelProvider((ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.pde.doc.user.feature_selection");
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.pde.ui", 0, "", null);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        this.filter = new FeatureSearchItemsFilter();
        return this.filter;
    }

    protected Comparator<?> getItemsComparator() {
        return new FeatureSearchComparator();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        int i = 0;
        while (i < this.fModels.length) {
            contentProvider.add((Object)this.fModels[i], itemsFilter);
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        if (item instanceof IFeatureModel) {
            IFeatureModel model = (IFeatureModel)item;
            return model.getFeature().getId();
        }
        return null;
    }

    private final class FeatureDetailsLabelProvider
    extends LabelProvider {
        private FeatureDetailsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFeatureModel) {
                IFeatureModel featureModel = (IFeatureModel)element;
                if (FeatureSelectionDialog.this.filter.matchesFeatureId(featureModel)) {
                    return NLS.bind((String)PDEUIMessages.FeatureSelectionDialog_IdMatched, (Object)featureModel.getFeature().getId());
                }
                String pluginMatch = FeatureSelectionDialog.this.filter.matchesPluginId((IFeatureModel)element);
                if (pluginMatch != null) {
                    return NLS.bind((String)PDEUIMessages.FeatureSelectionDialog_PluginMatched, (Object)pluginMatch);
                }
            }
            return super.getText(element);
        }
    }

    private class FeatureSearchComparator
    implements Comparator<Object> {
        private FeatureSearchComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IFeatureModel) {
                return 100;
            }
            return 0;
        }

        private int compareSimilarObjects(Object o1, Object o2) {
            if (o1 instanceof IFeatureModel && o2 instanceof IFeatureModel) {
                IFeatureModel ipmb1 = (IFeatureModel)o1;
                IFeatureModel ipmb2 = (IFeatureModel)o2;
                return this.compareFeatures(ipmb1.getFeature(), ipmb2.getFeature());
            }
            return 0;
        }

        private int compareFeatures(IFeature ipmb1, IFeature ipmb2) {
            return ipmb1.getId().compareTo(ipmb2.getId());
        }
    }

    private class FeatureSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public FeatureSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)FeatureSelectionDialog.this);
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 && pattern.indexOf("?") != 0 && pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IFeatureModel) {
                IFeatureModel model = (IFeatureModel)item;
                if (this.matchesFeatureId(model)) {
                    return true;
                }
                return this.matchesPluginId(model) != null;
            }
            return false;
        }

        public String matchesPluginId(IFeatureModel model) {
            IFeaturePlugin[] plugins = model.getFeature().getPlugins();
            int i = 0;
            while (i < plugins.length) {
                if (this.matches(plugins[i].getId())) {
                    return plugins[i].getId();
                }
                ++i;
            }
            return null;
        }

        public boolean matchesFeatureId(IFeatureModel model) {
            String id = model.getFeature().getId();
            return this.matches(id);
        }
    }
}

