/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCases;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumerationItems;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Enumerated_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Enumerated_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class SelectCoverage
extends BaseModuleCodeSmellSpotter {
    private static final String ERR_MSG = "Missing select branch. The enumeration `{0}'' has {1} enumeration items, but only {2} are covered. Items not covered: {3} ";
    private final CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();

    public SelectCoverage() {
        super(CodeSmellType.SELECT_COVERAGE);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof SelectCase_Statement)) {
            return;
        }
        SelectCase_Statement s = (SelectCase_Statement)node;
        Value v = s.getExpression();
        if (v == null || v.getIsErroneous(this.timestamp)) {
            return;
        }
        SelectCases scs = s.getSelectCases();
        if (scs == null || scs.getSelectCaseArray() == null) {
            return;
        }
        for (SelectCase sc : scs.getSelectCaseArray()) {
            if (!sc.hasElse()) continue;
            return;
        }
        IType itype = v.getExpressionGovernor(this.timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (itype instanceof Referenced_Type) {
            itype = itype.getTypeRefdLast(this.timestamp);
        }
        if (itype == null || !(itype instanceof TTCN3_Enumerated_Type)) {
            return;
        }
        TTCN3_Enumerated_Type enumType = (TTCN3_Enumerated_Type)itype;
        EnumItemVisitor enumVisitor = new EnumItemVisitor();
        enumType.accept((ASTVisitor)enumVisitor);
        int enumSize = enumVisitor.getCount();
        List<Identifier> allEnumItems = enumVisitor.getItemsFound();
        CaseVisitor caseVisitor = new CaseVisitor();
        scs.accept((ASTVisitor)caseVisitor);
        List<Identifier> usedEnumItems = caseVisitor.getItemsUsed();
        if (caseVisitor.isContainsUnfoldable()) {
            return;
        }
        int casesSize = caseVisitor.getCount();
        if (enumSize > casesSize) {
            String enumName = itype.getTypename();
            String itemsNotCovered = this.getItemsNotCovered(allEnumItems, usedEnumItems);
            problems.report(v.getLocation(), MessageFormat.format(ERR_MSG, enumName, enumSize, casesSize, itemsNotCovered));
        }
    }

    private String getItemsNotCovered(List<Identifier> allEnumItems, List<Identifier> usedEnumItems) {
        if (allEnumItems == null || usedEnumItems == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        boolean start = true;
        for (Identifier id : allEnumItems) {
            if (usedEnumItems.contains(id)) continue;
            if (!start) {
                ret.append(", ");
                start = false;
            }
            ret.append(id.toString());
        }
        return ret.toString();
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(SelectCase_Statement.class);
        return ret;
    }

    private static final class EnumItemVisitor
    extends ASTVisitor {
        private List<Identifier> itemsFound = new ArrayList<Identifier>();
        private int count = 0;

        private EnumItemVisitor() {
        }

        public int getCount() {
            return this.count;
        }

        public List<Identifier> getItemsFound() {
            return this.itemsFound;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof TTCN3_Enumerated_Type) {
                return 3;
            }
            if (node instanceof EnumerationItems) {
                return 3;
            }
            if (node instanceof EnumItem) {
                this.itemsFound.add(((EnumItem)node).getId());
                ++this.count;
                return 1;
            }
            return 1;
        }
    }

    private final class CaseVisitor
    extends ASTVisitor {
        private List<Identifier> itemsUsed = new ArrayList<Identifier>();
        private int count = 0;
        private boolean containsUnfoldable = false;

        private CaseVisitor() {
        }

        public int getCount() {
            return this.count;
        }

        public List<Identifier> getItemsUsed() {
            return this.itemsUsed;
        }

        public boolean isContainsUnfoldable() {
            return this.containsUnfoldable;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof SelectCases) {
                return 3;
            }
            if (node instanceof SelectCase) {
                return 3;
            }
            if (node instanceof TemplateInstances) {
                return 3;
            }
            if (node instanceof TemplateInstance) {
                TemplateInstance ti = (TemplateInstance)node;
                IValue val = ti.getTemplateBody().getValue();
                if (val == null || val.getIsErroneous(SelectCoverage.this.timestamp) || val.isUnfoldable(SelectCoverage.this.timestamp)) {
                    this.containsUnfoldable = true;
                    return 2;
                }
                if (val instanceof Undefined_LowerIdentifier_Value && (val = val.setLoweridToReference(SelectCoverage.this.timestamp)) instanceof Enumerated_Value) {
                    Enumerated_Value ev = (Enumerated_Value)val;
                    Identifier id = ev.getValue();
                    this.itemsUsed.add(id);
                }
                ++this.count;
                return 1;
            }
            return 1;
        }
    }
}

