/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Log_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Return_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsBoundExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Log2StrExpression;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class ReadingOutParBeforeWritten
extends BaseModuleCodeSmellSpotter {
    private static final String ERR_MSG = "The out parameter `{0}'' is read before it is written.";
    private Definition toFind;
    private BaseCodeSmellSpotter.Problems problems;

    public ReadingOutParBeforeWritten() {
        super(CodeSmellType.READING_OUT_PAR_BEFORE_WRITTEN);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        this.problems = problems;
        if (!(node instanceof FormalParameter)) {
            return;
        }
        FormalParameter fp = (FormalParameter)node;
        this.toFind = fp;
        Assignment.Assignment_type at = fp.getAssignmentType();
        if (at != Assignment.Assignment_type.A_PAR_VAL_OUT && at != Assignment.Assignment_type.A_PAR_TEMP_OUT) {
            return;
        }
        Definition d = fp.getMyParameterList().getMyDefinition();
        NewFuncVisitor visitor = new NewFuncVisitor();
        d.accept((ASTVisitor)visitor);
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(FormalParameter.class);
        return ret;
    }

    private final class StatementVisitor
    extends ASTVisitor {
        private boolean written = false;
        private boolean allBlocksWritten = true;
        private boolean continueOne = false;
        private boolean refFoundInsideIsBound = false;
        private boolean isInsideIsBound = false;

        private StatementVisitor() {
        }

        public boolean isWritten() {
            return this.written;
        }

        public boolean isAllBlocksWritten() {
            return this.allBlocksWritten;
        }

        public int visit(IVisitableNode node) {
            if (this.continueOne) {
                this.continueOne = false;
                return 3;
            }
            if (node instanceof StatementBlock) {
                StatementBlockVisitor visitor = new StatementBlockVisitor();
                node.accept((ASTVisitor)visitor);
                boolean visWritten = visitor.isWritten();
                this.allBlocksWritten &= visWritten;
                return 1;
            }
            if (node instanceof IsBoundExpression) {
                this.continueOne = true;
                this.isInsideIsBound = true;
                node.accept((ASTVisitor)this);
                this.isInsideIsBound = false;
                if (this.refFoundInsideIsBound) {
                    this.written = true;
                    return 2;
                }
                return 1;
            }
            if (node instanceof Log2StrExpression) {
                return 1;
            }
            if (node instanceof Undefined_LowerIdentifier_Value) {
                ((Undefined_LowerIdentifier_Value)node).getAsReference();
                return 3;
            }
            if (node instanceof Reference) {
                Reference ref = (Reference)node;
                Assignment as = ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                if (!(as instanceof Definition)) {
                    return 1;
                }
                Definition def = (Definition)as;
                if (def.equals(ReadingOutParBeforeWritten.this.toFind)) {
                    if (ref.getUsedOnLeftHandSide()) {
                        this.written = true;
                    } else {
                        if (this.isInsideIsBound) {
                            this.refFoundInsideIsBound = true;
                            this.written = true;
                            return 1;
                        }
                        ReadingOutParBeforeWritten.this.problems.report(ref.getLocation(), MessageFormat.format(ReadingOutParBeforeWritten.ERR_MSG, node));
                    }
                }
            }
            return 3;
        }
    }

    private final class StatementBlockVisitor
    extends ASTVisitor {
        private boolean written = false;

        private StatementBlockVisitor() {
        }

        public boolean isWritten() {
            return this.written;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Statement) {
                if (node instanceof Log_Statement) {
                    return 1;
                }
                StatementVisitor visitor = new StatementVisitor();
                node.accept((ASTVisitor)visitor);
                boolean visWritten = visitor.isWritten();
                if (node instanceof If_Statement) {
                    boolean hasElse;
                    boolean allBlocksWritten = visitor.isAllBlocksWritten();
                    If_Statement ifs = (If_Statement)node;
                    boolean bl = hasElse = ifs.getStatementBlock() != null;
                    if (hasElse && allBlocksWritten) {
                        this.written = true;
                    }
                } else if (node instanceof SelectCase_Statement) {
                    boolean allBlocksWritten = visitor.isAllBlocksWritten();
                    SelectCase_Statement scs = (SelectCase_Statement)node;
                    List cases = scs.getSelectCases().getSelectCaseArray();
                    boolean hasElse = false;
                    for (SelectCase sc : cases) {
                        if (sc == null || !sc.hasElse()) continue;
                        hasElse = true;
                        break;
                    }
                    if (hasElse && allBlocksWritten) {
                        this.written = true;
                    }
                } else {
                    this.written = node instanceof Return_Statement ? true : visWritten;
                }
                if (this.written) {
                    return 2;
                }
                return 1;
            }
            return 3;
        }
    }

    private final class NewFuncVisitor
    extends ASTVisitor {
        private NewFuncVisitor() {
        }

        public int visit(IVisitableNode node) {
            if (node instanceof StatementBlock) {
                StatementBlockVisitor visitor = new StatementBlockVisitor();
                node.accept((ASTVisitor)visitor);
                return 1;
            }
            return 3;
        }
    }
}

